/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;

public class JapaneseCalendar
extends GregorianCalendar {
    public static final String RCS_ID = "$Header: JapaneseCalendar.java 120.0 2005/05/07 08:31:20 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: JapaneseCalendar.java 120.0 2005/05/07 08:31:20 appldev ship $", "oracle.apps.fnd.i18n.common.util");
    public static final int HEISEI = 237;
    public static final int SHOWA = 236;
    public static final int TAISHO = 235;
    public static final int MEIJI = 234;
    public static final int KEIO = 233;
    private static final int CURRENT_ERA = 237;
    private static final int[] eras = new int[]{1989, 1, 8, 237, 1926, 12, 25, 236, 1912, 7, 30, 235, 1868, 9, 8, 234, 1865, 4, 7, 233, 1864, 2, 20, 232, 1861, 2, 19, 231, 1860, 3, 18, 230, 1854, 11, 27, 229, 1848, 2, 28, 228, 1844, 12, 2, 227, 1830, 12, 10, 226, 1818, 4, 22, 225, 1804, 2, 11, 224, 1801, 2, 5, 223, 1789, 1, 25, 222, 1781, 4, 2, 221, 1772, 11, 16, 220, 1764, 6, 2, 219, 1751, 10, 27, 218, 1748, 7, 12, 217, 1744, 2, 21, 216, 1741, 2, 27, 215, 1736, 4, 28, 214, 1716, 6, 22, 213, 1711, 4, 25, 212, 1704, 3, 13, 211, 1688, 9, 30, 210, 1684, 2, 21, 209, 1681, 9, 29, 208, 1673, 9, 21, 207, 1661, 4, 25, 206, 1658, 7, 23, 205, 1655, 4, 13, 204, 1652, 9, 18, 203, 1648, 2, 15, 202, 1644, 12, 16, 201, 1624, 2, 30, 200, 1615, 7, 13, 199, 1596, 10, 27, 198, 1592, 12, 8, 197, 1573, 7, 28, 196, 1570, 4, 23, 195, 1558, 2, 28, 194, 1555, 10, 23, 193, 1532, 7, 29, 192, 1528, 8, 20, 191, 1521, 8, 23, 190, 1504, 2, 30, 189, 1501, 2, 29, 188, 1492, 7, 19, 187, 1489, 8, 21, 186, 1487, 7, 29, 185, 1469, 4, 28, 184, 1467, 3, 3, 183, 1466, 2, 28, 182, 1460, 12, 21, 181, 1457, 9, 28, 180, 1455, 7, 25, 179, 1452, 7, 25, 178, 1449, 7, 28, 177, 1444, 2, 5, 176, 1441, 2, 17, 175, 1429, 9, 5, 174, 1428, 4, 27, 173, 1394, 7, 5, 172, 1390, 3, 26, 171, 1389, 2, 9, 170, 1387, 8, 23, 169, 1379, 3, 22, 168, 1384, 2, 27, 167, 1384, 4, 28, 166, 1381, 2, 10, 165, 1375, 5, 27, 164, 1372, 4, 1, 163, 1370, 7, 24, 162, 1346, 12, 8, 161, 1340, 4, 28, 160, 1336, 2, 29, 159, 1334, 1, 29, 158, 1331, 8, 9, 157, 1329, 8, 29, 156, 1326, 4, 26, 155, 1324, 12, 9, 154, 1321, 2, 23, 153, 1319, 4, 28, 152, 1317, 2, 3, 151, 1312, 3, 20, 150, 1311, 4, 28, 149, 1308, 10, 9, 148, 1306, 12, 14, 147, 1303, 8, 5, 146, 1302, 11, 21, 145, 1299, 4, 25, 144, 1293, 8, 55, 143, 1288, 4, 28, 142, 1278, 2, 29, 141, 1275, 4, 25, 140, 1264, 2, 28, 139, 1261, 2, 20, 138, 1260, 4, 13, 137, 1259, 3, 26, 136, 1257, 3, 14, 135, 1256, 10, 5, 134, 1249, 3, 18, 133, 1247, 2, 28, 132, 1243, 2, 26, 131, 1240, 7, 16, 130, 1239, 2, 7, 129, 1238, 11, 23, 128, 1235, 9, 19, 127, 1234, 11, 5, 126, 1233, 4, 15, 125, 1232, 4, 2, 124, 1229, 3, 5, 123, 1227, 12, 10, 122, 1225, 4, 20, 121, 1224, 11, 20, 120, 1222, 4, 13, 119, 1219, 4, 12, 118, 1213, 12, 6, 117, 1211, 3, 9, 116, 1207, 10, 25, 115, 1206, 4, 27, 114, 1204, 2, 20, 113, 1201, 2, 13, 112, 1199, 4, 27, 111, 1190, 4, 11, 110, 1185, 8, 14, 109, 1184, 4, 16, 108, 1182, 5, 27, 107, 1181, 7, 14, 106, 1177, 8, 4, 105, 1175, 7, 28, 104, 1171, 4, 21, 103, 1169, 4, 8, 102, 1166, 8, 27, 101, 1165, 6, 5, 100, 1163, 3, 29, 99, 1161, 9, 4, 98, 1160, 1, 10, 97, 1159, 4, 20, 96, 1156, 4, 27, 95, 1154, 10, 28, 94, 1151, 1, 26, 93, 1145, 7, 22, 92, 1144, 2, 23, 91, 1142, 4, 28, 90, 1141, 7, 10, 89, 1135, 4, 27, 88, 1132, 8, 11, 87, 1131, 1, 29, 86, 1126, 1, 22, 85, 1124, 4, 3, 84, 1120, 4, 10, 83, 1118, 4, 3, 82, 1113, 7, 13, 81, 1110, 7, 13, 80, 1108, 8, 3, 79, 1106, 4, 9, 78, 1104, 2, 10, 77, 1099, 8, 28, 76, 1097, 11, 21, 75, 1096, 12, 17, 74, 1094, 12, 15, 73, 1087, 4, 7, 72, 1084, 2, 7, 71, 1081, 2, 10, 70, 1077, 11, 17, 69, 1074, 8, 23, 68, 1069, 4, 13, 67, 1065, 8, 2, 66, 1058, 8, 29, 65, 1053, 1, 11, 64, 1046, 4, 14, 63, 1044, 11, 24, 62, 1040, 11, 10, 61, 1037, 4, 21, 60, 1028, 7, 25, 59, 1024, 7, 13, 58, 1021, 2, 2, 57, 1017, 4, 23, 56, 1012, 12, 25, 55, 1004, 7, 20, 54, 999, 1, 13, 53, 995, 2, 22, 52, 990, 11, 7, 51, 989, 8, 8, 50, 987, 4, 5, 49, 985, 4, 27, 48, 983, 4, 15, 47, 978, 11, 29, 46, 976, 7, 13, 45, 973, 12, 20, 44, 970, 3, 25, 43, 968, 8, 13, 42, 964, 7, 10, 41, 961, 2, 16, 40, 957, 10, 27, 39, 947, 4, 22, 38, 938, 5, 22, 37, 931, 4, 26, 36, 923, 4, 11, 35, 901, 7, 15, 34, 898, 4, 26, 33, 889, 4, 27, 32, 885, 2, 21, 31, 877, 4, 16, 30, 859, 4, 15, 29, 857, 2, 21, 28, 854, 11, 30, 27, 851, 4, 28, 26, 848, 6, 13, 25, 834, 1, 3, 24, 824, 1, 5, 23, 810, 9, 19, 22, 806, 5, 18, 21, 782, 8, 19, 20, 781, 1, 1, 19, 770, 10, 1, 18, 767, 8, 16, 17, 765, 1, 7, 16, 757, 8, 18, 15, 749, 7, 2, 14, 749, 4, 14, 13, 729, 8, 5, 12, 724, 2, 4, 11, 717, 11, 17, 10, 715, 9, 2, 9, 708, 1, 11, 8, 704, 5, 10, 7, 701, 3, 21, 6, 686, 7, 20, 5, 672, 1, 1, 4, 650, 2, 15, 3, 645, 6, 19, 2, 1, 1, 1, 1, 0, 1, 1, 0};

    public JapaneseCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public JapaneseCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public JapaneseCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public JapaneseCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.mCalendarType = 1;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof JapaneseCalendar;
    }

    public int hashCode() {
        return super.hashCode() ^ 0x7C5;
    }

    public boolean isLeapYear(int n) {
        int n2 = this.getGrRawYearFromJpYearAndEra(this.internalGetEra(), n);
        return super.isLeapYear(n2);
    }

    public boolean isLeapYear(int n, int n2) {
        int n3 = this.getGrRawYearFromJpYearAndEra(n, n2);
        return super.isLeapYear(n3);
    }

    protected void handleEra(int n, int n2) {
        int n3 = this.getGrRawYearFromJpYearAndEra(n, n2);
        if (n3 > 1) {
            int n4 = this.getJpEraFromGrRawYear(n3);
            this.set(0, n4);
            int n5 = this.getJpYearFromGrRawYearAndJpEra(n, n3);
            this.set(1, n5);
        } else {
            this.set(0, 0);
            this.set(1, 1 - n3);
        }
    }

    protected int[] fieldInfo(long l) {
        int[] nArray = this.gregorianFieldInfo(l);
        int[] nArray2 = this.getJpYearAndEraFromGrDate(nArray[0], nArray[1], nArray[2] + 1, nArray[3]);
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        return nArray;
    }

    protected long yearToJulianDay(int n, int n2) {
        int n3 = this.getGrRawYearFromJpYearAndEra(n, n2);
        int n4 = 1;
        if (n3 < 1) {
            n4 = 0;
            n3 = 1 - n3;
        }
        return super.yearToJulianDay(n4, n3);
    }

    protected final int monthDays(int n, int n2) {
        if (n2 < 1) {
            return super.monthDays(n, n2);
        }
        int n3 = this.getGrRawYearFromJpYearAndEra(this.internalGetEra(), n2);
        return super.monthDays(n, n3);
    }

    protected final int monthDays(int n) {
        int n2 = this.internalGet(1);
        return this.monthDays(n, n2);
    }

    protected final int monthLength(int n, int n2) {
        if (n2 < 1) {
            return super.monthLength(n, n2);
        }
        int n3 = this.getGrRawYearFromJpYearAndEra(this.internalGetEra(), n2);
        return super.monthLength(n, n3);
    }

    protected final int monthLength(int n) {
        int n2 = this.internalGet(1);
        return this.monthLength(n, n2);
    }

    private int getJpEraFromGrRawYear(int n) {
        for (int i = 0; i < eras.length; i += 4) {
            if (n <= eras[i]) continue;
            return eras[i + 3];
        }
        return eras[0];
    }

    private int[] getJpYearAndEraFromGrDate(int n, int n2, int n3, int n4) {
        int[] nArray = new int[2];
        if (n2 > 0 && n != 0) {
            for (int i = 0; i < eras.length; i += 4) {
                if (n2 > eras[i]) {
                    nArray[0] = eras[i + 3];
                    nArray[1] = n2 - (eras[i] - 1);
                    return nArray;
                }
                if (n2 != eras[i]) continue;
                if (n3 > eras[i + 1]) {
                    nArray[0] = eras[i + 3];
                    nArray[1] = n2 - (eras[i] - 1);
                    return nArray;
                }
                if (n3 != eras[i + 1] || n4 < eras[i + 2]) continue;
                nArray[0] = eras[i + 3];
                nArray[1] = n2 - (eras[i] - 1);
                return nArray;
            }
            nArray[0] = eras[3];
            nArray[1] = n2 - (eras[0] - 1);
            return nArray;
        }
        nArray[0] = 0;
        nArray[1] = n2;
        return nArray;
    }

    private int getGrRawYearFromJpYearAndEra(int n, int n2) {
        if (n == 0) {
            return 1 - n2;
        }
        int n3 = 0;
        for (int i = 0; i < eras.length; i += 4) {
            int n4 = eras[i + 3];
            if (n4 != n) continue;
            n3 = eras[i] - 1;
            return n2 += n3;
        }
        return n2;
    }

    private int getJpYearFromGrRawYearAndJpEra(int n, int n2) {
        if (n == 0) {
            return 1 - n2;
        }
        int n3 = 0;
        for (int i = 0; i < eras.length; i += 4) {
            int n4 = eras[i + 3];
            if (n4 != n) continue;
            n3 = eras[i] - 1;
            return n2 -= n3;
        }
        return n2;
    }

    protected int getCurrentEra() {
        return 237;
    }
}

