/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.MimeUtility;
import oracle.apps.fnd.common.VersionInfo;

public class MimeUtil {
    public static final String RCS_ID = "$Header: MimeUtil.java 120.0 2005/05/07 08:31:25 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: MimeUtil.java 120.0 2005/05/07 08:31:25 appldev ship $", "oracle.apps.fnd.i18n.common.util");
    private static final int CASEDIFF = 32;
    private static final String UNRESERVED = new String("-_.!~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static String encodeHeader(String string, String string2, String string3) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = DEFAULT_CHARSET;
        }
        return MimeUtility.encodeText((String)string, (String)string2, (String)string3);
    }

    public static String encodeParameter(String string, String string2, String string3) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = DEFAULT_CHARSET;
        }
        if (string3 == null) {
            string3 = "";
        }
        return string2 + "'" + string3 + "'" + MimeUtil.encodeOctet(string, MimeUtil.getJavaCharsetFromMimeCharset(string2));
    }

    public static String decodeHeader(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return MimeUtility.decodeText((String)string);
    }

    public static String decodeParameter(String string) throws UnsupportedEncodingException {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 39;
        int n3 = string.indexOf(n2);
        String string2 = null;
        String string3 = null;
        if (n3 > -1) {
            string2 = string.substring(0, n3);
            n = string.indexOf(n2, n3 + 1);
            if (n <= -1) {
                return string;
            }
        } else {
            return string;
        }
        string3 = string.substring(n3 + 1, n);
        string = string.substring(n + 1, string.length());
        if (string2 == null || "".equals(string2)) {
            string2 = DEFAULT_CHARSET;
        }
        return MimeUtil.decodeOctet(string, string2);
    }

    private static String encodeOctet(String string, String string2) throws UnsupportedEncodingException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (UNRESERVED.indexOf(c) != -1) {
                stringBuffer.append(c);
                bl2 = true;
                continue;
            }
            try {
                char c2;
                if (bl2) {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string2));
                    bl2 = false;
                }
                bufferedWriter.write(c);
                if (c >= '\ud800' && c <= '\udbff' && i + 1 < string.length() && (c2 = string.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                    bufferedWriter.write(c2);
                    ++i;
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                char c3 = Character.forDigit(byArray[j] >> 4 & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
                c3 = Character.forDigit(byArray[j] & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
            }
            byteArrayOutputStream.reset();
            bl = true;
        }
        return bl ? stringBuffer.toString() : string;
    }

    private static String decodeOctet(String string, String string2) throws UnsupportedEncodingException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        if (string2.length() == 0) {
            throw new UnsupportedEncodingException("Empty string enc parameter");
        }
        block6: while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    ++n2;
                    bl = true;
                    continue block6;
                }
                case '%': {
                    try {
                        byte[] byArray = new byte[(n - n2) / 3];
                        int n3 = 0;
                        while (n2 + 2 < n && c == '%') {
                            byArray[n3++] = (byte)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                            if ((n2 += 3) >= n) continue;
                            c = string.charAt(n2);
                        }
                        if (n2 < n && c == '%') {
                            throw new IllegalArgumentException("Incomplete trailing escape (%) pattern");
                        }
                        stringBuffer.append(new String(byArray, 0, n3, string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Illegal hex characters in escape (%) pattern - " + numberFormatException.getMessage());
                    }
                    bl = true;
                    continue block6;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        return bl ? stringBuffer.toString() : string;
    }

    private static String getJavaCharsetFromMimeCharset(String string) {
        return MimeUtility.javaCharset((String)string);
    }
}

