/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.util.Hashtable;
import oracle.apps.fnd.common.VersionInfo;

public class NumberFormatMaskConverter {
    public static final String RCS_ID = "$Header: NumberFormatMaskConverter.java 120.1 2010/12/03 22:29:32 rsuzuki noship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NumberFormatMaskConverter.java 120.1 2010/12/03 22:29:32 rsuzuki noship $", "oracle.apps.fnd.i18n.common.util");
    private static Hashtable m_CachedConvertedPatternOracleToExcel = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternMSToExcel = new Hashtable(50);
    private static Hashtable m_CachedConvertedPatternJavaToExcel = new Hashtable(50);

    public static String getExcelNumberFormatFromOracle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternOracleToExcel.get(string);
        if (string2 == null) {
            String[] stringArray = new String[]{string, new String(), new String()};
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, false);
            string2 = stringArray[1];
            m_CachedConvertedPatternOracleToExcel.put(string, string2);
        }
        return string2;
    }

    private static void getExcelNumberFormatFromOracle(String[] stringArray, boolean bl) {
        if (stringArray[0] == null || stringArray[0].length() == 0) {
            stringArray[1] = stringArray[2].equals("(xxx)") ? stringArray[1] + ";(" + stringArray[1] + ")" : (stringArray[2].equals("<xxx>") ? stringArray[1] + ";<" + stringArray[1] + ">" : (stringArray[2].equals("xxx-") ? stringArray[1] + ";" + stringArray[1] + "-" : (stringArray[2].equals("xxx+") ? stringArray[1] + "+;" + stringArray[1] + "-" : (stringArray[2].equals("+xxx") ? "+" + stringArray[1] + ";-" + stringArray[1] : stringArray[1] + ";-" + stringArray[1]))));
            return;
        }
        if (stringArray[0].startsWith("L")) {
            stringArray[0] = stringArray[0].substring(1);
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("C")) {
            stringArray[0] = stringArray[0].substring(1);
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("$")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "$";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith(" ")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + " ";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("9")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = bl ? stringArray[1] + "0" : stringArray[1] + "#";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("0")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + "0";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("G") || stringArray[0].startsWith(",")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + ",";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
            return;
        }
        if (stringArray[0].startsWith("D") || stringArray[0].startsWith(".")) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1] + ".";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, true);
            return;
        }
        if (stringArray[0].startsWith("EEEE")) {
            stringArray[0] = stringArray[0].substring(4);
            stringArray[1] = stringArray[1] + "E+00";
            NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
        } else {
            if (stringArray[0].startsWith("FM")) {
                stringArray[0] = stringArray[0].substring(2);
                NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("MI")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "xxx-";
                NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("PR")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "<xxx>";
                NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("PT")) {
                stringArray[0] = stringArray[0].substring(2);
                stringArray[2] = "(xxx)";
                NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
                return;
            }
            if (stringArray[0].startsWith("S")) {
                stringArray[0] = stringArray[0].substring(1);
                stringArray[2] = stringArray[1].length() > 0 ? "xxx+" : "+xxx";
                NumberFormatMaskConverter.getExcelNumberFormatFromOracle(stringArray, bl);
                return;
            }
        }
    }

    public static String getExcelNumberFormatFromMS(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_CachedConvertedPatternMSToExcel.get(string);
        if (string2 == null) {
            string2 = NumberFormatMaskConverter.convertFromMSToExcel(string, "");
            m_CachedConvertedPatternMSToExcel.put(string, string2);
        }
        return string2;
    }

    private static String convertFromMSToExcel(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return NumberFormatMaskConverter.convertInTextFromMSToExcel(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return NumberFormatMaskConverter.convertFromMSToExcel(string, string2);
    }

    private static String convertInTextFromMSToExcel(String string, String string2) {
        if (string.startsWith("'")) {
            string = string.substring(1);
            string2 = string2 + "\"";
            return NumberFormatMaskConverter.convertFromMSToExcel(string, string2);
        }
        String string3 = string.substring(0, 1);
        string = string.substring(1);
        string2 = string2 + string3;
        return NumberFormatMaskConverter.convertInTextFromMSToExcel(string, string2);
    }

    public static String getExcelNumberFormatFromJava(String string) {
        return NumberFormatMaskConverter.getExcelNumberFormatFromMS(string);
    }
}

