/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util;

import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;

public class ROCCalendar
extends GregorianCalendar {
    public static final String RCS_ID = "$Header: ROCCalendar.java 120.0 2005/05/07 08:31:26 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: ROCCalendar.java 120.0 2005/05/07 08:31:26 appldev ship $", "oracle.apps.fnd.i18n.common.util");
    public static final int BROC = 0;
    public static final int AROC = 1;
    private static final int CURRENT_ERA = 1;
    private static final int m_YearOffset = -1911;

    public ROCCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public ROCCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public ROCCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public ROCCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.mCalendarType = 5;
    }

    public ROCCalendar(int n, int n2, int n3) {
        super(n, n2, n3);
        this.mCalendarType = 5;
    }

    public ROCCalendar(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
        this.mCalendarType = 5;
    }

    public ROCCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.mCalendarType = 5;
    }

    public ROCCalendar(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.mCalendarType = 5;
    }

    public boolean isLeapYear(int n) {
        int[] nArray = this.getGrYearFromROCYearAndEra(this.internalGetEra(), n);
        return super.isLeapYear(nArray[1]);
    }

    protected void handleEra(int n, int n2) {
        int[] nArray = this.getGrYearFromROCYearAndEra(n, n2);
        if (nArray[1] > 0) {
            n = this.getCurrentEra();
            this.set(0, n);
            n2 = this.getROCYearFromGrYearAndROCEra(n, n2);
            this.set(1, n2);
        }
    }

    protected int[] fieldInfo(long l) {
        int[] nArray = this.gregorianFieldInfo(l);
        int[] nArray2 = this.getROCYearAndEraFromGrDate(nArray[0], nArray[1], nArray[2] + 1, nArray[3]);
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[1];
        return nArray;
    }

    protected long yearToJulianDay(int n, int n2) {
        int[] nArray = this.getGrYearFromROCYearAndEra(n, n2);
        return super.yearToJulianDay(nArray[0], nArray[1]);
    }

    protected final int monthDays(int n, int n2) {
        int[] nArray = this.getGrYearFromROCYearAndEra(this.internalGetEra(), n2);
        if (nArray[0] == 0) {
            nArray[1] = 1 - n2;
        }
        return super.monthDays(n, nArray[1]);
    }

    protected final int monthDays(int n) {
        int n2 = this.internalGet(1);
        return this.monthDays(n, n2);
    }

    protected final int monthLength(int n, int n2) {
        int[] nArray = this.getGrYearFromROCYearAndEra(this.internalGetEra(), n2);
        return super.monthLength(n, nArray[1]);
    }

    protected final int monthLength(int n) {
        int n2 = this.internalGet(1);
        return this.monthLength(n, n2);
    }

    private int[] getROCYearAndEraFromGrDate(int n, int n2, int n3, int n4) {
        int[] nArray = new int[2];
        if (n == 0) {
            n2 = 1 - n2;
        }
        if (n2 + -1911 < 1) {
            nArray[0] = 0;
            nArray[1] = 1 - (n2 + -1911);
            return nArray;
        }
        nArray[0] = 1;
        nArray[1] = n2 + -1911;
        return nArray;
    }

    private int[] getGrYearFromROCYearAndEra(int n, int n2) {
        int[] nArray = new int[2];
        if (n == 0 && n2 > 0) {
            n2 = 1 - n2;
        }
        if (n2 - -1911 < 1) {
            nArray[0] = 0;
            nArray[1] = 1 - (n2 - -1911);
            return nArray;
        }
        nArray[1] = n2 - -1911;
        nArray[0] = 1;
        return nArray;
    }

    private int getROCYearFromGrYearAndROCEra(int n, int n2) {
        if (n == 0) {
            return 1 - (n2 + -1911);
        }
        return n2 + -1911;
    }

    protected int getCurrentEra() {
        return 1;
    }

    public int hashCode() {
        return super.hashCode() ^ 0x777;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof ROCCalendar;
    }
}

