/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util.resources.map;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;

public class DefaultCharsetMap {
    public static final String RCS_ID = "$Header: DefaultCharsetMap.java 120.4 2011/06/27 19:25:01 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultCharsetMap.java 120.4 2011/06/27 19:25:01 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util.resources.map");
    private static Hashtable m_OracleToIANA = new Hashtable();
    private static Hashtable m_OracleToJava;
    private static Hashtable m_JavaToOracle;
    private static Hashtable m_JavaToIANA;
    private static Hashtable m_IANAToOracle;
    private static Hashtable m_IANAToJava;

    public static String getOracleCharsetFromJava(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_JavaToOracle.get(string.toUpperCase(Locale.US));
    }

    public static String getOracleCharsetFromIANA(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_IANAToOracle.get(string.toUpperCase(Locale.US));
    }

    public static String getJavaCharsetFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_OracleToJava.get(string.toUpperCase(Locale.US));
    }

    public static String getJavaCharsetFromIANA(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_IANAToJava.get(string.toUpperCase(Locale.US));
    }

    public static String getIANACharsetFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_OracleToIANA.get(string.toUpperCase(Locale.US));
    }

    public static String getIANACharsetFromJava(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_JavaToIANA.get(string.toUpperCase(Locale.US));
    }

    static {
        m_OracleToIANA.put("AL16UTF16", "UTF-16BE");
        m_OracleToIANA.put("AL16UTF16LE", "UTF-16LE");
        m_OracleToIANA.put("AL24UTFFSS", "UTF-8");
        m_OracleToIANA.put("AL32UTF8", "UTF-8");
        m_OracleToIANA.put("AR8EBCDIC420S", "CP420");
        m_OracleToIANA.put("AR8EBCDICX", "CP420");
        m_OracleToIANA.put("AR8ISO8859P6", "ISO-8859-6");
        m_OracleToIANA.put("AR8MSAWIN", "WINDOWS-1256");
        m_OracleToIANA.put("AR8MSWIN1256", "WINDOWS-1256");
        m_OracleToIANA.put("BLT8ISO8859P13", "ISO-8859-13");
        m_OracleToIANA.put("BLT8MSWIN1257", "WINDOWS-1257");
        m_OracleToIANA.put("BLT8PC775", "CP775");
        m_OracleToIANA.put("CDN8PC863", "CP863");
        m_OracleToIANA.put("CEL8ISO8859P14", "ISO-8859-14");
        m_OracleToIANA.put("CL8ISO8859P5", "ISO-8859-5");
        m_OracleToIANA.put("CL8KOI8R", "KOI8-R");
        m_OracleToIANA.put("CL8KOI8U", "KOI8-U");
        m_OracleToIANA.put("CL8MSWIN1251", "WINDOWS-1251");
        m_OracleToIANA.put("D7DEC", "DIN_66003");
        m_OracleToIANA.put("D7SIEMENS9780X", "DIN_66003");
        m_OracleToIANA.put("D8EBCDIC1141", "CP01141");
        m_OracleToIANA.put("D8EBCDIC273", "CP273");
        m_OracleToIANA.put("DK7SIEMENS9780X", "NS_4551-1");
        m_OracleToIANA.put("DK8EBCDIC1142", "CP01142");
        m_OracleToIANA.put("DK8EBCDIC277", "IBM277");
        m_OracleToIANA.put("E7DEC", "ES");
        m_OracleToIANA.put("EE8EBCDIC870", "CP870");
        m_OracleToIANA.put("EE8EBCDIC870C", "CP870");
        m_OracleToIANA.put("EE8EBCDIC870S", "CP870");
        m_OracleToIANA.put("EE8ISO8859P2", "ISO-8859-2");
        m_OracleToIANA.put("EE8MSWIN1250", "WINDOWS-1250");
        m_OracleToIANA.put("EE8PC852", "CP852");
        m_OracleToIANA.put("EL8ISO8859P7", "ISO-8859-7");
        m_OracleToIANA.put("EL8MSWIN1253", "WINDOWS-1253");
        m_OracleToIANA.put("EL8PC851", "CP851");
        m_OracleToIANA.put("EL8PC869", "CP869");
        m_OracleToIANA.put("F7DEC", "NF_Z_62-010_(1973)");
        m_OracleToIANA.put("F8EBCDIC1147", "CP01147");
        m_OracleToIANA.put("F8EBCDIC297", "CP297");
        m_OracleToIANA.put("HZ-GB-2312", "HZ-GB-2312");
        m_OracleToIANA.put("I7DEC", "IT");
        m_OracleToIANA.put("I7SIEMENS9780X", "IT");
        m_OracleToIANA.put("I8EBCDIC1144", "CP01144");
        m_OracleToIANA.put("I8EBCDIC280", "CP280");
        m_OracleToIANA.put("IS8PC861", "CP861");
        m_OracleToIANA.put("ISO2022-CN", "ISO-2022-CN");
        m_OracleToIANA.put("ISO2022-JP", "ISO-2022-JP");
        m_OracleToIANA.put("ISO2022-KR", "ISO-2022-KR");
        m_OracleToIANA.put("IW8EBCDIC424", "CP424");
        m_OracleToIANA.put("IW8EBCDIC424S", "CP424");
        m_OracleToIANA.put("IW8ISO8859P8", "ISO-8859-8-I");
        m_OracleToIANA.put("IW8MSWIN1255", "WINDOWS-1255");
        m_OracleToIANA.put("IW8PC1507", "CP862");
        m_OracleToIANA.put("JA16EUC", "EUC-JP");
        m_OracleToIANA.put("JA16EUCTILDE", "EUC-JP");
        m_OracleToIANA.put("JA16EUCYEN", "EUC-JP");
        m_OracleToIANA.put("JA16SJIS", "WINDOWS-31J");
        m_OracleToIANA.put("JA16SJISTILDE", "WINDOWS-31J");
        m_OracleToIANA.put("JA16SJISYEN", "WINDOWS-31J");
        m_OracleToIANA.put("JA16VMS", "EUC-JP");
        m_OracleToIANA.put("KO16KSC5601", "EUC-KR");
        m_OracleToIANA.put("KO16MSWIN949", "EUC-KR");
        m_OracleToIANA.put("N7SIEMENS9780X", "NS_4551-1");
        m_OracleToIANA.put("N8PC865", "CP865");
        m_OracleToIANA.put("NE8ISO8859P10", "ISO-8859-10");
        m_OracleToIANA.put("NEE8ISO8859P4", "ISO-8859-4");
        m_OracleToIANA.put("RU8PC855", "CP855");
        m_OracleToIANA.put("RU8PC866", "CP866");
        m_OracleToIANA.put("S7SIEMENS9780X", "SEN_850200_C");
        m_OracleToIANA.put("S8EBCDIC1143", "CP01143");
        m_OracleToIANA.put("S8EBCDIC278", "CP278");
        m_OracleToIANA.put("SE8ISO8859P3", "ISO-8859-3");
        m_OracleToIANA.put("SF7ASCII", "SEN_850200_B");
        m_OracleToIANA.put("TH8TISASCII", "WINDOWS-874");
        m_OracleToIANA.put("TR8EBCDIC1026", "CP1026");
        m_OracleToIANA.put("TR8EBCDIC1026S", "CP1026");
        m_OracleToIANA.put("TR8MSWIN1254", "WINDOWS-1254");
        m_OracleToIANA.put("TR8PC857", "CP857");
        m_OracleToIANA.put("UCS2", "UTF-16");
        m_OracleToIANA.put("US7ASCII", "US-ASCII");
        m_OracleToIANA.put("US8PC437", "CP437");
        m_OracleToIANA.put("UTF16", "UTF-16");
        m_OracleToIANA.put("UTF8", "UTF-8");
        m_OracleToIANA.put("VN8MSWIN1258", "WINDOWS-1258");
        m_OracleToIANA.put("WE8DEC", "DEC-MCS");
        m_OracleToIANA.put("WE8EBCDIC1047", "IBM1047");
        m_OracleToIANA.put("WE8EBCDIC1047E", "IBM1047");
        m_OracleToIANA.put("WE8EBCDIC1140", "CP01140");
        m_OracleToIANA.put("WE8EBCDIC1140C", "CP01140");
        m_OracleToIANA.put("WE8EBCDIC1145", "CP01145");
        m_OracleToIANA.put("WE8EBCDIC1146", "CP01146");
        m_OracleToIANA.put("WE8EBCDIC1148", "CP01148");
        m_OracleToIANA.put("WE8EBCDIC1148C", "CP01148");
        m_OracleToIANA.put("WE8EBCDIC284", "CP284");
        m_OracleToIANA.put("WE8EBCDIC285", "CP285");
        m_OracleToIANA.put("WE8EBCDIC37", "CP037");
        m_OracleToIANA.put("WE8EBCDIC37C", "CP037");
        m_OracleToIANA.put("WE8EBCDIC500", "CP500");
        m_OracleToIANA.put("WE8EBCDIC500C", "CP500");
        m_OracleToIANA.put("WE8EBCDIC871", "CP871");
        m_OracleToIANA.put("WE8EBCDIC924", "CP00924");
        m_OracleToIANA.put("WE8ISO8859P1", "ISO-8859-1");
        m_OracleToIANA.put("WE8ISO8859P15", "ISO-8859-15");
        m_OracleToIANA.put("WE8ISO8859P9", "ISO-8859-9");
        m_OracleToIANA.put("WE8MACROMAN8", "MACINTOSH");
        m_OracleToIANA.put("WE8MACROMAN8S", "MACINTOSH");
        m_OracleToIANA.put("WE8MSWIN1252", "WINDOWS-1252");
        m_OracleToIANA.put("WE8NCR4970", "DEC-MCS");
        m_OracleToIANA.put("WE8PC850", "CP850");
        m_OracleToIANA.put("WE8PC858", "CP00858");
        m_OracleToIANA.put("WE8PC860", "CP860");
        m_OracleToIANA.put("WE8ROMAN8", "HP-ROMAN8");
        m_OracleToIANA.put("YUG7ASCII", "JUS_I.B1.002");
        m_OracleToIANA.put("ZHS16CGB231280", "GB2312");
        m_OracleToIANA.put("ZHS16GBK", "GBK");
        m_OracleToIANA.put("ZHS32GB18030", "GB18030");
        m_OracleToIANA.put("ZHT16BIG5", "BIG5");
        m_OracleToIANA.put("ZHT16HKSCS", "BIG5-HKSCS");
        m_OracleToIANA.put("ZHT16MSWIN950", "BIG5");
        m_OracleToJava = new Hashtable();
        m_OracleToJava.put("AL16UTF16", "UTF-16BE");
        m_OracleToJava.put("AL16UTF16LE", "UTF-16LE");
        m_OracleToJava.put("AL24UTFFSS", "UTF-8");
        m_OracleToJava.put("AL32UTF8", "UTF-8");
        m_OracleToJava.put("AR8ARABICMAC", "MacArabic");
        m_OracleToJava.put("AR8ARABICMACS", "MacArabic");
        m_OracleToJava.put("AR8ARABICMACT", "MacArabic");
        m_OracleToJava.put("AR8EBCDIC420S", "CP420");
        m_OracleToJava.put("AR8EBCDICX", "CP420");
        m_OracleToJava.put("AR8ISO8859P6", "ISO-8859-6");
        m_OracleToJava.put("AR8MSAWIN", "WINDOWS-1256");
        m_OracleToJava.put("AR8MSWIN1256", "WINDOWS-1256");
        m_OracleToJava.put("BLT8CP921", "CP921");
        m_OracleToJava.put("BLT8EBCDIC1112", "CP1112");
        m_OracleToJava.put("BLT8EBCDIC1112S", "CP1112");
        m_OracleToJava.put("BLT8ISO8859P13", "ISO-8859-13");
        m_OracleToJava.put("BLT8MSWIN1257", "WINDOWS-1257");
        m_OracleToJava.put("BLT8PC775", "CP775");
        m_OracleToJava.put("CDN8PC863", "CP863");
        m_OracleToJava.put("CL8EBCDIC1025", "CP1025");
        m_OracleToJava.put("CL8EBCDIC1025C", "CP1025");
        m_OracleToJava.put("CL8EBCDIC1025R", "CP1025");
        m_OracleToJava.put("CL8EBCDIC1025S", "CP1025");
        m_OracleToJava.put("CL8EBCDIC1025X", "CP1025");
        m_OracleToJava.put("CL8ISO8859P5", "ISO-8859-5");
        m_OracleToJava.put("CL8KOI8R", "KOI8-R");
        m_OracleToJava.put("CL8MACCYRILLIC", "MacCyrillic");
        m_OracleToJava.put("CL8MACCYRILLICS", "MacCyrillic");
        m_OracleToJava.put("CL8MSWIN1251", "WINDOWS-1251");
        m_OracleToJava.put("D8EBCDIC1141", "Cp1141");
        m_OracleToJava.put("D8EBCDIC273", "CP273");
        m_OracleToJava.put("DK8EBCDIC1142", "Cp1142");
        m_OracleToJava.put("DK8EBCDIC277", "IBM277");
        m_OracleToJava.put("EE8EBCDIC870", "CP870");
        m_OracleToJava.put("EE8EBCDIC870C", "CP870");
        m_OracleToJava.put("EE8EBCDIC870S", "CP870");
        m_OracleToJava.put("EE8ISO8859P2", "ISO-8859-2");
        m_OracleToJava.put("EE8MACCE", "MacCentralEurope");
        m_OracleToJava.put("EE8MACCES", "MacCentralEurope");
        m_OracleToJava.put("EE8MACCROATIAN", "MacCroatian");
        m_OracleToJava.put("EE8MACCROATIANS", "MacCroatian");
        m_OracleToJava.put("EE8MSWIN1250", "WINDOWS-1250");
        m_OracleToJava.put("EE8PC852", "CP852");
        m_OracleToJava.put("EL8EBCDIC875", "CP875");
        m_OracleToJava.put("EL8EBCDIC875R", "CP875");
        m_OracleToJava.put("EL8EBCDIC875S", "CP875");
        m_OracleToJava.put("EL8ISO8859P7", "ISO-8859-7");
        m_OracleToJava.put("EL8MSWIN1253", "WINDOWS-1253");
        m_OracleToJava.put("EL8PC737", "CP737");
        m_OracleToJava.put("EL8PC869", "CP869");
        m_OracleToJava.put("F8EBCDIC1147", "Cp1147");
        m_OracleToJava.put("F8EBCDIC297", "CP297");
        m_OracleToJava.put("I8EBCDIC1144", "Cp1144");
        m_OracleToJava.put("I8EBCDIC280", "CP280");
        m_OracleToJava.put("IS8MACICELANDIC", "MacIceland");
        m_OracleToJava.put("IS8MACICELANDICS", "MacIceland");
        m_OracleToJava.put("IS8PC861", "CP861");
        m_OracleToJava.put("ISO2022-CN", "ISO2022CN_GB");
        m_OracleToJava.put("ISO2022-JP", "ISO-2022-JP");
        m_OracleToJava.put("ISO2022-KR", "ISO-2022-KR");
        m_OracleToJava.put("IW8EBCDIC424", "CP424");
        m_OracleToJava.put("IW8EBCDIC424S", "CP424");
        m_OracleToJava.put("IW8ISO8859P8", "ISO-8859-8");
        m_OracleToJava.put("IW8MACHEBREW", "MacHebrew");
        m_OracleToJava.put("IW8MACHEBREWS", "MacHebrew");
        m_OracleToJava.put("IW8MSWIN1255", "WINDOWS-1255");
        m_OracleToJava.put("IW8PC1507", "CP862");
        m_OracleToJava.put("JA16EBCDIC930", "CP930");
        m_OracleToJava.put("JA16EUC", "EUC-JP");
        m_OracleToJava.put("JA16EUCTILDE", "EUC-JP");
        m_OracleToJava.put("JA16EUCYEN", "EUC-JP");
        m_OracleToJava.put("JA16SJIS", "MS932");
        m_OracleToJava.put("JA16SJISTILDE", "MS932");
        m_OracleToJava.put("JA16SJISYEN", "MS932");
        m_OracleToJava.put("JA16VMS", "EUC-JP");
        m_OracleToJava.put("KO16KSC5601", "MS949");
        m_OracleToJava.put("KO16MSWIN949", "MS949");
        m_OracleToJava.put("LT8MSWIN921", "CP921");
        m_OracleToJava.put("N8PC865", "CP865");
        m_OracleToJava.put("NEE8ISO8859P4", "ISO-8859-4");
        m_OracleToJava.put("RU8PC855", "CP855");
        m_OracleToJava.put("RU8PC866", "CP866");
        m_OracleToJava.put("S8EBCDIC1143", "Cp1143");
        m_OracleToJava.put("S8EBCDIC278", "CP278");
        m_OracleToJava.put("SE8ISO8859P3", "ISO-8859-3");
        m_OracleToJava.put("TH8MACTHAI", "MacThai");
        m_OracleToJava.put("TH8MACTHAIS", "MacThai");
        m_OracleToJava.put("TH8TISASCII", "MS874");
        m_OracleToJava.put("TH8TISEBCDIC", "CP838");
        m_OracleToJava.put("TH8TISEBCDICS", "CP838");
        m_OracleToJava.put("TR8EBCDIC1026", "CP1026");
        m_OracleToJava.put("TR8EBCDIC1026S", "CP1026");
        m_OracleToJava.put("TR8MACTURKISH", "MacTurkish");
        m_OracleToJava.put("TR8MACTURKISHS", "MacTurkish");
        m_OracleToJava.put("TR8MSWIN1254", "WINDOWS-1254");
        m_OracleToJava.put("TR8PC857", "CP857");
        m_OracleToJava.put("UCS2", "UTF-16");
        m_OracleToJava.put("US7ASCII", "US-ASCII");
        m_OracleToJava.put("US8PC437", "CP437");
        m_OracleToJava.put("UTF16", "UTF-16");
        m_OracleToJava.put("UTF8", "UTF-8");
        m_OracleToJava.put("VN8MSWIN1258", "WINDOWS-1258");
        m_OracleToJava.put("WE8EBCDIC1140", "Cp1140");
        m_OracleToJava.put("WE8EBCDIC1140C", "Cp1140");
        m_OracleToJava.put("WE8EBCDIC1145", "Cp1145");
        m_OracleToJava.put("WE8EBCDIC1146", "Cp1146");
        m_OracleToJava.put("WE8EBCDIC1148", "Cp1148");
        m_OracleToJava.put("WE8EBCDIC1148C", "Cp1148");
        m_OracleToJava.put("WE8EBCDIC284", "CP284");
        m_OracleToJava.put("WE8EBCDIC285", "CP285");
        m_OracleToJava.put("WE8EBCDIC37", "CP037");
        m_OracleToJava.put("WE8EBCDIC37C", "CP037");
        m_OracleToJava.put("WE8EBCDIC500", "CP500");
        m_OracleToJava.put("WE8EBCDIC500C", "CP500");
        m_OracleToJava.put("WE8EBCDIC871", "CP871");
        m_OracleToJava.put("WE8ISO8859P1", "ISO-8859-1");
        m_OracleToJava.put("WE8ISO8859P15", "ISO-8859-15");
        m_OracleToJava.put("WE8ISO8859P9", "ISO-8859-9");
        m_OracleToJava.put("WE8MACROMAN8", "MacRoman");
        m_OracleToJava.put("WE8MACROMAN8S", "MacRoman");
        m_OracleToJava.put("WE8MSWIN1252", "WINDOWS-1252");
        m_OracleToJava.put("WE8PC850", "CP850");
        m_OracleToJava.put("WE8PC858", "Cp858");
        m_OracleToJava.put("WE8PC860", "CP860");
        m_OracleToJava.put("ZHS16CGB231280", "EUC_CN");
        m_OracleToJava.put("ZHS16GBK", "MS936");
        m_OracleToJava.put("ZHS32GB18030", "GB18030");
        m_OracleToJava.put("ZHT16BIG5", "MS950");
        m_OracleToJava.put("ZHT16HKSCS", "MS950_HKSCS");
        m_OracleToJava.put("ZHT16MSWIN950", "MS950");
        m_OracleToJava.put("ZHT32EUC", "EUC-TW");
        m_JavaToOracle = new Hashtable();
        m_JavaToOracle.put("037", "WE8EBCDIC37");
        m_JavaToOracle.put("1025", "CL8EBCDIC1025");
        m_JavaToOracle.put("1026", "TR8EBCDIC1026");
        m_JavaToOracle.put("1089", "AR8ISO8859P6");
        m_JavaToOracle.put("1112", "BLT8EBCDIC1112");
        m_JavaToOracle.put("273", "D8EBCDIC273");
        m_JavaToOracle.put("277", "DK8EBCDIC277");
        m_JavaToOracle.put("278", "S8EBCDIC278");
        m_JavaToOracle.put("280", "I8EBCDIC280");
        m_JavaToOracle.put("284", "WE8EBCDIC284");
        m_JavaToOracle.put("285", "WE8EBCDIC285");
        m_JavaToOracle.put("297", "F8EBCDIC297");
        m_JavaToOracle.put("420", "AR8EBCDIC420S");
        m_JavaToOracle.put("424", "IW8EBCDIC424");
        m_JavaToOracle.put("437", "US8PC437");
        m_JavaToOracle.put("500", "WE8EBCDIC500");
        m_JavaToOracle.put("5601", "KO16MSWIN949");
        m_JavaToOracle.put("646", "US7ASCII");
        m_JavaToOracle.put("737", "EL8PC737");
        m_JavaToOracle.put("775", "BLT8PC775");
        m_JavaToOracle.put("813", "EL8ISO8859P7");
        m_JavaToOracle.put("819", "WE8ISO8859P1");
        m_JavaToOracle.put("838", "TH8TISEBCDIC");
        m_JavaToOracle.put("850", "WE8PC850");
        m_JavaToOracle.put("852", "EE8PC852");
        m_JavaToOracle.put("855", "RU8PC855");
        m_JavaToOracle.put("857", "TR8PC857");
        m_JavaToOracle.put("860", "WE8PC860");
        m_JavaToOracle.put("861", "IS8PC861");
        m_JavaToOracle.put("862", "IW8PC1507");
        m_JavaToOracle.put("863", "CDN8PC863");
        m_JavaToOracle.put("865", "N8PC865");
        m_JavaToOracle.put("866", "RU8PC866");
        m_JavaToOracle.put("869", "EL8PC869");
        m_JavaToOracle.put("870", "EE8EBCDIC870");
        m_JavaToOracle.put("871", "WE8EBCDIC871");
        m_JavaToOracle.put("874", "TH8TISASCII");
        m_JavaToOracle.put("875", "EL8EBCDIC875");
        m_JavaToOracle.put("8859_1", "WE8ISO8859P1");
        m_JavaToOracle.put("8859_13", "BLT8ISO8859P13");
        m_JavaToOracle.put("8859_15", "WE8ISO8859P15");
        m_JavaToOracle.put("8859_2", "EE8ISO8859P2");
        m_JavaToOracle.put("8859_3", "SE8ISO8859P3");
        m_JavaToOracle.put("8859_4", "NEE8ISO8859P4");
        m_JavaToOracle.put("8859_5", "CL8ISO8859P5");
        m_JavaToOracle.put("8859_6", "AR8ISO8859P6");
        m_JavaToOracle.put("8859_7", "EL8ISO8859P7");
        m_JavaToOracle.put("8859_8", "IW8ISO8859P8");
        m_JavaToOracle.put("8859_9", "WE8ISO8859P9");
        m_JavaToOracle.put("912", "EE8ISO8859P2");
        m_JavaToOracle.put("913", "SE8ISO8859P3");
        m_JavaToOracle.put("914", "NEE8ISO8859P4");
        m_JavaToOracle.put("915", "CL8ISO8859P5");
        m_JavaToOracle.put("916", "IW8ISO8859P8");
        m_JavaToOracle.put("920", "WE8ISO8859P9");
        m_JavaToOracle.put("921", "BLT8CP921");
        m_JavaToOracle.put("923", "WE8ISO8859P15");
        m_JavaToOracle.put("930", "JA16EBCDIC930");
        m_JavaToOracle.put("950", "ZHT16MSWIN950");
        m_JavaToOracle.put("ANSI-1251", "CL8MSWIN1251");
        m_JavaToOracle.put("ANSI_X3.4-1968", "US7ASCII");
        m_JavaToOracle.put("ARABIC", "AR8ISO8859P6");
        m_JavaToOracle.put("ASCII", "US7ASCII");
        m_JavaToOracle.put("ASCII7", "US7ASCII");
        m_JavaToOracle.put("ASMO-708", "AR8ISO8859P6");
        m_JavaToOracle.put("BIG5", "ZHT16MSWIN950");
        m_JavaToOracle.put("BIG5-HKSCS", "ZHT16HKSCS");
        m_JavaToOracle.put("BIG5-HKSCS:UNICODE3.0", "ZHT16HKSCS");
        m_JavaToOracle.put("BIG5HK", "ZHT16HKSCS");
        m_JavaToOracle.put("BIG5_HKSCS", "ZHT16HKSCS");
        m_JavaToOracle.put("BIG5_SOLARIS", "ZHT16MSWIN950");
        m_JavaToOracle.put("CNS11643", "ZHT32EUC");
        m_JavaToOracle.put("CP-GR", "EL8PC869");
        m_JavaToOracle.put("CP-IS", "IS8PC861");
        m_JavaToOracle.put("CP037", "WE8EBCDIC37");
        m_JavaToOracle.put("CP1025", "CL8EBCDIC1025");
        m_JavaToOracle.put("CP1026", "TR8EBCDIC1026");
        m_JavaToOracle.put("CP1089", "AR8ISO8859P6");
        m_JavaToOracle.put("CP1112", "BLT8EBCDIC1112");
        m_JavaToOracle.put("CP1140", "WE8EBCDIC1140");
        m_JavaToOracle.put("CP1141", "D8EBCDIC1141");
        m_JavaToOracle.put("CP1142", "DK8EBCDIC1142");
        m_JavaToOracle.put("CP1143", "S8EBCDIC1143");
        m_JavaToOracle.put("CP1144", "I8EBCDIC1144");
        m_JavaToOracle.put("CP1145", "WE8EBCDIC1145");
        m_JavaToOracle.put("CP1146", "WE8EBCDIC1146");
        m_JavaToOracle.put("CP1147", "F8EBCDIC1147");
        m_JavaToOracle.put("CP1148", "WE8EBCDIC1148");
        m_JavaToOracle.put("CP1250", "EE8MSWIN1250");
        m_JavaToOracle.put("CP1251", "CL8MSWIN1251");
        m_JavaToOracle.put("CP1252", "WE8MSWIN1252");
        m_JavaToOracle.put("CP1253", "EL8MSWIN1253");
        m_JavaToOracle.put("CP1254", "TR8MSWIN1254");
        m_JavaToOracle.put("CP1255", "IW8MSWIN1255");
        m_JavaToOracle.put("CP1256", "AR8MSWIN1256");
        m_JavaToOracle.put("CP1257", "BLT8MSWIN1257");
        m_JavaToOracle.put("CP1258", "VN8MSWIN1258");
        m_JavaToOracle.put("CP273", "D8EBCDIC273");
        m_JavaToOracle.put("CP277", "DK8EBCDIC277");
        m_JavaToOracle.put("CP278", "S8EBCDIC278");
        m_JavaToOracle.put("CP280", "I8EBCDIC280");
        m_JavaToOracle.put("CP284", "WE8EBCDIC284");
        m_JavaToOracle.put("CP285", "WE8EBCDIC285");
        m_JavaToOracle.put("CP297", "F8EBCDIC297");
        m_JavaToOracle.put("CP420", "AR8EBCDIC420S");
        m_JavaToOracle.put("CP424", "IW8EBCDIC424");
        m_JavaToOracle.put("CP437", "US8PC437");
        m_JavaToOracle.put("CP500", "WE8EBCDIC500");
        m_JavaToOracle.put("CP737", "EL8PC737");
        m_JavaToOracle.put("CP775", "BLT8PC775");
        m_JavaToOracle.put("CP813", "EL8ISO8859P7");
        m_JavaToOracle.put("CP819", "WE8ISO8859P1");
        m_JavaToOracle.put("CP838", "TH8TISEBCDIC");
        m_JavaToOracle.put("CP850", "WE8PC850");
        m_JavaToOracle.put("CP852", "EE8PC852");
        m_JavaToOracle.put("CP855", "RU8PC855");
        m_JavaToOracle.put("CP857", "TR8PC857");
        m_JavaToOracle.put("CP858", "WE8PC858");
        m_JavaToOracle.put("CP860", "WE8PC860");
        m_JavaToOracle.put("CP861", "IS8PC861");
        m_JavaToOracle.put("CP862", "IW8PC1507");
        m_JavaToOracle.put("CP863", "CDN8PC863");
        m_JavaToOracle.put("CP865", "N8PC865");
        m_JavaToOracle.put("CP866", "RU8PC866");
        m_JavaToOracle.put("CP869", "EL8PC869");
        m_JavaToOracle.put("CP870", "EE8EBCDIC870");
        m_JavaToOracle.put("CP871", "WE8EBCDIC871");
        m_JavaToOracle.put("CP874", "TH8TISASCII");
        m_JavaToOracle.put("CP875", "EL8EBCDIC875");
        m_JavaToOracle.put("CP912", "EE8ISO8859P2");
        m_JavaToOracle.put("CP913", "SE8ISO8859P3");
        m_JavaToOracle.put("CP914", "NEE8ISO8859P4");
        m_JavaToOracle.put("CP915", "CL8ISO8859P5");
        m_JavaToOracle.put("CP916", "IW8ISO8859P8");
        m_JavaToOracle.put("CP920", "WE8ISO8859P9");
        m_JavaToOracle.put("CP921", "BLT8CP921");
        m_JavaToOracle.put("CP923", "WE8ISO8859P15");
        m_JavaToOracle.put("CP930", "JA16EBCDIC930");
        m_JavaToOracle.put("CP950", "ZHT16MSWIN950");
        m_JavaToOracle.put("CSEUCPKDFMTJAPANESE", "JA16EUC");
        m_JavaToOracle.put("CSIBM857", "TR8PC857");
        m_JavaToOracle.put("CSIBM860", "WE8PC860");
        m_JavaToOracle.put("CSIBM861", "IS8PC861");
        m_JavaToOracle.put("CSIBM863", "CDN8PC863");
        m_JavaToOracle.put("CSIBM865", "N8PC865");
        m_JavaToOracle.put("CSIBM866", "RU8PC866");
        m_JavaToOracle.put("CSIBM869", "EL8PC869");
        m_JavaToOracle.put("CSISO2022JP", "ISO2022-JP");
        m_JavaToOracle.put("CSISO2022KR", "ISO2022-KR");
        m_JavaToOracle.put("CSISOLATIN0", "WE8ISO8859P15");
        m_JavaToOracle.put("CSISOLATIN1", "WE8ISO8859P1");
        m_JavaToOracle.put("CSISOLATIN2", "EE8ISO8859P2");
        m_JavaToOracle.put("CSISOLATIN3", "SE8ISO8859P3");
        m_JavaToOracle.put("CSISOLATIN4", "NEE8ISO8859P4");
        m_JavaToOracle.put("CSISOLATIN5", "WE8ISO8859P9");
        m_JavaToOracle.put("CSISOLATIN9", "WE8ISO8859P15");
        m_JavaToOracle.put("CSISOLATINARABIC", "AR8ISO8859P6");
        m_JavaToOracle.put("CSISOLATINCYRILLIC", "CL8ISO8859P5");
        m_JavaToOracle.put("CSISOLATINGREEK", "EL8ISO8859P7");
        m_JavaToOracle.put("CSISOLATINHEBREW", "IW8ISO8859P8");
        m_JavaToOracle.put("CSJISENCODING", "ISO2022-JP");
        m_JavaToOracle.put("CSKOI8R", "CL8KOI8R");
        m_JavaToOracle.put("CSPC850MULTILINGUAL", "WE8PC850");
        m_JavaToOracle.put("CSPC862LATINHEBREW", "IW8PC1507");
        m_JavaToOracle.put("CSPC8CODEPAGE437", "US8PC437");
        m_JavaToOracle.put("CSPCP852", "EE8PC852");
        m_JavaToOracle.put("CSPCP855", "RU8PC855");
        m_JavaToOracle.put("CSSHIFTJIS", "JA16SJIS");
        m_JavaToOracle.put("CSWINDOWS31J", "JA16SJIS");
        m_JavaToOracle.put("CYRILLIC", "CL8ISO8859P5");
        m_JavaToOracle.put("DEFAULT", "US7ASCII");
        m_JavaToOracle.put("ECMA-114", "AR8ISO8859P6");
        m_JavaToOracle.put("ECMA-118", "EL8ISO8859P7");
        m_JavaToOracle.put("ELOT_928", "EL8ISO8859P7");
        m_JavaToOracle.put("EUC-CN", "ZHS16CGB231280");
        m_JavaToOracle.put("EUC-JP", "JA16EUC");
        m_JavaToOracle.put("EUC-JP-LINUX", "JA16EUC");
        m_JavaToOracle.put("EUC-KR", "KO16MSWIN949");
        m_JavaToOracle.put("EUC-TW", "ZHT32EUC");
        m_JavaToOracle.put("EUCCN", "ZHS16CGB231280");
        m_JavaToOracle.put("EUCJIS", "JA16EUC");
        m_JavaToOracle.put("EUCJP", "JA16EUC");
        m_JavaToOracle.put("EUCKR", "KO16MSWIN949");
        m_JavaToOracle.put("EUCTW", "ZHT32EUC");
        m_JavaToOracle.put("EUC_CN", "ZHS16CGB231280");
        m_JavaToOracle.put("EUC_JP", "JA16EUC");
        m_JavaToOracle.put("EUC_JP_LINUX", "JA16EUC");
        m_JavaToOracle.put("EUC_KR", "KO16MSWIN949");
        m_JavaToOracle.put("EUC_TW", "ZHT32EUC");
        m_JavaToOracle.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "JA16EUC");
        m_JavaToOracle.put("GB18030", "ZHS32GB18030");
        m_JavaToOracle.put("GB2312", "ZHS16CGB231280");
        m_JavaToOracle.put("GB2312-1980", "ZHS16CGB231280");
        m_JavaToOracle.put("GB2312-80", "ZHS16CGB231280");
        m_JavaToOracle.put("GBK", "ZHS16GBK");
        m_JavaToOracle.put("GREEK", "EL8ISO8859P7");
        m_JavaToOracle.put("GREEK8", "EL8ISO8859P7");
        m_JavaToOracle.put("HEBREW", "IW8ISO8859P8");
        m_JavaToOracle.put("HKSCS", "ZHT16HKSCS");
        m_JavaToOracle.put("IBM-037", "WE8EBCDIC37");
        m_JavaToOracle.put("IBM-1025", "CL8EBCDIC1025");
        m_JavaToOracle.put("IBM-1026", "TR8EBCDIC1026");
        m_JavaToOracle.put("IBM-1089", "AR8ISO8859P6");
        m_JavaToOracle.put("IBM-1112", "BLT8EBCDIC1112");
        m_JavaToOracle.put("IBM-273", "D8EBCDIC273");
        m_JavaToOracle.put("IBM-277", "DK8EBCDIC277");
        m_JavaToOracle.put("IBM-278", "S8EBCDIC278");
        m_JavaToOracle.put("IBM-280", "I8EBCDIC280");
        m_JavaToOracle.put("IBM-284", "WE8EBCDIC284");
        m_JavaToOracle.put("IBM-285", "WE8EBCDIC285");
        m_JavaToOracle.put("IBM-297", "F8EBCDIC297");
        m_JavaToOracle.put("IBM-420", "AR8EBCDIC420S");
        m_JavaToOracle.put("IBM-424", "IW8EBCDIC424");
        m_JavaToOracle.put("IBM-437", "US8PC437");
        m_JavaToOracle.put("IBM-500", "WE8EBCDIC500");
        m_JavaToOracle.put("IBM-737", "EL8PC737");
        m_JavaToOracle.put("IBM-775", "BLT8PC775");
        m_JavaToOracle.put("IBM-813", "EL8ISO8859P7");
        m_JavaToOracle.put("IBM-819", "WE8ISO8859P1");
        m_JavaToOracle.put("IBM-838", "TH8TISEBCDIC");
        m_JavaToOracle.put("IBM-850", "WE8PC850");
        m_JavaToOracle.put("IBM-852", "EE8PC852");
        m_JavaToOracle.put("IBM-855", "RU8PC855");
        m_JavaToOracle.put("IBM-857", "TR8PC857");
        m_JavaToOracle.put("IBM-860", "WE8PC860");
        m_JavaToOracle.put("IBM-861", "IS8PC861");
        m_JavaToOracle.put("IBM-862", "IW8PC1507");
        m_JavaToOracle.put("IBM-863", "CDN8PC863");
        m_JavaToOracle.put("IBM-865", "N8PC865");
        m_JavaToOracle.put("IBM-866", "RU8PC866");
        m_JavaToOracle.put("IBM-869", "EL8PC869");
        m_JavaToOracle.put("IBM-870", "EE8EBCDIC870");
        m_JavaToOracle.put("IBM-871", "WE8EBCDIC871");
        m_JavaToOracle.put("IBM-874", "TH8TISASCII");
        m_JavaToOracle.put("IBM-875", "EL8EBCDIC875");
        m_JavaToOracle.put("IBM-912", "EE8ISO8859P2");
        m_JavaToOracle.put("IBM-913", "SE8ISO8859P3");
        m_JavaToOracle.put("IBM-914", "NEE8ISO8859P4");
        m_JavaToOracle.put("IBM-915", "CL8ISO8859P5");
        m_JavaToOracle.put("IBM-916", "IW8ISO8859P8");
        m_JavaToOracle.put("IBM-920", "WE8ISO8859P9");
        m_JavaToOracle.put("IBM-921", "BLT8CP921");
        m_JavaToOracle.put("IBM-923", "WE8ISO8859P15");
        m_JavaToOracle.put("IBM-930", "JA16EBCDIC930");
        m_JavaToOracle.put("IBM-950", "ZHT16MSWIN950");
        m_JavaToOracle.put("IBM037", "WE8EBCDIC37");
        m_JavaToOracle.put("IBM1025", "CL8EBCDIC1025");
        m_JavaToOracle.put("IBM1026", "TR8EBCDIC1026");
        m_JavaToOracle.put("IBM1089", "AR8ISO8859P6");
        m_JavaToOracle.put("IBM1112", "BLT8EBCDIC1112");
        m_JavaToOracle.put("IBM273", "D8EBCDIC273");
        m_JavaToOracle.put("IBM277", "DK8EBCDIC277");
        m_JavaToOracle.put("IBM278", "S8EBCDIC278");
        m_JavaToOracle.put("IBM280", "I8EBCDIC280");
        m_JavaToOracle.put("IBM284", "WE8EBCDIC284");
        m_JavaToOracle.put("IBM285", "WE8EBCDIC285");
        m_JavaToOracle.put("IBM297", "F8EBCDIC297");
        m_JavaToOracle.put("IBM420", "AR8EBCDIC420S");
        m_JavaToOracle.put("IBM424", "IW8EBCDIC424");
        m_JavaToOracle.put("IBM437", "US8PC437");
        m_JavaToOracle.put("IBM500", "WE8EBCDIC500");
        m_JavaToOracle.put("IBM737", "EL8PC737");
        m_JavaToOracle.put("IBM775", "BLT8PC775");
        m_JavaToOracle.put("IBM813", "EL8ISO8859P7");
        m_JavaToOracle.put("IBM819", "WE8ISO8859P1");
        m_JavaToOracle.put("IBM838", "TH8TISEBCDIC");
        m_JavaToOracle.put("IBM850", "WE8PC850");
        m_JavaToOracle.put("IBM852", "EE8PC852");
        m_JavaToOracle.put("IBM855", "RU8PC855");
        m_JavaToOracle.put("IBM857", "TR8PC857");
        m_JavaToOracle.put("IBM860", "WE8PC860");
        m_JavaToOracle.put("IBM861", "IS8PC861");
        m_JavaToOracle.put("IBM862", "IW8PC1507");
        m_JavaToOracle.put("IBM863", "CDN8PC863");
        m_JavaToOracle.put("IBM865", "N8PC865");
        m_JavaToOracle.put("IBM866", "RU8PC866");
        m_JavaToOracle.put("IBM869", "EL8PC869");
        m_JavaToOracle.put("IBM870", "EE8EBCDIC870");
        m_JavaToOracle.put("IBM871", "WE8EBCDIC871");
        m_JavaToOracle.put("IBM874", "TH8TISASCII");
        m_JavaToOracle.put("IBM875", "EL8EBCDIC875");
        m_JavaToOracle.put("IBM912", "EE8ISO8859P2");
        m_JavaToOracle.put("IBM913", "SE8ISO8859P3");
        m_JavaToOracle.put("IBM914", "NEE8ISO8859P4");
        m_JavaToOracle.put("IBM915", "CL8ISO8859P5");
        m_JavaToOracle.put("IBM916", "IW8ISO8859P8");
        m_JavaToOracle.put("IBM920", "WE8ISO8859P9");
        m_JavaToOracle.put("IBM921", "BLT8CP921");
        m_JavaToOracle.put("IBM923", "WE8ISO8859P15");
        m_JavaToOracle.put("IBM930", "JA16EBCDIC930");
        m_JavaToOracle.put("IBM950", "ZHT16MSWIN950");
        m_JavaToOracle.put("ISO-10646-UCS-2", "AL16UTF16");
        m_JavaToOracle.put("ISO-2022-JP", "ISO2022-JP");
        m_JavaToOracle.put("ISO-2022-KR", "ISO2022-KR");
        m_JavaToOracle.put("ISO-8859-1", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO-8859-13", "BLT8ISO8859P13");
        m_JavaToOracle.put("ISO-8859-15", "WE8ISO8859P15");
        m_JavaToOracle.put("ISO-8859-2", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO-8859-3", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO-8859-4", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO-8859-5", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO-8859-6", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO-8859-7", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO-8859-8", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO-8859-9", "WE8ISO8859P9");
        m_JavaToOracle.put("ISO-IR-100", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO-IR-101", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO-IR-109", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO-IR-110", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO-IR-126", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO-IR-127", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO-IR-138", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO-IR-144", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO-IR-148", "WE8ISO8859P9");
        m_JavaToOracle.put("ISO2022CN_GB", "ISO2022-CN");
        m_JavaToOracle.put("ISO2022JP", "ISO2022-JP");
        m_JavaToOracle.put("ISO2022KR", "ISO2022-KR");
        m_JavaToOracle.put("ISO646-US", "US7ASCII");
        m_JavaToOracle.put("ISO8859-1", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO8859-13", "BLT8ISO8859P13");
        m_JavaToOracle.put("ISO8859-15", "WE8ISO8859P15");
        m_JavaToOracle.put("ISO8859-2", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO8859-3", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO8859-4", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO8859-5", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO8859-6", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO8859-7", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO8859-8", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO8859-9", "WE8ISO8859P9");
        m_JavaToOracle.put("ISO8859_1", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO8859_13", "BLT8ISO8859P13");
        m_JavaToOracle.put("ISO8859_15", "WE8ISO8859P15");
        m_JavaToOracle.put("ISO8859_15_FDIS", "WE8ISO8859P15");
        m_JavaToOracle.put("ISO8859_2", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO8859_3", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO8859_4", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO8859_5", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO8859_6", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO8859_7", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO8859_8", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO8859_9", "WE8ISO8859P9");
        m_JavaToOracle.put("ISO_646.IRV:1983", "US7ASCII");
        m_JavaToOracle.put("ISO_8859-1", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO_8859-13", "BLT8ISO8859P13");
        m_JavaToOracle.put("ISO_8859-15", "WE8ISO8859P15");
        m_JavaToOracle.put("ISO_8859-1:1987", "WE8ISO8859P1");
        m_JavaToOracle.put("ISO_8859-2", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO_8859-2:1987", "EE8ISO8859P2");
        m_JavaToOracle.put("ISO_8859-3", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO_8859-3:1988", "SE8ISO8859P3");
        m_JavaToOracle.put("ISO_8859-4", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO_8859-4:1988", "NEE8ISO8859P4");
        m_JavaToOracle.put("ISO_8859-5", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO_8859-5:1988", "CL8ISO8859P5");
        m_JavaToOracle.put("ISO_8859-6", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO_8859-6:1987", "AR8ISO8859P6");
        m_JavaToOracle.put("ISO_8859-7", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO_8859-7:1987", "EL8ISO8859P7");
        m_JavaToOracle.put("ISO_8859-8", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO_8859-8:1988", "IW8ISO8859P8");
        m_JavaToOracle.put("ISO_8859-9", "WE8ISO8859P9");
        m_JavaToOracle.put("JIS", "ISO2022-JP");
        m_JavaToOracle.put("JIS_ENCODING", "ISO2022-JP");
        m_JavaToOracle.put("KOI8", "CL8KOI8R");
        m_JavaToOracle.put("KOI8-R", "CL8KOI8R");
        m_JavaToOracle.put("KOI8_R", "CL8KOI8R");
        m_JavaToOracle.put("KSC5601", "KO16MSWIN949");
        m_JavaToOracle.put("KSC5601-1987", "KO16MSWIN949");
        m_JavaToOracle.put("KSC5601_1987", "KO16MSWIN949");
        m_JavaToOracle.put("KSC_5601", "KO16MSWIN949");
        m_JavaToOracle.put("KS_C_5601-1987", "KO16MSWIN949");
        m_JavaToOracle.put("L1", "WE8ISO8859P1");
        m_JavaToOracle.put("L2", "EE8ISO8859P2");
        m_JavaToOracle.put("L3", "SE8ISO8859P3");
        m_JavaToOracle.put("L4", "NEE8ISO8859P4");
        m_JavaToOracle.put("L5", "WE8ISO8859P9");
        m_JavaToOracle.put("LATIN0", "WE8ISO8859P15");
        m_JavaToOracle.put("LATIN1", "WE8ISO8859P1");
        m_JavaToOracle.put("LATIN2", "EE8ISO8859P2");
        m_JavaToOracle.put("LATIN3", "SE8ISO8859P3");
        m_JavaToOracle.put("LATIN4", "NEE8ISO8859P4");
        m_JavaToOracle.put("LATIN5", "WE8ISO8859P9");
        m_JavaToOracle.put("LATIN9", "WE8ISO8859P15");
        m_JavaToOracle.put("MACARABIC", "AR8ARABICMAC");
        m_JavaToOracle.put("MACCENTRALEUROPE", "EE8MACCE");
        m_JavaToOracle.put("MACCROATIAN", "EE8MACCROATIAN");
        m_JavaToOracle.put("MACCYRILLIC", "CL8MACCYRILLIC");
        m_JavaToOracle.put("MACHEBREW", "IW8MACHEBREW");
        m_JavaToOracle.put("MACICELAND", "IS8MACICELANDIC");
        m_JavaToOracle.put("MACROMAN", "WE8MACROMAN8");
        m_JavaToOracle.put("MACTHAI", "TH8MACTHAI");
        m_JavaToOracle.put("MACTURKISH", "TR8MACTURKISH");
        m_JavaToOracle.put("MS874", "TH8TISASCII");
        m_JavaToOracle.put("MS932", "JA16SJIS");
        m_JavaToOracle.put("MS936", "ZHS16GBK");
        m_JavaToOracle.put("MS949", "KO16MSWIN949");
        m_JavaToOracle.put("MS950", "ZHT16MSWIN950");
        m_JavaToOracle.put("MS950_HKSCS", "ZHT16HKSCS");
        m_JavaToOracle.put("MS_KANJI", "JA16SJIS");
        m_JavaToOracle.put("PCK", "JA16SJIS");
        m_JavaToOracle.put("SHIFT_JIS", "JA16SJIS");
        m_JavaToOracle.put("SJIS", "JA16SJIS");
        m_JavaToOracle.put("TIS-620", "TH8TISASCII");
        m_JavaToOracle.put("TIS620", "TH8TISASCII");
        m_JavaToOracle.put("TIS620.2533", "TH8TISASCII");
        m_JavaToOracle.put("UNICODE-1-1", "AL16UTF16");
        m_JavaToOracle.put("UNICODE-1-1-UTF-8", "UTF8");
        m_JavaToOracle.put("UNICODEBIGUNMARKED", "AL16UTF16");
        m_JavaToOracle.put("UNICODELITTLEUNMARKED", "AL16UTF16LE");
        m_JavaToOracle.put("US-ASCII", "US7ASCII");
        m_JavaToOracle.put("UTF-16", "UTF16");
        m_JavaToOracle.put("UTF-16BE", "AL16UTF16");
        m_JavaToOracle.put("UTF-16LE", "AL16UTF16LE");
        m_JavaToOracle.put("UTF-8", "UTF8");
        m_JavaToOracle.put("UTF16", "UTF16");
        m_JavaToOracle.put("UTF8", "UTF8");
        m_JavaToOracle.put("WINDOWS-1250", "EE8MSWIN1250");
        m_JavaToOracle.put("WINDOWS-1251", "CL8MSWIN1251");
        m_JavaToOracle.put("WINDOWS-1252", "WE8MSWIN1252");
        m_JavaToOracle.put("WINDOWS-1253", "EL8MSWIN1253");
        m_JavaToOracle.put("WINDOWS-1254", "TR8MSWIN1254");
        m_JavaToOracle.put("WINDOWS-1255", "IW8MSWIN1255");
        m_JavaToOracle.put("WINDOWS-1256", "AR8MSWIN1256");
        m_JavaToOracle.put("WINDOWS-1257", "BLT8MSWIN1257");
        m_JavaToOracle.put("WINDOWS-1258", "VN8MSWIN1258");
        m_JavaToOracle.put("WINDOWS-31J", "JA16SJIS");
        m_JavaToOracle.put("WINDOWS-874", "TH8TISASCII");
        m_JavaToOracle.put("WINDOWS-949", "KO16MSWIN949");
        m_JavaToOracle.put("X-EUC-JP", "JA16EUC");
        m_JavaToOracle.put("X-EUCJP", "JA16EUC");
        m_JavaToOracle.put("X-SJIS", "JA16SJIS");
        m_JavaToOracle.put("X-UTF-16BE", "AL16UTF16");
        m_JavaToOracle.put("X-UTF-16LE", "AL16UTF16LE");
        m_JavaToIANA = new Hashtable();
        m_JavaToIANA.put("037", "CP037");
        m_JavaToIANA.put("1026", "CP1026");
        m_JavaToIANA.put("1089", "ISO-8859-6");
        m_JavaToIANA.put("273", "CP273");
        m_JavaToIANA.put("277", "IBM277");
        m_JavaToIANA.put("278", "CP278");
        m_JavaToIANA.put("280", "CP280");
        m_JavaToIANA.put("284", "CP284");
        m_JavaToIANA.put("285", "CP285");
        m_JavaToIANA.put("297", "CP297");
        m_JavaToIANA.put("420", "CP420");
        m_JavaToIANA.put("424", "CP424");
        m_JavaToIANA.put("437", "CP437");
        m_JavaToIANA.put("500", "CP500");
        m_JavaToIANA.put("5601", "EUC-KR");
        m_JavaToIANA.put("646", "US-ASCII");
        m_JavaToIANA.put("775", "CP775");
        m_JavaToIANA.put("813", "ISO-8859-7");
        m_JavaToIANA.put("819", "ISO-8859-1");
        m_JavaToIANA.put("850", "CP850");
        m_JavaToIANA.put("852", "CP852");
        m_JavaToIANA.put("855", "CP855");
        m_JavaToIANA.put("857", "CP857");
        m_JavaToIANA.put("860", "CP860");
        m_JavaToIANA.put("861", "CP861");
        m_JavaToIANA.put("862", "CP862");
        m_JavaToIANA.put("863", "CP863");
        m_JavaToIANA.put("865", "CP865");
        m_JavaToIANA.put("866", "CP866");
        m_JavaToIANA.put("869", "CP869");
        m_JavaToIANA.put("870", "CP870");
        m_JavaToIANA.put("871", "CP871");
        m_JavaToIANA.put("874", "WINDOWS-874");
        m_JavaToIANA.put("8859_1", "ISO-8859-1");
        m_JavaToIANA.put("8859_13", "ISO-8859-13");
        m_JavaToIANA.put("8859_15", "ISO-8859-15");
        m_JavaToIANA.put("8859_2", "ISO-8859-2");
        m_JavaToIANA.put("8859_3", "ISO-8859-3");
        m_JavaToIANA.put("8859_4", "ISO-8859-4");
        m_JavaToIANA.put("8859_5", "ISO-8859-5");
        m_JavaToIANA.put("8859_6", "ISO-8859-6");
        m_JavaToIANA.put("8859_7", "ISO-8859-7");
        m_JavaToIANA.put("8859_8", "ISO-8859-8-I");
        m_JavaToIANA.put("8859_9", "ISO-8859-9");
        m_JavaToIANA.put("912", "ISO-8859-2");
        m_JavaToIANA.put("913", "ISO-8859-3");
        m_JavaToIANA.put("914", "ISO-8859-4");
        m_JavaToIANA.put("915", "ISO-8859-5");
        m_JavaToIANA.put("916", "ISO-8859-8-I");
        m_JavaToIANA.put("920", "ISO-8859-9");
        m_JavaToIANA.put("923", "ISO-8859-15");
        m_JavaToIANA.put("950", "BIG5");
        m_JavaToIANA.put("ANSI-1251", "WINDOWS-1251");
        m_JavaToIANA.put("ANSI_X3.4-1968", "US-ASCII");
        m_JavaToIANA.put("ARABIC", "ISO-8859-6");
        m_JavaToIANA.put("ASCII", "US-ASCII");
        m_JavaToIANA.put("ASCII7", "US-ASCII");
        m_JavaToIANA.put("ASMO-708", "ISO-8859-6");
        m_JavaToIANA.put("BIG5", "BIG5");
        m_JavaToIANA.put("BIG5-HKSCS", "BIG5-HKSCS");
        m_JavaToIANA.put("BIG5-HKSCS:UNICODE3.0", "BIG5-HKSCS");
        m_JavaToIANA.put("BIG5HK", "BIG5-HKSCS");
        m_JavaToIANA.put("BIG5_HKSCS", "BIG5-HKSCS");
        m_JavaToIANA.put("BIG5_SOLARIS", "BIG5");
        m_JavaToIANA.put("CP-GR", "CP869");
        m_JavaToIANA.put("CP-IS", "CP861");
        m_JavaToIANA.put("CP037", "CP037");
        m_JavaToIANA.put("CP1026", "CP1026");
        m_JavaToIANA.put("CP1089", "ISO-8859-6");
        m_JavaToIANA.put("CP1140", "CP01140");
        m_JavaToIANA.put("CP1141", "CP01141");
        m_JavaToIANA.put("CP1142", "CP01142");
        m_JavaToIANA.put("CP1143", "CP01143");
        m_JavaToIANA.put("CP1144", "CP01144");
        m_JavaToIANA.put("CP1145", "CP01145");
        m_JavaToIANA.put("CP1146", "CP01146");
        m_JavaToIANA.put("CP1147", "CP01147");
        m_JavaToIANA.put("CP1148", "CP01148");
        m_JavaToIANA.put("CP1250", "WINDOWS-1250");
        m_JavaToIANA.put("CP1251", "WINDOWS-1251");
        m_JavaToIANA.put("CP1252", "WINDOWS-1252");
        m_JavaToIANA.put("CP1253", "WINDOWS-1253");
        m_JavaToIANA.put("CP1254", "WINDOWS-1254");
        m_JavaToIANA.put("CP1255", "WINDOWS-1255");
        m_JavaToIANA.put("CP1256", "WINDOWS-1256");
        m_JavaToIANA.put("CP1257", "WINDOWS-1257");
        m_JavaToIANA.put("CP1258", "WINDOWS-1258");
        m_JavaToIANA.put("CP273", "CP273");
        m_JavaToIANA.put("CP277", "IBM277");
        m_JavaToIANA.put("CP278", "CP278");
        m_JavaToIANA.put("CP280", "CP280");
        m_JavaToIANA.put("CP284", "CP284");
        m_JavaToIANA.put("CP285", "CP285");
        m_JavaToIANA.put("CP297", "CP297");
        m_JavaToIANA.put("CP420", "CP420");
        m_JavaToIANA.put("CP424", "CP424");
        m_JavaToIANA.put("CP437", "CP437");
        m_JavaToIANA.put("CP500", "CP500");
        m_JavaToIANA.put("CP775", "CP775");
        m_JavaToIANA.put("CP813", "ISO-8859-7");
        m_JavaToIANA.put("CP819", "ISO-8859-1");
        m_JavaToIANA.put("CP850", "CP850");
        m_JavaToIANA.put("CP852", "CP852");
        m_JavaToIANA.put("CP855", "CP855");
        m_JavaToIANA.put("CP857", "CP857");
        m_JavaToIANA.put("CP858", "CP00858");
        m_JavaToIANA.put("CP860", "CP860");
        m_JavaToIANA.put("CP861", "CP861");
        m_JavaToIANA.put("CP862", "CP862");
        m_JavaToIANA.put("CP863", "CP863");
        m_JavaToIANA.put("CP865", "CP865");
        m_JavaToIANA.put("CP866", "CP866");
        m_JavaToIANA.put("CP869", "CP869");
        m_JavaToIANA.put("CP870", "CP870");
        m_JavaToIANA.put("CP871", "CP871");
        m_JavaToIANA.put("CP874", "WINDOWS-874");
        m_JavaToIANA.put("CP912", "ISO-8859-2");
        m_JavaToIANA.put("CP913", "ISO-8859-3");
        m_JavaToIANA.put("CP914", "ISO-8859-4");
        m_JavaToIANA.put("CP915", "ISO-8859-5");
        m_JavaToIANA.put("CP916", "ISO-8859-8-I");
        m_JavaToIANA.put("CP920", "ISO-8859-9");
        m_JavaToIANA.put("CP923", "ISO-8859-15");
        m_JavaToIANA.put("CP950", "BIG5");
        m_JavaToIANA.put("CSEUCPKDFMTJAPANESE", "EUC-JP");
        m_JavaToIANA.put("CSIBM857", "CP857");
        m_JavaToIANA.put("CSIBM860", "CP860");
        m_JavaToIANA.put("CSIBM861", "CP861");
        m_JavaToIANA.put("CSIBM863", "CP863");
        m_JavaToIANA.put("CSIBM865", "CP865");
        m_JavaToIANA.put("CSIBM866", "CP866");
        m_JavaToIANA.put("CSIBM869", "CP869");
        m_JavaToIANA.put("CSISO2022JP", "ISO-2022-JP");
        m_JavaToIANA.put("CSISO2022KR", "ISO-2022-KR");
        m_JavaToIANA.put("CSISOLATIN0", "ISO-8859-15");
        m_JavaToIANA.put("CSISOLATIN1", "ISO-8859-1");
        m_JavaToIANA.put("CSISOLATIN2", "ISO-8859-2");
        m_JavaToIANA.put("CSISOLATIN3", "ISO-8859-3");
        m_JavaToIANA.put("CSISOLATIN4", "ISO-8859-4");
        m_JavaToIANA.put("CSISOLATIN5", "ISO-8859-9");
        m_JavaToIANA.put("CSISOLATIN9", "ISO-8859-15");
        m_JavaToIANA.put("CSISOLATINARABIC", "ISO-8859-6");
        m_JavaToIANA.put("CSISOLATINCYRILLIC", "ISO-8859-5");
        m_JavaToIANA.put("CSISOLATINGREEK", "ISO-8859-7");
        m_JavaToIANA.put("CSISOLATINHEBREW", "ISO-8859-8-I");
        m_JavaToIANA.put("CSJISENCODING", "ISO-2022-JP");
        m_JavaToIANA.put("CSKOI8R", "KOI8-R");
        m_JavaToIANA.put("CSPC850MULTILINGUAL", "CP850");
        m_JavaToIANA.put("CSPC862LATINHEBREW", "CP862");
        m_JavaToIANA.put("CSPC8CODEPAGE437", "CP437");
        m_JavaToIANA.put("CSPCP852", "CP852");
        m_JavaToIANA.put("CSPCP855", "CP855");
        m_JavaToIANA.put("CSSHIFTJIS", "WINDOWS-31J");
        m_JavaToIANA.put("CSWINDOWS31J", "WINDOWS-31J");
        m_JavaToIANA.put("CYRILLIC", "ISO-8859-5");
        m_JavaToIANA.put("DEFAULT", "US-ASCII");
        m_JavaToIANA.put("ECMA-114", "ISO-8859-6");
        m_JavaToIANA.put("ECMA-118", "ISO-8859-7");
        m_JavaToIANA.put("ELOT_928", "ISO-8859-7");
        m_JavaToIANA.put("EUC-CN", "GB2312");
        m_JavaToIANA.put("EUC-JP", "EUC-JP");
        m_JavaToIANA.put("EUC-JP-LINUX", "EUC-JP");
        m_JavaToIANA.put("EUC-KR", "EUC-KR");
        m_JavaToIANA.put("EUCCN", "GB2312");
        m_JavaToIANA.put("EUCJIS", "EUC-JP");
        m_JavaToIANA.put("EUCJP", "EUC-JP");
        m_JavaToIANA.put("EUCKR", "EUC-KR");
        m_JavaToIANA.put("EUC_CN", "GB2312");
        m_JavaToIANA.put("EUC_JP", "EUC-JP");
        m_JavaToIANA.put("EUC_JP_LINUX", "EUC-JP");
        m_JavaToIANA.put("EUC_KR", "EUC-KR");
        m_JavaToIANA.put("EUCTW", "EUC-TW");
        m_JavaToIANA.put("EUC_TW", "EUC-TW");
        m_JavaToIANA.put("EUC-TW", "EUC-TW");
        m_JavaToIANA.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC-JP");
        m_JavaToIANA.put("GB18030", "GB18030");
        m_JavaToIANA.put("GB2312", "GB2312");
        m_JavaToIANA.put("GB2312-1980", "GB2312");
        m_JavaToIANA.put("GB2312-80", "GB2312");
        m_JavaToIANA.put("GBK", "GBK");
        m_JavaToIANA.put("GREEK", "ISO-8859-7");
        m_JavaToIANA.put("GREEK8", "ISO-8859-7");
        m_JavaToIANA.put("HEBREW", "ISO-8859-8-I");
        m_JavaToIANA.put("HKSCS", "BIG5-HKSCS");
        m_JavaToIANA.put("IBM-037", "CP037");
        m_JavaToIANA.put("IBM-1026", "CP1026");
        m_JavaToIANA.put("IBM-1089", "ISO-8859-6");
        m_JavaToIANA.put("IBM-273", "CP273");
        m_JavaToIANA.put("IBM-277", "IBM277");
        m_JavaToIANA.put("IBM-278", "CP278");
        m_JavaToIANA.put("IBM-280", "CP280");
        m_JavaToIANA.put("IBM-284", "CP284");
        m_JavaToIANA.put("IBM-285", "CP285");
        m_JavaToIANA.put("IBM-297", "CP297");
        m_JavaToIANA.put("IBM-420", "CP420");
        m_JavaToIANA.put("IBM-424", "CP424");
        m_JavaToIANA.put("IBM-437", "CP437");
        m_JavaToIANA.put("IBM-500", "CP500");
        m_JavaToIANA.put("IBM-775", "CP775");
        m_JavaToIANA.put("IBM-813", "ISO-8859-7");
        m_JavaToIANA.put("IBM-819", "ISO-8859-1");
        m_JavaToIANA.put("IBM-850", "CP850");
        m_JavaToIANA.put("IBM-852", "CP852");
        m_JavaToIANA.put("IBM-855", "CP855");
        m_JavaToIANA.put("IBM-857", "CP857");
        m_JavaToIANA.put("IBM-860", "CP860");
        m_JavaToIANA.put("IBM-861", "CP861");
        m_JavaToIANA.put("IBM-862", "CP862");
        m_JavaToIANA.put("IBM-863", "CP863");
        m_JavaToIANA.put("IBM-865", "CP865");
        m_JavaToIANA.put("IBM-866", "CP866");
        m_JavaToIANA.put("IBM-869", "CP869");
        m_JavaToIANA.put("IBM-870", "CP870");
        m_JavaToIANA.put("IBM-871", "CP871");
        m_JavaToIANA.put("IBM-874", "WINDOWS-874");
        m_JavaToIANA.put("IBM-912", "ISO-8859-2");
        m_JavaToIANA.put("IBM-913", "ISO-8859-3");
        m_JavaToIANA.put("IBM-914", "ISO-8859-4");
        m_JavaToIANA.put("IBM-915", "ISO-8859-5");
        m_JavaToIANA.put("IBM-916", "ISO-8859-8-I");
        m_JavaToIANA.put("IBM-920", "ISO-8859-9");
        m_JavaToIANA.put("IBM-923", "ISO-8859-15");
        m_JavaToIANA.put("IBM-950", "BIG5");
        m_JavaToIANA.put("IBM037", "CP037");
        m_JavaToIANA.put("IBM1026", "CP1026");
        m_JavaToIANA.put("IBM1089", "ISO-8859-6");
        m_JavaToIANA.put("IBM273", "CP273");
        m_JavaToIANA.put("IBM277", "IBM277");
        m_JavaToIANA.put("IBM278", "CP278");
        m_JavaToIANA.put("IBM280", "CP280");
        m_JavaToIANA.put("IBM284", "CP284");
        m_JavaToIANA.put("IBM285", "CP285");
        m_JavaToIANA.put("IBM297", "CP297");
        m_JavaToIANA.put("IBM420", "CP420");
        m_JavaToIANA.put("IBM424", "CP424");
        m_JavaToIANA.put("IBM437", "CP437");
        m_JavaToIANA.put("IBM500", "CP500");
        m_JavaToIANA.put("IBM775", "CP775");
        m_JavaToIANA.put("IBM813", "ISO-8859-7");
        m_JavaToIANA.put("IBM819", "ISO-8859-1");
        m_JavaToIANA.put("IBM850", "CP850");
        m_JavaToIANA.put("IBM852", "CP852");
        m_JavaToIANA.put("IBM855", "CP855");
        m_JavaToIANA.put("IBM857", "CP857");
        m_JavaToIANA.put("IBM860", "CP860");
        m_JavaToIANA.put("IBM861", "CP861");
        m_JavaToIANA.put("IBM862", "CP862");
        m_JavaToIANA.put("IBM863", "CP863");
        m_JavaToIANA.put("IBM865", "CP865");
        m_JavaToIANA.put("IBM866", "CP866");
        m_JavaToIANA.put("IBM869", "CP869");
        m_JavaToIANA.put("IBM870", "CP870");
        m_JavaToIANA.put("IBM871", "CP871");
        m_JavaToIANA.put("IBM874", "WINDOWS-874");
        m_JavaToIANA.put("IBM912", "ISO-8859-2");
        m_JavaToIANA.put("IBM913", "ISO-8859-3");
        m_JavaToIANA.put("IBM914", "ISO-8859-4");
        m_JavaToIANA.put("IBM915", "ISO-8859-5");
        m_JavaToIANA.put("IBM916", "ISO-8859-8-I");
        m_JavaToIANA.put("IBM920", "ISO-8859-9");
        m_JavaToIANA.put("IBM923", "ISO-8859-15");
        m_JavaToIANA.put("IBM950", "BIG5");
        m_JavaToIANA.put("ISO-10646-UCS-2", "UTF-16BE");
        m_JavaToIANA.put("ISO-2022-JP", "ISO-2022-JP");
        m_JavaToIANA.put("ISO-2022-KR", "ISO-2022-KR");
        m_JavaToIANA.put("ISO-8859-1", "ISO-8859-1");
        m_JavaToIANA.put("ISO-8859-13", "ISO-8859-13");
        m_JavaToIANA.put("ISO-8859-15", "ISO-8859-15");
        m_JavaToIANA.put("ISO-8859-2", "ISO-8859-2");
        m_JavaToIANA.put("ISO-8859-3", "ISO-8859-3");
        m_JavaToIANA.put("ISO-8859-4", "ISO-8859-4");
        m_JavaToIANA.put("ISO-8859-5", "ISO-8859-5");
        m_JavaToIANA.put("ISO-8859-6", "ISO-8859-6");
        m_JavaToIANA.put("ISO-8859-7", "ISO-8859-7");
        m_JavaToIANA.put("ISO-8859-8", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO-8859-9", "ISO-8859-9");
        m_JavaToIANA.put("ISO-IR-100", "ISO-8859-1");
        m_JavaToIANA.put("ISO-IR-101", "ISO-8859-2");
        m_JavaToIANA.put("ISO-IR-109", "ISO-8859-3");
        m_JavaToIANA.put("ISO-IR-110", "ISO-8859-4");
        m_JavaToIANA.put("ISO-IR-126", "ISO-8859-7");
        m_JavaToIANA.put("ISO-IR-127", "ISO-8859-6");
        m_JavaToIANA.put("ISO-IR-138", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO-IR-144", "ISO-8859-5");
        m_JavaToIANA.put("ISO-IR-148", "ISO-8859-9");
        m_JavaToIANA.put("ISO2022CN_GB", "ISO-2022-CN");
        m_JavaToIANA.put("ISO2022JP", "ISO-2022-JP");
        m_JavaToIANA.put("ISO2022KR", "ISO-2022-KR");
        m_JavaToIANA.put("ISO646-US", "US-ASCII");
        m_JavaToIANA.put("ISO8859-1", "ISO-8859-1");
        m_JavaToIANA.put("ISO8859-13", "ISO-8859-13");
        m_JavaToIANA.put("ISO8859-15", "ISO-8859-15");
        m_JavaToIANA.put("ISO8859-2", "ISO-8859-2");
        m_JavaToIANA.put("ISO8859-3", "ISO-8859-3");
        m_JavaToIANA.put("ISO8859-4", "ISO-8859-4");
        m_JavaToIANA.put("ISO8859-5", "ISO-8859-5");
        m_JavaToIANA.put("ISO8859-6", "ISO-8859-6");
        m_JavaToIANA.put("ISO8859-7", "ISO-8859-7");
        m_JavaToIANA.put("ISO8859-8", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO8859-9", "ISO-8859-9");
        m_JavaToIANA.put("ISO8859_1", "ISO-8859-1");
        m_JavaToIANA.put("ISO8859_13", "ISO-8859-13");
        m_JavaToIANA.put("ISO8859_15", "ISO-8859-15");
        m_JavaToIANA.put("ISO8859_15_FDIS", "ISO-8859-15");
        m_JavaToIANA.put("ISO8859_2", "ISO-8859-2");
        m_JavaToIANA.put("ISO8859_3", "ISO-8859-3");
        m_JavaToIANA.put("ISO8859_4", "ISO-8859-4");
        m_JavaToIANA.put("ISO8859_5", "ISO-8859-5");
        m_JavaToIANA.put("ISO8859_6", "ISO-8859-6");
        m_JavaToIANA.put("ISO8859_7", "ISO-8859-7");
        m_JavaToIANA.put("ISO8859_8", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO8859_9", "ISO-8859-9");
        m_JavaToIANA.put("ISO_646.IRV:1983", "US-ASCII");
        m_JavaToIANA.put("ISO_8859-1", "ISO-8859-1");
        m_JavaToIANA.put("ISO_8859-13", "ISO-8859-13");
        m_JavaToIANA.put("ISO_8859-15", "ISO-8859-15");
        m_JavaToIANA.put("ISO_8859-1:1987", "ISO-8859-1");
        m_JavaToIANA.put("ISO_8859-2", "ISO-8859-2");
        m_JavaToIANA.put("ISO_8859-2:1987", "ISO-8859-2");
        m_JavaToIANA.put("ISO_8859-3", "ISO-8859-3");
        m_JavaToIANA.put("ISO_8859-3:1988", "ISO-8859-3");
        m_JavaToIANA.put("ISO_8859-4", "ISO-8859-4");
        m_JavaToIANA.put("ISO_8859-4:1988", "ISO-8859-4");
        m_JavaToIANA.put("ISO_8859-5", "ISO-8859-5");
        m_JavaToIANA.put("ISO_8859-5:1988", "ISO-8859-5");
        m_JavaToIANA.put("ISO_8859-6", "ISO-8859-6");
        m_JavaToIANA.put("ISO_8859-6:1987", "ISO-8859-6");
        m_JavaToIANA.put("ISO_8859-7", "ISO-8859-7");
        m_JavaToIANA.put("ISO_8859-7:1987", "ISO-8859-7");
        m_JavaToIANA.put("ISO_8859-8", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO_8859-8:1988", "ISO-8859-8-I");
        m_JavaToIANA.put("ISO_8859-9", "ISO-8859-9");
        m_JavaToIANA.put("JIS", "ISO-2022-JP");
        m_JavaToIANA.put("JIS_ENCODING", "ISO-2022-JP");
        m_JavaToIANA.put("KOI8", "KOI8-R");
        m_JavaToIANA.put("KOI8-R", "KOI8-R");
        m_JavaToIANA.put("KOI8_R", "KOI8-R");
        m_JavaToIANA.put("KSC5601", "EUC-KR");
        m_JavaToIANA.put("KSC5601-1987", "EUC-KR");
        m_JavaToIANA.put("KSC5601_1987", "EUC-KR");
        m_JavaToIANA.put("KSC_5601", "EUC-KR");
        m_JavaToIANA.put("KS_C_5601-1987", "EUC-KR");
        m_JavaToIANA.put("L1", "ISO-8859-1");
        m_JavaToIANA.put("L2", "ISO-8859-2");
        m_JavaToIANA.put("L3", "ISO-8859-3");
        m_JavaToIANA.put("L4", "ISO-8859-4");
        m_JavaToIANA.put("L5", "ISO-8859-9");
        m_JavaToIANA.put("LATIN0", "ISO-8859-15");
        m_JavaToIANA.put("LATIN1", "ISO-8859-1");
        m_JavaToIANA.put("LATIN2", "ISO-8859-2");
        m_JavaToIANA.put("LATIN3", "ISO-8859-3");
        m_JavaToIANA.put("LATIN4", "ISO-8859-4");
        m_JavaToIANA.put("LATIN5", "ISO-8859-9");
        m_JavaToIANA.put("LATIN9", "ISO-8859-15");
        m_JavaToIANA.put("MACROMAN", "MACINTOSH");
        m_JavaToIANA.put("MS874", "WINDOWS-874");
        m_JavaToIANA.put("MS932", "WINDOWS-31J");
        m_JavaToIANA.put("MS936", "GBK");
        m_JavaToIANA.put("MS949", "EUC-KR");
        m_JavaToIANA.put("MS950", "BIG5");
        m_JavaToIANA.put("MS950_HKSCS", "BIG5-HKSCS");
        m_JavaToIANA.put("MS_KANJI", "WINDOWS-31J");
        m_JavaToIANA.put("PCK", "SHIFT_JIS");
        m_JavaToIANA.put("SHIFT_JIS", "SHIFT_JIS");
        m_JavaToIANA.put("SJIS", "SHIFT_JIS");
        m_JavaToIANA.put("TIS-620", "WINDOWS-874");
        m_JavaToIANA.put("TIS620", "WINDOWS-874");
        m_JavaToIANA.put("TIS620.2533", "WINDOWS-874");
        m_JavaToIANA.put("UNICODE-1-1", "UTF-16BE");
        m_JavaToIANA.put("UNICODE-1-1-UTF-8", "UTF-8");
        m_JavaToIANA.put("UNICODEBIGUNMARKED", "UTF-16BE");
        m_JavaToIANA.put("UNICODELITTLEUNMARKED", "UTF-16LE");
        m_JavaToIANA.put("US-ASCII", "US-ASCII");
        m_JavaToIANA.put("UTF-16", "UTF-16");
        m_JavaToIANA.put("UTF-16BE", "UTF-16BE");
        m_JavaToIANA.put("UTF-16LE", "UTF-16LE");
        m_JavaToIANA.put("UTF-8", "UTF-8");
        m_JavaToIANA.put("UTF16", "UTF-16");
        m_JavaToIANA.put("UTF8", "UTF-8");
        m_JavaToIANA.put("WINDOWS-1250", "WINDOWS-1250");
        m_JavaToIANA.put("WINDOWS-1251", "WINDOWS-1251");
        m_JavaToIANA.put("WINDOWS-1252", "WINDOWS-1252");
        m_JavaToIANA.put("WINDOWS-1253", "WINDOWS-1253");
        m_JavaToIANA.put("WINDOWS-1254", "WINDOWS-1254");
        m_JavaToIANA.put("WINDOWS-1255", "WINDOWS-1255");
        m_JavaToIANA.put("WINDOWS-1256", "WINDOWS-1256");
        m_JavaToIANA.put("WINDOWS-1257", "WINDOWS-1257");
        m_JavaToIANA.put("WINDOWS-1258", "WINDOWS-1258");
        m_JavaToIANA.put("WINDOWS-31J", "WINDOWS-31J");
        m_JavaToIANA.put("WINDOWS-874", "WINDOWS-874");
        m_JavaToIANA.put("WINDOWS-949", "EUC-KR");
        m_JavaToIANA.put("X-EUC-JP", "EUC-JP");
        m_JavaToIANA.put("X-EUCJP", "EUC-JP");
        m_JavaToIANA.put("X-SJIS", "SHIFT_JIS");
        m_JavaToIANA.put("X-UTF-16BE", "UTF-16BE");
        m_JavaToIANA.put("X-UTF-16LE", "UTF-16LE");
        m_IANAToOracle = new Hashtable();
        m_IANAToOracle.put("437", "US8PC437");
        m_IANAToOracle.put("850", "WE8PC850");
        m_IANAToOracle.put("851", "EL8PC851");
        m_IANAToOracle.put("852", "EE8PC852");
        m_IANAToOracle.put("855", "RU8PC855");
        m_IANAToOracle.put("857", "TR8PC857");
        m_IANAToOracle.put("860", "WE8PC860");
        m_IANAToOracle.put("861", "IS8PC861");
        m_IANAToOracle.put("862", "IW8PC1507");
        m_IANAToOracle.put("863", "CDN8PC863");
        m_IANAToOracle.put("865", "N8PC865");
        m_IANAToOracle.put("866", "RU8PC866");
        m_IANAToOracle.put("869", "EL8PC869");
        m_IANAToOracle.put("ANSI_X3.4-1968", "US7ASCII");
        m_IANAToOracle.put("ANSI_X3.4-1986", "US7ASCII");
        m_IANAToOracle.put("ARABIC", "AR8ISO8859P6");
        m_IANAToOracle.put("ASCII", "US7ASCII");
        m_IANAToOracle.put("ASMO-708", "AR8ISO8859P6");
        m_IANAToOracle.put("BIG5", "ZHT16MSWIN950");
        m_IANAToOracle.put("BIG5-HKSCS", "ZHT16HKSCS");
        m_IANAToOracle.put("CCSID00858", "WE8PC858");
        m_IANAToOracle.put("CCSID00924", "WE8EBCDIC924");
        m_IANAToOracle.put("CCSID01140", "WE8EBCDIC1140");
        m_IANAToOracle.put("CCSID01141", "D8EBCDIC1141");
        m_IANAToOracle.put("CCSID01142", "DK8EBCDIC1142");
        m_IANAToOracle.put("CCSID01143", "S8EBCDIC1143");
        m_IANAToOracle.put("CCSID01144", "I8EBCDIC1144");
        m_IANAToOracle.put("CCSID01145", "WE8EBCDIC1145");
        m_IANAToOracle.put("CCSID01146", "WE8EBCDIC1146");
        m_IANAToOracle.put("CCSID01147", "F8EBCDIC1147");
        m_IANAToOracle.put("CCSID01148", "WE8EBCDIC1148");
        m_IANAToOracle.put("CESU-8", "UTF8");
        m_IANAToOracle.put("CHINESE", "ZHS16GBK");
        m_IANAToOracle.put("CP-GR", "EL8PC869");
        m_IANAToOracle.put("CP-IS", "IS8PC861");
        m_IANAToOracle.put("CP00858", "WE8PC858");
        m_IANAToOracle.put("CP00924", "WE8EBCDIC924");
        m_IANAToOracle.put("CP01140", "WE8EBCDIC1140");
        m_IANAToOracle.put("CP01141", "D8EBCDIC1141");
        m_IANAToOracle.put("CP01142", "DK8EBCDIC1142");
        m_IANAToOracle.put("CP01143", "S8EBCDIC1143");
        m_IANAToOracle.put("CP01144", "I8EBCDIC1144");
        m_IANAToOracle.put("CP01145", "WE8EBCDIC1145");
        m_IANAToOracle.put("CP01146", "WE8EBCDIC1146");
        m_IANAToOracle.put("CP01147", "F8EBCDIC1147");
        m_IANAToOracle.put("CP01148", "WE8EBCDIC1148");
        m_IANAToOracle.put("CP037", "WE8EBCDIC37");
        m_IANAToOracle.put("CP1026", "TR8EBCDIC1026");
        m_IANAToOracle.put("CP273", "D8EBCDIC273");
        m_IANAToOracle.put("CP278", "S8EBCDIC278");
        m_IANAToOracle.put("CP280", "I8EBCDIC280");
        m_IANAToOracle.put("CP284", "WE8EBCDIC284");
        m_IANAToOracle.put("CP285", "WE8EBCDIC285");
        m_IANAToOracle.put("CP297", "F8EBCDIC297");
        m_IANAToOracle.put("CP367", "US7ASCII");
        m_IANAToOracle.put("CP420", "AR8EBCDIC420S");
        m_IANAToOracle.put("CP424", "IW8EBCDIC424");
        m_IANAToOracle.put("CP437", "US8PC437");
        m_IANAToOracle.put("CP500", "WE8EBCDIC500");
        m_IANAToOracle.put("CP775", "BLT8PC775");
        m_IANAToOracle.put("CP819", "WE8ISO8859P1");
        m_IANAToOracle.put("CP850", "WE8PC850");
        m_IANAToOracle.put("CP851", "EL8PC851");
        m_IANAToOracle.put("CP852", "EE8PC852");
        m_IANAToOracle.put("CP855", "RU8PC855");
        m_IANAToOracle.put("CP857", "TR8PC857");
        m_IANAToOracle.put("CP860", "WE8PC860");
        m_IANAToOracle.put("CP861", "IS8PC861");
        m_IANAToOracle.put("CP862", "IW8PC1507");
        m_IANAToOracle.put("CP863", "CDN8PC863");
        m_IANAToOracle.put("CP865", "N8PC865");
        m_IANAToOracle.put("CP866", "RU8PC866");
        m_IANAToOracle.put("CP869", "EL8PC869");
        m_IANAToOracle.put("CP870", "EE8EBCDIC870");
        m_IANAToOracle.put("CP871", "WE8EBCDIC871");
        m_IANAToOracle.put("CP891", "US7ASCII");
        m_IANAToOracle.put("CP903", "US7ASCII");
        m_IANAToOracle.put("CP936", "ZHS16GBK");
        m_IANAToOracle.put("CSASCII", "US7ASCII");
        m_IANAToOracle.put("CSBIG5", "ZHT16MSWIN950");
        m_IANAToOracle.put("CSCESU-8", "UTF8");
        m_IANAToOracle.put("CSDECMCS", "WE8DEC");
        m_IANAToOracle.put("CSEUCKR", "KO16MSWIN949");
        m_IANAToOracle.put("CSEUCPKDFMTJAPANESE", "JA16EUC");
        m_IANAToOracle.put("CSGB2312", "ZHS16CGB231280");
        m_IANAToOracle.put("CSHPROMAN8", "WE8ROMAN8");
        m_IANAToOracle.put("CSIBM037", "WE8EBCDIC37");
        m_IANAToOracle.put("CSIBM1026", "TR8EBCDIC1026");
        m_IANAToOracle.put("CSIBM273", "D8EBCDIC273");
        m_IANAToOracle.put("CSIBM277", "DK8EBCDIC277");
        m_IANAToOracle.put("CSIBM278", "S8EBCDIC278");
        m_IANAToOracle.put("CSIBM280", "I8EBCDIC280");
        m_IANAToOracle.put("CSIBM284", "WE8EBCDIC284");
        m_IANAToOracle.put("CSIBM285", "WE8EBCDIC285");
        m_IANAToOracle.put("CSIBM297", "F8EBCDIC297");
        m_IANAToOracle.put("CSIBM420", "AR8EBCDIC420S");
        m_IANAToOracle.put("CSIBM424", "IW8EBCDIC424");
        m_IANAToOracle.put("CSIBM500", "WE8EBCDIC500");
        m_IANAToOracle.put("CSIBM851", "EL8PC851");
        m_IANAToOracle.put("CSIBM855", "RU8PC855");
        m_IANAToOracle.put("CSIBM857", "TR8PC857");
        m_IANAToOracle.put("CSIBM860", "WE8PC860");
        m_IANAToOracle.put("CSIBM861", "IS8PC861");
        m_IANAToOracle.put("CSIBM863", "CDN8PC863");
        m_IANAToOracle.put("CSIBM865", "N8PC865");
        m_IANAToOracle.put("CSIBM866", "RU8PC866");
        m_IANAToOracle.put("CSIBM869", "EL8PC869");
        m_IANAToOracle.put("CSIBM870", "EE8EBCDIC870");
        m_IANAToOracle.put("CSIBM871", "WE8EBCDIC871");
        m_IANAToOracle.put("CSIBM891", "US7ASCII");
        m_IANAToOracle.put("CSIBM903", "US7ASCII");
        m_IANAToOracle.put("CSISO10SWEDISH", "SF7ASCII");
        m_IANAToOracle.put("CSISO11SWEDISHFORNAMES", "S7SIEMENS9780X");
        m_IANAToOracle.put("CSISO141JUSIB1002", "YUG7ASCII");
        m_IANAToOracle.put("CSISO15ITALIAN", "I7DEC");
        m_IANAToOracle.put("CSISO17SPANISH", "E7DEC");
        m_IANAToOracle.put("CSISO2022JP", "ISO2022-JP");
        m_IANAToOracle.put("CSISO2022KR", "ISO2022-KR");
        m_IANAToOracle.put("CSISO21GERMAN", "D7DEC");
        m_IANAToOracle.put("CSISO25FRENCH", "F7DEC");
        m_IANAToOracle.put("CSISO58GB231280", "ZHS16CGB231280");
        m_IANAToOracle.put("CSISO60DANISHNORWEGIAN", "N7SIEMENS9780X");
        m_IANAToOracle.put("CSISO60NORWEGIAN1", "N7SIEMENS9780X");
        m_IANAToOracle.put("CSISO88596I", "AR8ISO8859P6");
        m_IANAToOracle.put("CSISO88598I", "IW8ISO8859P8");
        m_IANAToOracle.put("CSISOLATIN1", "WE8ISO8859P1");
        m_IANAToOracle.put("CSISOLATIN2", "EE8ISO8859P2");
        m_IANAToOracle.put("CSISOLATIN3", "SE8ISO8859P3");
        m_IANAToOracle.put("CSISOLATIN4", "NEE8ISO8859P4");
        m_IANAToOracle.put("CSISOLATIN5", "WE8ISO8859P9");
        m_IANAToOracle.put("CSISOLATIN6", "NE8ISO8859P10");
        m_IANAToOracle.put("CSISOLATINARABIC", "AR8ISO8859P6");
        m_IANAToOracle.put("CSISOLATINCYRILLIC", "CL8ISO8859P5");
        m_IANAToOracle.put("CSISOLATINGREEK", "EL8ISO8859P7");
        m_IANAToOracle.put("CSJISENCODING", "ISO2022-JP");
        m_IANAToOracle.put("CSKOI8R", "CL8KOI8R");
        m_IANAToOracle.put("CSKSC56011987", "KO16MSWIN949");
        m_IANAToOracle.put("CSMACINTOSH", "WE8MACROMAN8");
        m_IANAToOracle.put("CSPC775BALTIC", "BLT8PC775");
        m_IANAToOracle.put("CSPC850MULTILINGUAL", "WE8PC850");
        m_IANAToOracle.put("CSPC862LATINHEBREW", "IW8PC1507");
        m_IANAToOracle.put("CSPC8CODEPAGE437", "US8PC437");
        m_IANAToOracle.put("CSPCP852", "EE8PC852");
        m_IANAToOracle.put("CSSHIFTJIS", "JA16SJIS");
        m_IANAToOracle.put("CSUNICODE", "UTF16");
        m_IANAToOracle.put("CSUSDK", "US7ASCII");
        m_IANAToOracle.put("CSWINDOWS30LATIN1", "WE8MSWIN1252");
        m_IANAToOracle.put("CSWINDOWS31J", "JA16SJIS");
        m_IANAToOracle.put("CSWINDOWS31LATIN1", "WE8MSWIN1252");
        m_IANAToOracle.put("CSWINDOWS31LATIN2", "EE8MSWIN1250");
        m_IANAToOracle.put("CSWINDOWS31LATIN5", "TR8MSWIN1254");
        m_IANAToOracle.put("CYRILLIC", "CL8ISO8859P5");
        m_IANAToOracle.put("DE", "D7DEC");
        m_IANAToOracle.put("DEC", "WE8DEC");
        m_IANAToOracle.put("DEC-MCS", "WE8DEC");
        m_IANAToOracle.put("DIN_66003", "D7DEC");
        m_IANAToOracle.put("EBCDIC-CP-AR1", "AR8EBCDIC420S");
        m_IANAToOracle.put("EBCDIC-CP-BE", "WE8EBCDIC500");
        m_IANAToOracle.put("EBCDIC-CP-CA", "WE8EBCDIC37");
        m_IANAToOracle.put("EBCDIC-CP-CH", "WE8EBCDIC500");
        m_IANAToOracle.put("EBCDIC-CP-DK", "DK8EBCDIC277");
        m_IANAToOracle.put("EBCDIC-CP-ES", "WE8EBCDIC284");
        m_IANAToOracle.put("EBCDIC-CP-FI", "S8EBCDIC278");
        m_IANAToOracle.put("EBCDIC-CP-FR", "F8EBCDIC297");
        m_IANAToOracle.put("EBCDIC-CP-GB", "WE8EBCDIC285");
        m_IANAToOracle.put("EBCDIC-CP-HE", "IW8EBCDIC424");
        m_IANAToOracle.put("EBCDIC-CP-IS", "WE8EBCDIC871");
        m_IANAToOracle.put("EBCDIC-CP-IT", "I8EBCDIC280");
        m_IANAToOracle.put("EBCDIC-CP-NL", "WE8EBCDIC37");
        m_IANAToOracle.put("EBCDIC-CP-NO", "DK8EBCDIC277");
        m_IANAToOracle.put("EBCDIC-CP-ROECE", "EE8EBCDIC870");
        m_IANAToOracle.put("EBCDIC-CP-SE", "S8EBCDIC278");
        m_IANAToOracle.put("EBCDIC-CP-US", "WE8EBCDIC37");
        m_IANAToOracle.put("EBCDIC-CP-WT", "WE8EBCDIC37");
        m_IANAToOracle.put("EBCDIC-CP-YU", "EE8EBCDIC870");
        m_IANAToOracle.put("EBCDIC-DE-273+EURO", "D8EBCDIC1141");
        m_IANAToOracle.put("EBCDIC-DK-277+EURO", "DK8EBCDIC1142");
        m_IANAToOracle.put("EBCDIC-ES-284+EURO", "WE8EBCDIC1145");
        m_IANAToOracle.put("EBCDIC-FI-278+EURO", "S8EBCDIC1143");
        m_IANAToOracle.put("EBCDIC-FR-297+EURO", "F8EBCDIC1147");
        m_IANAToOracle.put("EBCDIC-GB-285+EURO", "WE8EBCDIC1146");
        m_IANAToOracle.put("EBCDIC-INTERNATIONAL-500+EURO", "WE8EBCDIC1148");
        m_IANAToOracle.put("EBCDIC-IT-280+EURO", "I8EBCDIC1144");
        m_IANAToOracle.put("EBCDIC-LATIN9--EURO", "WE8EBCDIC924");
        m_IANAToOracle.put("EBCDIC-NO-277+EURO", "DK8EBCDIC1142");
        m_IANAToOracle.put("EBCDIC-SE-278+EURO", "S8EBCDIC1143");
        m_IANAToOracle.put("EBCDIC-US-37+EURO", "WE8EBCDIC1140");
        m_IANAToOracle.put("ECMA-114", "AR8ISO8859P6");
        m_IANAToOracle.put("ECMA-118", "EL8ISO8859P7");
        m_IANAToOracle.put("ELOT_928", "EL8ISO8859P7");
        m_IANAToOracle.put("ES", "E7DEC");
        m_IANAToOracle.put("EUC-JP", "JA16EUC");
        m_IANAToOracle.put("EUC-KR", "KO16MSWIN949");
        m_IANAToOracle.put("EUC-TW", "ZHT32EUC");
        m_IANAToOracle.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "JA16EUC");
        m_IANAToOracle.put("FI", "SF7ASCII");
        m_IANAToOracle.put("GB18030", "ZHS32GB18030");
        m_IANAToOracle.put("GB2312", "ZHS16CGB231280");
        m_IANAToOracle.put("GBK", "ZHS16GBK");
        m_IANAToOracle.put("GB_2312-80", "ZHS16CGB231280");
        m_IANAToOracle.put("GREEK", "EL8ISO8859P7");
        m_IANAToOracle.put("GREEK8", "EL8ISO8859P7");
        m_IANAToOracle.put("HP-ROMAN8", "WE8ROMAN8");
        m_IANAToOracle.put("HZ-GB-2312", "HZ-GB-2312");
        m_IANAToOracle.put("IBM-1047", "WE8EBCDIC1047");
        m_IANAToOracle.put("IBM00858", "WE8PC858");
        m_IANAToOracle.put("IBM00924", "WE8EBCDIC924");
        m_IANAToOracle.put("IBM01140", "WE8EBCDIC1140");
        m_IANAToOracle.put("IBM01141", "D8EBCDIC1141");
        m_IANAToOracle.put("IBM01142", "DK8EBCDIC1142");
        m_IANAToOracle.put("IBM01143", "S8EBCDIC1143");
        m_IANAToOracle.put("IBM01144", "I8EBCDIC1144");
        m_IANAToOracle.put("IBM01145", "WE8EBCDIC1145");
        m_IANAToOracle.put("IBM01146", "WE8EBCDIC1146");
        m_IANAToOracle.put("IBM01147", "F8EBCDIC1147");
        m_IANAToOracle.put("IBM01148", "WE8EBCDIC1148");
        m_IANAToOracle.put("IBM037", "WE8EBCDIC37");
        m_IANAToOracle.put("IBM1026", "TR8EBCDIC1026");
        m_IANAToOracle.put("IBM1047", "WE8EBCDIC1047");
        m_IANAToOracle.put("IBM273", "D8EBCDIC273");
        m_IANAToOracle.put("IBM277", "DK8EBCDIC277");
        m_IANAToOracle.put("IBM278", "S8EBCDIC278");
        m_IANAToOracle.put("IBM280", "I8EBCDIC280");
        m_IANAToOracle.put("IBM284", "WE8EBCDIC284");
        m_IANAToOracle.put("IBM285", "WE8EBCDIC285");
        m_IANAToOracle.put("IBM297", "F8EBCDIC297");
        m_IANAToOracle.put("IBM367", "US7ASCII");
        m_IANAToOracle.put("IBM420", "AR8EBCDIC420S");
        m_IANAToOracle.put("IBM424", "IW8EBCDIC424");
        m_IANAToOracle.put("IBM437", "US8PC437");
        m_IANAToOracle.put("IBM500", "WE8EBCDIC500");
        m_IANAToOracle.put("IBM775", "BLT8PC775");
        m_IANAToOracle.put("IBM819", "WE8ISO8859P1");
        m_IANAToOracle.put("IBM850", "WE8PC850");
        m_IANAToOracle.put("IBM851", "EL8PC851");
        m_IANAToOracle.put("IBM852", "EE8PC852");
        m_IANAToOracle.put("IBM855", "RU8PC855");
        m_IANAToOracle.put("IBM857", "TR8PC857");
        m_IANAToOracle.put("IBM860", "WE8PC860");
        m_IANAToOracle.put("IBM861", "IS8PC861");
        m_IANAToOracle.put("IBM862", "IW8PC1507");
        m_IANAToOracle.put("IBM863", "CDN8PC863");
        m_IANAToOracle.put("IBM865", "N8PC865");
        m_IANAToOracle.put("IBM866", "RU8PC866");
        m_IANAToOracle.put("IBM869", "EL8PC869");
        m_IANAToOracle.put("IBM870", "EE8EBCDIC870");
        m_IANAToOracle.put("IBM871", "WE8EBCDIC871");
        m_IANAToOracle.put("IBM891", "US7ASCII");
        m_IANAToOracle.put("IBM903", "US7ASCII");
        m_IANAToOracle.put("ISO-10646-UCS-2", "UTF16");
        m_IANAToOracle.put("ISO-2022-CN", "ISO2022-CN");
        m_IANAToOracle.put("ISO-2022-JP", "ISO2022-JP");
        m_IANAToOracle.put("ISO-2022-KR", "ISO2022-KR");
        m_IANAToOracle.put("ISO-8859-1", "WE8ISO8859P1");
        m_IANAToOracle.put("ISO-8859-1-WINDOWS-3.0-LATIN-1", "WE8MSWIN1252");
        m_IANAToOracle.put("ISO-8859-1-WINDOWS-3.1-LATIN-1", "WE8MSWIN1252");
        m_IANAToOracle.put("ISO-8859-10", "NE8ISO8859P10");
        m_IANAToOracle.put("ISO-8859-13", "BLT8ISO8859P13");
        m_IANAToOracle.put("ISO-8859-14", "CEL8ISO8859P14");
        m_IANAToOracle.put("ISO-8859-15", "WE8ISO8859P15");
        m_IANAToOracle.put("ISO-8859-2", "EE8ISO8859P2");
        m_IANAToOracle.put("ISO-8859-2-WINDOWS-LATIN-2", "EE8MSWIN1250");
        m_IANAToOracle.put("ISO-8859-3", "SE8ISO8859P3");
        m_IANAToOracle.put("ISO-8859-4", "NEE8ISO8859P4");
        m_IANAToOracle.put("ISO-8859-5", "CL8ISO8859P5");
        m_IANAToOracle.put("ISO-8859-6", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO-8859-6-I", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO-8859-7", "EL8ISO8859P7");
        m_IANAToOracle.put("ISO-8859-8-I", "IW8ISO8859P8");
        m_IANAToOracle.put("ISO-8859-9", "WE8ISO8859P9");
        m_IANAToOracle.put("ISO-8859-9-WINDOWS-LATIN-5", "TR8MSWIN1254");
        m_IANAToOracle.put("ISO-CELTIC", "CEL8ISO8859P14");
        m_IANAToOracle.put("ISO-IR-10", "SF7ASCII");
        m_IANAToOracle.put("ISO-IR-100", "WE8ISO8859P1");
        m_IANAToOracle.put("ISO-IR-101", "EE8ISO8859P2");
        m_IANAToOracle.put("ISO-IR-109", "SE8ISO8859P3");
        m_IANAToOracle.put("ISO-IR-11", "S7SIEMENS9780X");
        m_IANAToOracle.put("ISO-IR-110", "NEE8ISO8859P4");
        m_IANAToOracle.put("ISO-IR-126", "EL8ISO8859P7");
        m_IANAToOracle.put("ISO-IR-127", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO-IR-141", "YUG7ASCII");
        m_IANAToOracle.put("ISO-IR-144", "CL8ISO8859P5");
        m_IANAToOracle.put("ISO-IR-148", "WE8ISO8859P9");
        m_IANAToOracle.put("ISO-IR-149", "KO16MSWIN949");
        m_IANAToOracle.put("ISO-IR-15", "I7DEC");
        m_IANAToOracle.put("ISO-IR-157", "NE8ISO8859P10");
        m_IANAToOracle.put("ISO-IR-17", "E7DEC");
        m_IANAToOracle.put("ISO-IR-199", "CEL8ISO8859P14");
        m_IANAToOracle.put("ISO-IR-21", "D7DEC");
        m_IANAToOracle.put("ISO-IR-25", "F7DEC");
        m_IANAToOracle.put("ISO-IR-58", "ZHS16GBK");
        m_IANAToOracle.put("ISO-IR-6", "US7ASCII");
        m_IANAToOracle.put("ISO-IR-60", "N7SIEMENS9780X");
        m_IANAToOracle.put("ISO646-DE", "D7DEC");
        m_IANAToOracle.put("ISO646-ES", "E7DEC");
        m_IANAToOracle.put("ISO646-FI", "SF7ASCII");
        m_IANAToOracle.put("ISO646-FR1", "F7DEC");
        m_IANAToOracle.put("ISO646-IT", "I7DEC");
        m_IANAToOracle.put("ISO646-NO", "N7SIEMENS9780X");
        m_IANAToOracle.put("ISO646-SE", "SF7ASCII");
        m_IANAToOracle.put("ISO646-SE2", "S7SIEMENS9780X");
        m_IANAToOracle.put("ISO646-US", "US7ASCII");
        m_IANAToOracle.put("ISO646-YU", "YUG7ASCII");
        m_IANAToOracle.put("ISO_646.IRV:1991", "US7ASCII");
        m_IANAToOracle.put("ISO_8859-1", "WE8ISO8859P1");
        m_IANAToOracle.put("ISO_8859-10:1992", "NE8ISO8859P10");
        m_IANAToOracle.put("ISO_8859-14", "CEL8ISO8859P14");
        m_IANAToOracle.put("ISO_8859-14:1998", "CEL8ISO8859P14");
        m_IANAToOracle.put("ISO_8859-15", "WE8ISO8859P15");
        m_IANAToOracle.put("ISO_8859-1:1987", "WE8ISO8859P1");
        m_IANAToOracle.put("ISO_8859-2", "EE8ISO8859P2");
        m_IANAToOracle.put("ISO_8859-2:1987", "EE8ISO8859P2");
        m_IANAToOracle.put("ISO_8859-3", "SE8ISO8859P3");
        m_IANAToOracle.put("ISO_8859-3:1988", "SE8ISO8859P3");
        m_IANAToOracle.put("ISO_8859-4", "NEE8ISO8859P4");
        m_IANAToOracle.put("ISO_8859-4:1988", "NEE8ISO8859P4");
        m_IANAToOracle.put("ISO_8859-5", "CL8ISO8859P5");
        m_IANAToOracle.put("ISO_8859-5:1988", "CL8ISO8859P5");
        m_IANAToOracle.put("ISO_8859-6", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO_8859-6-I", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO_8859-6:1987", "AR8ISO8859P6");
        m_IANAToOracle.put("ISO_8859-7", "EL8ISO8859P7");
        m_IANAToOracle.put("ISO_8859-7:1987", "EL8ISO8859P7");
        m_IANAToOracle.put("ISO_8859-8-I", "IW8ISO8859P8");
        m_IANAToOracle.put("ISO_8859-9", "WE8ISO8859P9");
        m_IANAToOracle.put("ISO_8859-9:1989", "WE8ISO8859P9");
        m_IANAToOracle.put("IT", "I7DEC");
        m_IANAToOracle.put("JIS_ENCODING", "ISO2022-JP");
        m_IANAToOracle.put("JS", "YUG7ASCII");
        m_IANAToOracle.put("JUS_I.B1.002", "YUG7ASCII");
        m_IANAToOracle.put("KOI8-R", "CL8KOI8R");
        m_IANAToOracle.put("KOI8-U", "CL8KOI8U");
        m_IANAToOracle.put("KOREAN", "KO16MSWIN949");
        m_IANAToOracle.put("KSC_5601", "KO16MSWIN949");
        m_IANAToOracle.put("KS_C_5601-1987", "KO16MSWIN949");
        m_IANAToOracle.put("KS_C_5601-1989", "KO16MSWIN949");
        m_IANAToOracle.put("L1", "WE8ISO8859P1");
        m_IANAToOracle.put("L2", "EE8ISO8859P2");
        m_IANAToOracle.put("L3", "SE8ISO8859P3");
        m_IANAToOracle.put("L4", "NEE8ISO8859P4");
        m_IANAToOracle.put("L5", "WE8ISO8859P9");
        m_IANAToOracle.put("L6", "NE8ISO8859P10");
        m_IANAToOracle.put("L8", "CEL8ISO8859P14");
        m_IANAToOracle.put("LATIN-9", "WE8ISO8859P15");
        m_IANAToOracle.put("LATIN1", "WE8ISO8859P1");
        m_IANAToOracle.put("LATIN2", "EE8ISO8859P2");
        m_IANAToOracle.put("LATIN3", "SE8ISO8859P3");
        m_IANAToOracle.put("LATIN4", "NEE8ISO8859P4");
        m_IANAToOracle.put("LATIN5", "WE8ISO8859P9");
        m_IANAToOracle.put("LATIN6", "NE8ISO8859P10");
        m_IANAToOracle.put("LATIN8", "CEL8ISO8859P14");
        m_IANAToOracle.put("MAC", "WE8MACROMAN8");
        m_IANAToOracle.put("MACINTOSH", "WE8MACROMAN8");
        m_IANAToOracle.put("MS936", "ZHS16GBK");
        m_IANAToOracle.put("MS_KANJI", "JA16SJIS");
        m_IANAToOracle.put("NF_Z_62-010_(1973)", "F7DEC");
        m_IANAToOracle.put("NO", "N7SIEMENS9780X");
        m_IANAToOracle.put("NS_4551-1", "N7SIEMENS9780X");
        m_IANAToOracle.put("PC-MULTILINGUAL-850+EURO", "WE8PC858");
        m_IANAToOracle.put("R8", "WE8ROMAN8");
        m_IANAToOracle.put("ROMAN8", "WE8ROMAN8");
        m_IANAToOracle.put("SE", "SF7ASCII");
        m_IANAToOracle.put("SE2", "S7SIEMENS9780X");
        m_IANAToOracle.put("SEN_850200_B", "SF7ASCII");
        m_IANAToOracle.put("SEN_850200_C", "S7SIEMENS9780X");
        m_IANAToOracle.put("SHIFT_JIS", "JA16SJIS");
        m_IANAToOracle.put("TIS-620", "TH8TISASCII");
        m_IANAToOracle.put("US", "US7ASCII");
        m_IANAToOracle.put("US-ASCII", "US7ASCII");
        m_IANAToOracle.put("US-DK", "US7ASCII");
        m_IANAToOracle.put("UTF-16", "UTF16");
        m_IANAToOracle.put("UTF-16BE", "AL16UTF16");
        m_IANAToOracle.put("UTF-16LE", "AL16UTF16LE");
        m_IANAToOracle.put("UTF-8", "UTF8");
        m_IANAToOracle.put("WINDOWS-1250", "EE8MSWIN1250");
        m_IANAToOracle.put("WINDOWS-1251", "CL8MSWIN1251");
        m_IANAToOracle.put("WINDOWS-1252", "WE8MSWIN1252");
        m_IANAToOracle.put("WINDOWS-1253", "EL8MSWIN1253");
        m_IANAToOracle.put("WINDOWS-1254", "TR8MSWIN1254");
        m_IANAToOracle.put("WINDOWS-1255", "IW8MSWIN1255");
        m_IANAToOracle.put("WINDOWS-1256", "AR8MSWIN1256");
        m_IANAToOracle.put("WINDOWS-1257", "BLT8MSWIN1257");
        m_IANAToOracle.put("WINDOWS-1258", "VN8MSWIN1258");
        m_IANAToOracle.put("WINDOWS-31J", "JA16SJIS");
        m_IANAToOracle.put("WINDOWS-874", "TH8TISASCII");
        m_IANAToOracle.put("WINDOWS-936", "ZHS16GBK");
        m_IANAToOracle.put("WINDOWS-949", "KO16MSWIN949");
        m_IANAToOracle.put("WINDOWS-950", "ZHT16MSWIN950");
        m_IANAToOracle.put("YU", "YUG7ASCII");
        m_IANAToJava = new Hashtable();
        m_IANAToJava.put("437", "CP437");
        m_IANAToJava.put("850", "CP850");
        m_IANAToJava.put("852", "CP852");
        m_IANAToJava.put("855", "CP855");
        m_IANAToJava.put("857", "CP857");
        m_IANAToJava.put("860", "CP860");
        m_IANAToJava.put("861", "CP861");
        m_IANAToJava.put("862", "CP862");
        m_IANAToJava.put("863", "CP863");
        m_IANAToJava.put("865", "CP865");
        m_IANAToJava.put("866", "CP866");
        m_IANAToJava.put("869", "CP869");
        m_IANAToJava.put("ANSI_X3.4-1968", "US-ASCII");
        m_IANAToJava.put("ANSI_X3.4-1986", "US-ASCII");
        m_IANAToJava.put("ARABIC", "ISO-8859-6");
        m_IANAToJava.put("ASCII", "US-ASCII");
        m_IANAToJava.put("ASMO-708", "ISO-8859-6");
        m_IANAToJava.put("BIG5", "MS950");
        m_IANAToJava.put("BIG5-HKSCS", "MS950_HKSCS");
        m_IANAToJava.put("CCSID00858", "Cp858");
        m_IANAToJava.put("CCSID01140", "Cp1140");
        m_IANAToJava.put("CCSID01141", "Cp1141");
        m_IANAToJava.put("CCSID01142", "Cp1142");
        m_IANAToJava.put("CCSID01143", "Cp1143");
        m_IANAToJava.put("CCSID01144", "Cp1144");
        m_IANAToJava.put("CCSID01145", "Cp1145");
        m_IANAToJava.put("CCSID01146", "Cp1146");
        m_IANAToJava.put("CCSID01147", "Cp1147");
        m_IANAToJava.put("CCSID01148", "Cp1148");
        m_IANAToJava.put("CESU-8", "UTF-8");
        m_IANAToJava.put("CHINESE", "MS936");
        m_IANAToJava.put("CP-GR", "CP869");
        m_IANAToJava.put("CP-IS", "CP861");
        m_IANAToJava.put("CP00858", "Cp858");
        m_IANAToJava.put("CP01140", "Cp1140");
        m_IANAToJava.put("CP01141", "Cp1141");
        m_IANAToJava.put("CP01142", "Cp1142");
        m_IANAToJava.put("CP01143", "Cp1143");
        m_IANAToJava.put("CP01144", "Cp1144");
        m_IANAToJava.put("CP01145", "Cp1145");
        m_IANAToJava.put("CP01146", "Cp1146");
        m_IANAToJava.put("CP01147", "Cp1147");
        m_IANAToJava.put("CP01148", "Cp1148");
        m_IANAToJava.put("CP037", "CP037");
        m_IANAToJava.put("CP1026", "CP1026");
        m_IANAToJava.put("CP273", "CP273");
        m_IANAToJava.put("CP278", "CP278");
        m_IANAToJava.put("CP280", "CP280");
        m_IANAToJava.put("CP284", "CP284");
        m_IANAToJava.put("CP285", "CP285");
        m_IANAToJava.put("CP297", "CP297");
        m_IANAToJava.put("CP367", "US-ASCII");
        m_IANAToJava.put("CP420", "CP420");
        m_IANAToJava.put("CP424", "CP424");
        m_IANAToJava.put("CP437", "CP437");
        m_IANAToJava.put("CP500", "CP500");
        m_IANAToJava.put("CP775", "CP775");
        m_IANAToJava.put("CP819", "ISO-8859-1");
        m_IANAToJava.put("CP850", "CP850");
        m_IANAToJava.put("CP852", "CP852");
        m_IANAToJava.put("CP855", "CP855");
        m_IANAToJava.put("CP857", "CP857");
        m_IANAToJava.put("CP860", "CP860");
        m_IANAToJava.put("CP861", "CP861");
        m_IANAToJava.put("CP862", "CP862");
        m_IANAToJava.put("CP863", "CP863");
        m_IANAToJava.put("CP865", "CP865");
        m_IANAToJava.put("CP866", "CP866");
        m_IANAToJava.put("CP869", "CP869");
        m_IANAToJava.put("CP870", "CP870");
        m_IANAToJava.put("CP871", "CP871");
        m_IANAToJava.put("CP891", "US-ASCII");
        m_IANAToJava.put("CP903", "US-ASCII");
        m_IANAToJava.put("CP936", "MS936");
        m_IANAToJava.put("CSASCII", "US-ASCII");
        m_IANAToJava.put("CSBIG5", "MS950");
        m_IANAToJava.put("CSCESU-8", "UTF-8");
        m_IANAToJava.put("CSEUCKR", "MS949");
        m_IANAToJava.put("CSEUCPKDFMTJAPANESE", "EUC-JP");
        m_IANAToJava.put("CSGB2312", "EUC_CN");
        m_IANAToJava.put("CSIBM037", "CP037");
        m_IANAToJava.put("CSIBM1026", "CP1026");
        m_IANAToJava.put("CSIBM273", "CP273");
        m_IANAToJava.put("CSIBM277", "IBM277");
        m_IANAToJava.put("CSIBM278", "CP278");
        m_IANAToJava.put("CSIBM280", "CP280");
        m_IANAToJava.put("CSIBM284", "CP284");
        m_IANAToJava.put("CSIBM285", "CP285");
        m_IANAToJava.put("CSIBM297", "CP297");
        m_IANAToJava.put("CSIBM420", "CP420");
        m_IANAToJava.put("CSIBM424", "CP424");
        m_IANAToJava.put("CSIBM500", "CP500");
        m_IANAToJava.put("CSIBM855", "CP855");
        m_IANAToJava.put("CSIBM857", "CP857");
        m_IANAToJava.put("CSIBM860", "CP860");
        m_IANAToJava.put("CSIBM861", "CP861");
        m_IANAToJava.put("CSIBM863", "CP863");
        m_IANAToJava.put("CSIBM865", "CP865");
        m_IANAToJava.put("CSIBM866", "CP866");
        m_IANAToJava.put("CSIBM869", "CP869");
        m_IANAToJava.put("CSIBM870", "CP870");
        m_IANAToJava.put("CSIBM871", "CP871");
        m_IANAToJava.put("CSIBM891", "US-ASCII");
        m_IANAToJava.put("CSIBM903", "US-ASCII");
        m_IANAToJava.put("CSISO2022JP", "ISO-2022-JP");
        m_IANAToJava.put("CSISO2022KR", "ISO-2022-KR");
        m_IANAToJava.put("CSISO58GB231280", "EUC_CN");
        m_IANAToJava.put("CSISO88596I", "ISO-8859-6");
        m_IANAToJava.put("CSISO88598I", "ISO-8859-8");
        m_IANAToJava.put("CSISOLATIN1", "ISO-8859-1");
        m_IANAToJava.put("CSISOLATIN2", "ISO-8859-2");
        m_IANAToJava.put("CSISOLATIN3", "ISO-8859-3");
        m_IANAToJava.put("CSISOLATIN4", "ISO-8859-4");
        m_IANAToJava.put("CSISOLATIN5", "ISO-8859-9");
        m_IANAToJava.put("CSISOLATINARABIC", "ISO-8859-6");
        m_IANAToJava.put("CSISOLATINCYRILLIC", "ISO-8859-5");
        m_IANAToJava.put("CSISOLATINGREEK", "ISO-8859-7");
        m_IANAToJava.put("CSJISENCODING", "ISO-2022-JP");
        m_IANAToJava.put("CSKOI8R", "KOI8-R");
        m_IANAToJava.put("CSKSC56011987", "MS949");
        m_IANAToJava.put("CSMACINTOSH", "MacRoman");
        m_IANAToJava.put("CSPC775BALTIC", "CP775");
        m_IANAToJava.put("CSPC850MULTILINGUAL", "CP850");
        m_IANAToJava.put("CSPC862LATINHEBREW", "CP862");
        m_IANAToJava.put("CSPC8CODEPAGE437", "CP437");
        m_IANAToJava.put("CSPCP852", "CP852");
        m_IANAToJava.put("CSSHIFTJIS", "MS932");
        m_IANAToJava.put("CSUNICODE", "UTF-16");
        m_IANAToJava.put("CSUSDK", "US-ASCII");
        m_IANAToJava.put("CSWINDOWS30LATIN1", "WINDOWS-1252");
        m_IANAToJava.put("CSWINDOWS31J", "MS932");
        m_IANAToJava.put("CSWINDOWS31LATIN1", "WINDOWS-1252");
        m_IANAToJava.put("CSWINDOWS31LATIN2", "WINDOWS-1250");
        m_IANAToJava.put("CSWINDOWS31LATIN5", "WINDOWS-1254");
        m_IANAToJava.put("CYRILLIC", "ISO-8859-5");
        m_IANAToJava.put("EBCDIC-CP-AR1", "CP420");
        m_IANAToJava.put("EBCDIC-CP-BE", "CP500");
        m_IANAToJava.put("EBCDIC-CP-CA", "CP037");
        m_IANAToJava.put("EBCDIC-CP-CH", "CP500");
        m_IANAToJava.put("EBCDIC-CP-DK", "IBM277");
        m_IANAToJava.put("EBCDIC-CP-ES", "CP284");
        m_IANAToJava.put("EBCDIC-CP-FI", "CP278");
        m_IANAToJava.put("EBCDIC-CP-FR", "CP297");
        m_IANAToJava.put("EBCDIC-CP-GB", "CP285");
        m_IANAToJava.put("EBCDIC-CP-HE", "CP424");
        m_IANAToJava.put("EBCDIC-CP-IS", "CP871");
        m_IANAToJava.put("EBCDIC-CP-IT", "CP280");
        m_IANAToJava.put("EBCDIC-CP-NL", "CP037");
        m_IANAToJava.put("EBCDIC-CP-NO", "IBM277");
        m_IANAToJava.put("EBCDIC-CP-ROECE", "CP870");
        m_IANAToJava.put("EBCDIC-CP-SE", "CP278");
        m_IANAToJava.put("EBCDIC-CP-US", "CP037");
        m_IANAToJava.put("EBCDIC-CP-WT", "CP037");
        m_IANAToJava.put("EBCDIC-CP-YU", "CP870");
        m_IANAToJava.put("EBCDIC-DE-273+EURO", "Cp1141");
        m_IANAToJava.put("EBCDIC-DK-277+EURO", "Cp1142");
        m_IANAToJava.put("EBCDIC-ES-284+EURO", "Cp1145");
        m_IANAToJava.put("EBCDIC-FI-278+EURO", "Cp1143");
        m_IANAToJava.put("EBCDIC-FR-297+EURO", "Cp1147");
        m_IANAToJava.put("EBCDIC-GB-285+EURO", "Cp1146");
        m_IANAToJava.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
        m_IANAToJava.put("EBCDIC-IT-280+EURO", "Cp1144");
        m_IANAToJava.put("EBCDIC-NO-277+EURO", "Cp1142");
        m_IANAToJava.put("EBCDIC-SE-278+EURO", "Cp1143");
        m_IANAToJava.put("EBCDIC-US-37+EURO", "Cp1140");
        m_IANAToJava.put("ECMA-114", "ISO-8859-6");
        m_IANAToJava.put("ECMA-118", "ISO-8859-7");
        m_IANAToJava.put("ELOT_928", "ISO-8859-7");
        m_IANAToJava.put("EUC-JP", "EUC-JP");
        m_IANAToJava.put("EUC-KR", "MS949");
        m_IANAToJava.put("EUC-TW", "EUC-TW");
        m_IANAToJava.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC-JP");
        m_IANAToJava.put("GB18030", "GB18030");
        m_IANAToJava.put("GB2312", "EUC_CN");
        m_IANAToJava.put("GBK", "MS936");
        m_IANAToJava.put("GB_2312-80", "MS936");
        m_IANAToJava.put("GREEK", "ISO-8859-7");
        m_IANAToJava.put("GREEK8", "ISO-8859-7");
        m_IANAToJava.put("IBM00858", "Cp858");
        m_IANAToJava.put("IBM01140", "Cp1140");
        m_IANAToJava.put("IBM01141", "Cp1141");
        m_IANAToJava.put("IBM01142", "Cp1142");
        m_IANAToJava.put("IBM01143", "Cp1143");
        m_IANAToJava.put("IBM01144", "Cp1144");
        m_IANAToJava.put("IBM01145", "Cp1145");
        m_IANAToJava.put("IBM01146", "Cp1146");
        m_IANAToJava.put("IBM01147", "Cp1147");
        m_IANAToJava.put("IBM01148", "Cp1148");
        m_IANAToJava.put("IBM037", "CP037");
        m_IANAToJava.put("IBM1026", "CP1026");
        m_IANAToJava.put("IBM273", "CP273");
        m_IANAToJava.put("IBM277", "IBM277");
        m_IANAToJava.put("IBM278", "CP278");
        m_IANAToJava.put("IBM280", "CP280");
        m_IANAToJava.put("IBM284", "CP284");
        m_IANAToJava.put("IBM285", "CP285");
        m_IANAToJava.put("IBM297", "CP297");
        m_IANAToJava.put("IBM367", "US-ASCII");
        m_IANAToJava.put("IBM420", "CP420");
        m_IANAToJava.put("IBM424", "CP424");
        m_IANAToJava.put("IBM437", "CP437");
        m_IANAToJava.put("IBM500", "CP500");
        m_IANAToJava.put("IBM775", "CP775");
        m_IANAToJava.put("IBM819", "ISO-8859-1");
        m_IANAToJava.put("IBM850", "CP850");
        m_IANAToJava.put("IBM852", "CP852");
        m_IANAToJava.put("IBM855", "CP855");
        m_IANAToJava.put("IBM857", "CP857");
        m_IANAToJava.put("IBM860", "CP860");
        m_IANAToJava.put("IBM861", "CP861");
        m_IANAToJava.put("IBM862", "CP862");
        m_IANAToJava.put("IBM863", "CP863");
        m_IANAToJava.put("IBM865", "CP865");
        m_IANAToJava.put("IBM866", "CP866");
        m_IANAToJava.put("IBM869", "CP869");
        m_IANAToJava.put("IBM870", "CP870");
        m_IANAToJava.put("IBM871", "CP871");
        m_IANAToJava.put("IBM891", "US-ASCII");
        m_IANAToJava.put("IBM903", "US-ASCII");
        m_IANAToJava.put("ISO-10646-UCS-2", "UTF-16");
        m_IANAToJava.put("ISO-2022-CN", "ISO2022CN_GB");
        m_IANAToJava.put("ISO-2022-JP", "ISO-2022-JP");
        m_IANAToJava.put("ISO-2022-KR", "ISO-2022-KR");
        m_IANAToJava.put("ISO-8859-1", "ISO-8859-1");
        m_IANAToJava.put("ISO-8859-1-WINDOWS-3.0-LATIN-1", "WINDOWS-1252");
        m_IANAToJava.put("ISO-8859-1-WINDOWS-3.1-LATIN-1", "WINDOWS-1252");
        m_IANAToJava.put("ISO-8859-13", "ISO-8859-13");
        m_IANAToJava.put("ISO-8859-15", "ISO-8859-15");
        m_IANAToJava.put("ISO-8859-2", "ISO-8859-2");
        m_IANAToJava.put("ISO-8859-2-WINDOWS-LATIN-2", "WINDOWS-1250");
        m_IANAToJava.put("ISO-8859-3", "ISO-8859-3");
        m_IANAToJava.put("ISO-8859-4", "ISO-8859-4");
        m_IANAToJava.put("ISO-8859-5", "ISO-8859-5");
        m_IANAToJava.put("ISO-8859-6", "ISO-8859-6");
        m_IANAToJava.put("ISO-8859-6-I", "ISO-8859-6");
        m_IANAToJava.put("ISO-8859-7", "ISO-8859-7");
        m_IANAToJava.put("ISO-8859-8-I", "ISO-8859-8");
        m_IANAToJava.put("ISO-8859-9", "ISO-8859-9");
        m_IANAToJava.put("ISO-8859-9-WINDOWS-LATIN-5", "WINDOWS-1254");
        m_IANAToJava.put("ISO-IR-100", "ISO-8859-1");
        m_IANAToJava.put("ISO-IR-101", "ISO-8859-2");
        m_IANAToJava.put("ISO-IR-109", "ISO-8859-3");
        m_IANAToJava.put("ISO-IR-110", "ISO-8859-4");
        m_IANAToJava.put("ISO-IR-126", "ISO-8859-7");
        m_IANAToJava.put("ISO-IR-127", "ISO-8859-6");
        m_IANAToJava.put("ISO-IR-144", "ISO-8859-5");
        m_IANAToJava.put("ISO-IR-148", "ISO-8859-9");
        m_IANAToJava.put("ISO-IR-149", "MS949");
        m_IANAToJava.put("ISO-IR-58", "MS936");
        m_IANAToJava.put("ISO-IR-6", "US-ASCII");
        m_IANAToJava.put("ISO646-US", "US-ASCII");
        m_IANAToJava.put("ISO_646.IRV:1991", "US-ASCII");
        m_IANAToJava.put("ISO_8859-1", "ISO-8859-1");
        m_IANAToJava.put("ISO_8859-15", "ISO-8859-15");
        m_IANAToJava.put("ISO_8859-1:1987", "ISO-8859-1");
        m_IANAToJava.put("ISO_8859-2", "ISO-8859-2");
        m_IANAToJava.put("ISO_8859-2:1987", "ISO-8859-2");
        m_IANAToJava.put("ISO_8859-3", "ISO-8859-3");
        m_IANAToJava.put("ISO_8859-3:1988", "ISO-8859-3");
        m_IANAToJava.put("ISO_8859-4", "ISO-8859-4");
        m_IANAToJava.put("ISO_8859-4:1988", "ISO-8859-4");
        m_IANAToJava.put("ISO_8859-5", "ISO-8859-5");
        m_IANAToJava.put("ISO_8859-5:1988", "ISO-8859-5");
        m_IANAToJava.put("ISO_8859-6", "ISO-8859-6");
        m_IANAToJava.put("ISO_8859-6-I", "ISO-8859-6");
        m_IANAToJava.put("ISO_8859-6:1987", "ISO-8859-6");
        m_IANAToJava.put("ISO_8859-7", "ISO-8859-7");
        m_IANAToJava.put("ISO_8859-7:1987", "ISO-8859-7");
        m_IANAToJava.put("ISO_8859-8-I", "ISO-8859-8");
        m_IANAToJava.put("ISO_8859-9", "ISO-8859-9");
        m_IANAToJava.put("ISO_8859-9:1989", "ISO-8859-9");
        m_IANAToJava.put("JIS_ENCODING", "ISO-2022-JP");
        m_IANAToJava.put("KOI8-R", "KOI8-R");
        m_IANAToJava.put("KOREAN", "MS949");
        m_IANAToJava.put("KSC_5601", "MS949");
        m_IANAToJava.put("KS_C_5601-1987", "MS949");
        m_IANAToJava.put("KS_C_5601-1989", "MS949");
        m_IANAToJava.put("L1", "ISO-8859-1");
        m_IANAToJava.put("L2", "ISO-8859-2");
        m_IANAToJava.put("L3", "ISO-8859-3");
        m_IANAToJava.put("L4", "ISO-8859-4");
        m_IANAToJava.put("L5", "ISO-8859-9");
        m_IANAToJava.put("LATIN-9", "ISO-8859-15");
        m_IANAToJava.put("LATIN1", "ISO-8859-1");
        m_IANAToJava.put("LATIN2", "ISO-8859-2");
        m_IANAToJava.put("LATIN3", "ISO-8859-3");
        m_IANAToJava.put("LATIN4", "ISO-8859-4");
        m_IANAToJava.put("LATIN5", "ISO-8859-9");
        m_IANAToJava.put("MAC", "MacRoman");
        m_IANAToJava.put("MACINTOSH", "MacRoman");
        m_IANAToJava.put("MS936", "MS936");
        m_IANAToJava.put("MS_KANJI", "MS932");
        m_IANAToJava.put("PC-MULTILINGUAL-850+EURO", "Cp858");
        m_IANAToJava.put("SHIFT_JIS", "MS932");
        m_IANAToJava.put("TIS-620", "MS874");
        m_IANAToJava.put("US", "US-ASCII");
        m_IANAToJava.put("US-ASCII", "US-ASCII");
        m_IANAToJava.put("US-DK", "US-ASCII");
        m_IANAToJava.put("UTF-16", "UTF-16");
        m_IANAToJava.put("UTF-16BE", "UTF-16BE");
        m_IANAToJava.put("UTF-16LE", "UTF-16LE");
        m_IANAToJava.put("UTF-8", "UTF-8");
        m_IANAToJava.put("WINDOWS-1250", "WINDOWS-1250");
        m_IANAToJava.put("WINDOWS-1251", "WINDOWS-1251");
        m_IANAToJava.put("WINDOWS-1252", "WINDOWS-1252");
        m_IANAToJava.put("WINDOWS-1253", "WINDOWS-1253");
        m_IANAToJava.put("WINDOWS-1254", "WINDOWS-1254");
        m_IANAToJava.put("WINDOWS-1255", "WINDOWS-1255");
        m_IANAToJava.put("WINDOWS-1256", "WINDOWS-1256");
        m_IANAToJava.put("WINDOWS-1257", "WINDOWS-1257");
        m_IANAToJava.put("WINDOWS-1258", "WINDOWS-1258");
        m_IANAToJava.put("WINDOWS-31J", "MS932");
        m_IANAToJava.put("WINDOWS-874", "MS874");
        m_IANAToJava.put("WINDOWS-936", "MS936");
        m_IANAToJava.put("WINDOWS-949", "MS949");
        m_IANAToJava.put("WINDOWS-950", "MS950");
    }
}

