/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util.resources.map;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;

public class DefaultLanguageMap {
    public static final String RCS_ID = "$Header: DefaultLanguageMap.java 120.10 2014/10/23 23:32:36 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultLanguageMap.java 120.10 2014/10/23 23:32:36 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util.resources.map");
    private static final String NO_MAPPING_DATA = "NOMAP";
    private static Hashtable m_OracleToJava = new Hashtable();
    private static Hashtable m_JavaToOracle;
    private static Hashtable m_OracleToLangTag;
    private static Hashtable m_LangTagToOracle;

    public static String getOracleLanguageFromJava(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_JavaToOracle.get(string.toLowerCase(Locale.US));
    }

    public static String getJavaLanguageFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_OracleToJava.get(string.toUpperCase(Locale.US));
    }

    public static String getLanguageTagFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_OracleToLangTag.get(string.toUpperCase(Locale.US));
    }

    public static String getOracleFromLanguageTag(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_LangTagToOracle.get(string.toLowerCase(Locale.US));
        if (string2 == null) {
            int n = string.indexOf("-");
            if (n != -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1, string.length());
                if ((n = string4.indexOf("-")) != -1) {
                    String string5 = string4.substring(0, n);
                    if (string5.length() == 4) {
                        string2 = (String)m_LangTagToOracle.get(string3.toLowerCase(Locale.US) + "-" + string5.toLowerCase(Locale.US));
                        if (string2 == null) {
                            string2 = (String)m_LangTagToOracle.get(string3.toLowerCase(Locale.US));
                        }
                    } else {
                        string2 = (String)m_LangTagToOracle.get(string3.toLowerCase(Locale.US));
                    }
                } else {
                    string2 = (String)m_LangTagToOracle.get(string3.toLowerCase(Locale.US));
                }
            }
            if (string2 == null) {
                string2 = NO_MAPPING_DATA;
            }
            m_LangTagToOracle.put(string.toLowerCase(Locale.US), string2);
        }
        if (NO_MAPPING_DATA.equals(string2)) {
            string2 = null;
        }
        return string2;
    }

    static {
        m_OracleToJava.put("ALBANIAN", "sq");
        m_OracleToJava.put("AMERICAN", "en");
        m_OracleToJava.put("AMHARIC", "am");
        m_OracleToJava.put("ARABIC", "ar");
        m_OracleToJava.put("ARMENIAN", "hy");
        m_OracleToJava.put("ASSAMESE", "as");
        m_OracleToJava.put("AZERBAIJANI", "az");
        m_OracleToJava.put("BANGLA", "bn");
        m_OracleToJava.put("BENGALI", "bn");
        m_OracleToJava.put("BELARUSIAN", "be");
        m_OracleToJava.put("BRAZILIAN PORTUGUESE", "pt");
        m_OracleToJava.put("BULGARIAN", "bg");
        m_OracleToJava.put("CANADIAN FRENCH", "fr");
        m_OracleToJava.put("CATALAN", "ca");
        m_OracleToJava.put("CROATIAN", "hr");
        m_OracleToJava.put("CYRILLIC KAZAKH", "kk");
        m_OracleToJava.put("CYRILLIC SERBIAN", "sr");
        m_OracleToJava.put("CYRILLIC UZBEK", "uz");
        m_OracleToJava.put("CZECH", "cs");
        m_OracleToJava.put("DANISH", "da");
        m_OracleToJava.put("DARI", "fa");
        m_OracleToJava.put("DIVEHI", "dv");
        m_OracleToJava.put("DUTCH", "nl");
        m_OracleToJava.put("EGYPTIAN", "ar");
        m_OracleToJava.put("ENGLISH", "en");
        m_OracleToJava.put("ESTONIAN", "et");
        m_OracleToJava.put("FINNISH", "fi");
        m_OracleToJava.put("FRENCH", "fr");
        m_OracleToJava.put("GERMAN", "de");
        m_OracleToJava.put("GERMAN DIN", "de");
        m_OracleToJava.put("GREEK", "el");
        m_OracleToJava.put("GUJARATI", "gu");
        m_OracleToJava.put("HEBREW", "he");
        m_OracleToJava.put("HINDI", "hi");
        m_OracleToJava.put("HUNGARIAN", "hu");
        m_OracleToJava.put("ICELANDIC", "is");
        m_OracleToJava.put("INDONESIAN", "id");
        m_OracleToJava.put("IRISH", "ga");
        m_OracleToJava.put("ITALIAN", "it");
        m_OracleToJava.put("JAPANESE", "ja");
        m_OracleToJava.put("KANNADA", "kn");
        m_OracleToJava.put("KHMER", "km");
        m_OracleToJava.put("KOREAN", "ko");
        m_OracleToJava.put("LAO", "lo");
        m_OracleToJava.put("LATIN AMERICAN SPANISH", "es");
        m_OracleToJava.put("LATIN BOSNIAN", "bs");
        m_OracleToJava.put("LATIN SERBIAN", "sh");
        m_OracleToJava.put("LATIN UZBEK", "uz");
        m_OracleToJava.put("LATVIAN", "lv");
        m_OracleToJava.put("LITHUANIAN", "lt");
        m_OracleToJava.put("MACEDONIAN", "mk");
        m_OracleToJava.put("MALAY", "ms");
        m_OracleToJava.put("MALAYALAM", "ml");
        m_OracleToJava.put("MALTESE", "mt");
        m_OracleToJava.put("MARATHI", "mr");
        m_OracleToJava.put("MEXICAN SPANISH", "es");
        m_OracleToJava.put("NEPALI", "ne");
        m_OracleToJava.put("NORWEGIAN", "no");
        m_OracleToJava.put("NUMERIC DATE LANGUAGE", "en");
        m_OracleToJava.put("ORIYA", "or");
        m_OracleToJava.put("PERSIAN", "fa");
        m_OracleToJava.put("POLISH", "pl");
        m_OracleToJava.put("PORTUGUESE", "pt");
        m_OracleToJava.put("PUNJABI", "pa");
        m_OracleToJava.put("ROMANIAN", "ro");
        m_OracleToJava.put("RUSSIAN", "ru");
        m_OracleToJava.put("SIMPLIFIED CHINESE", "zh");
        m_OracleToJava.put("SINHALA", "si");
        m_OracleToJava.put("SLOVAK", "sk");
        m_OracleToJava.put("SLOVENIAN", "sl");
        m_OracleToJava.put("SPANISH", "es");
        m_OracleToJava.put("SWAHILI", "sw");
        m_OracleToJava.put("SWEDISH", "sv");
        m_OracleToJava.put("TAMIL", "ta");
        m_OracleToJava.put("TELUGU", "te");
        m_OracleToJava.put("THAI", "th");
        m_OracleToJava.put("TRADITIONAL CHINESE", "zh");
        m_OracleToJava.put("TURKISH", "tr");
        m_OracleToJava.put("UKRAINIAN", "uk");
        m_OracleToJava.put("VIETNAMESE", "vi");
        m_JavaToOracle = new Hashtable();
        m_JavaToOracle.put("am", "AMHARIC");
        m_JavaToOracle.put("ar", "ARABIC");
        m_JavaToOracle.put("as", "ASSAMESE");
        m_JavaToOracle.put("az", "AZERBAIJANI");
        m_JavaToOracle.put("be", "BELARUSIAN");
        m_JavaToOracle.put("bg", "BULGARIAN");
        m_JavaToOracle.put("bn", "BANGLA");
        m_JavaToOracle.put("bs", "LATIN BOSNIAN");
        m_JavaToOracle.put("ca", "CATALAN");
        m_JavaToOracle.put("cs", "CZECH");
        m_JavaToOracle.put("da", "DANISH");
        m_JavaToOracle.put("de", "GERMAN");
        m_JavaToOracle.put("dv", "DIVEHI");
        m_JavaToOracle.put("el", "GREEK");
        m_JavaToOracle.put("en", "AMERICAN");
        m_JavaToOracle.put("es", "SPANISH");
        m_JavaToOracle.put("et", "ESTONIAN");
        m_JavaToOracle.put("fa", "PERSIAN");
        m_JavaToOracle.put("fi", "FINNISH");
        m_JavaToOracle.put("fr", "FRENCH");
        m_JavaToOracle.put("ga", "IRISH");
        m_JavaToOracle.put("gu", "GUJARATI");
        m_JavaToOracle.put("he", "HEBREW");
        m_JavaToOracle.put("hi", "HINDI");
        m_JavaToOracle.put("hr", "CROATIAN");
        m_JavaToOracle.put("hu", "HUNGARIAN");
        m_JavaToOracle.put("hy", "ARMENIAN");
        m_JavaToOracle.put("id", "INDONESIAN");
        m_JavaToOracle.put("in", "INDONESIAN");
        m_JavaToOracle.put("is", "ICELANDIC");
        m_JavaToOracle.put("it", "ITALIAN");
        m_JavaToOracle.put("iw", "HEBREW");
        m_JavaToOracle.put("ja", "JAPANESE");
        m_JavaToOracle.put("kk", "CYRILLIC KAZAKH");
        m_JavaToOracle.put("km", "KHMER");
        m_JavaToOracle.put("kn", "KANNADA");
        m_JavaToOracle.put("ko", "KOREAN");
        m_JavaToOracle.put("lo", "LAO");
        m_JavaToOracle.put("lt", "LITHUANIAN");
        m_JavaToOracle.put("lv", "LATVIAN");
        m_JavaToOracle.put("ml", "MALAYALAM");
        m_JavaToOracle.put("mr", "MARATHI");
        m_JavaToOracle.put("ms", "MALAY");
        m_JavaToOracle.put("mk", "MACEDONIAN");
        m_JavaToOracle.put("mt", "MALTESE");
        m_JavaToOracle.put("nb", "NORWEGIAN");
        m_JavaToOracle.put("ne", "NEPALI");
        m_JavaToOracle.put("nl", "DUTCH");
        m_JavaToOracle.put("no", "NORWEGIAN");
        m_JavaToOracle.put("or", "ORIYA");
        m_JavaToOracle.put("pa", "PUNJABI");
        m_JavaToOracle.put("pl", "POLISH");
        m_JavaToOracle.put("pt", "PORTUGUESE");
        m_JavaToOracle.put("ro", "ROMANIAN");
        m_JavaToOracle.put("ru", "RUSSIAN");
        m_JavaToOracle.put("sh", "LATIN SERBIAN");
        m_JavaToOracle.put("si", "SINHALA");
        m_JavaToOracle.put("sk", "SLOVAK");
        m_JavaToOracle.put("sl", "SLOVENIAN");
        m_JavaToOracle.put("sq", "ALBANIAN");
        m_JavaToOracle.put("sr", "CYRILLIC SERBIAN");
        m_JavaToOracle.put("sv", "SWEDISH");
        m_JavaToOracle.put("sw", "SWAHILI");
        m_JavaToOracle.put("ta", "TAMIL");
        m_JavaToOracle.put("te", "TELUGU");
        m_JavaToOracle.put("th", "THAI");
        m_JavaToOracle.put("tr", "TURKISH");
        m_JavaToOracle.put("uk", "UKRAINIAN");
        m_JavaToOracle.put("uz", "LATIN UZBEK");
        m_JavaToOracle.put("vi", "VIETNAMESE");
        m_JavaToOracle.put("zh", "SIMPLIFIED CHINESE");
        m_OracleToLangTag = new Hashtable();
        m_OracleToLangTag.put("ALBANIAN", "sq-AL");
        m_OracleToLangTag.put("AMERICAN", "en-US");
        m_OracleToLangTag.put("AMHARIC", "am-ET");
        m_OracleToLangTag.put("ARABIC", "ar-AE");
        m_OracleToLangTag.put("ARMENIAN", "hy-AM");
        m_OracleToLangTag.put("ASSAMESE", "as-IN");
        m_OracleToLangTag.put("AZERBAIJANI", "az-AZ");
        m_OracleToLangTag.put("BANGLA", "bn-IN");
        m_OracleToLangTag.put("BENGALI", "bn-BD");
        m_OracleToLangTag.put("BELARUSIAN", "be-BY");
        m_OracleToLangTag.put("BRAZILIAN PORTUGUESE", "pt-BR");
        m_OracleToLangTag.put("BULGARIAN", "bg-BG");
        m_OracleToLangTag.put("CANADIAN FRENCH", "fr-CA");
        m_OracleToLangTag.put("CATALAN", "ca-ES");
        m_OracleToLangTag.put("CROATIAN", "hr-HR");
        m_OracleToLangTag.put("CYRILLIC KAZAKH", "kk-KZ");
        m_OracleToLangTag.put("CYRILLIC SERBIAN", "sr-RS");
        m_OracleToLangTag.put("CYRILLIC UZBEK", "uz-UZ");
        m_OracleToLangTag.put("CZECH", "cs-CZ");
        m_OracleToLangTag.put("DANISH", "da-DK");
        m_OracleToLangTag.put("DARI", "fa-AF");
        m_OracleToLangTag.put("DIVEHI", "dv-MV");
        m_OracleToLangTag.put("DUTCH", "nl-NL");
        m_OracleToLangTag.put("EGYPTIAN", "ar-EG");
        m_OracleToLangTag.put("ENGLISH", "en-GB");
        m_OracleToLangTag.put("ESTONIAN", "et-EE");
        m_OracleToLangTag.put("FINNISH", "fi-FI");
        m_OracleToLangTag.put("FRENCH", "fr-FR");
        m_OracleToLangTag.put("GERMAN", "de-DE");
        m_OracleToLangTag.put("GERMAN DIN", "de-DE");
        m_OracleToLangTag.put("GREEK", "el-GR");
        m_OracleToLangTag.put("GUJARATI", "gu-IN");
        m_OracleToLangTag.put("HEBREW", "he-IL");
        m_OracleToLangTag.put("HINDI", "hi-IN");
        m_OracleToLangTag.put("HUNGARIAN", "hu-HU");
        m_OracleToLangTag.put("ICELANDIC", "is-IS");
        m_OracleToLangTag.put("INDONESIAN", "id-ID");
        m_OracleToLangTag.put("IRISH", "ga-IE");
        m_OracleToLangTag.put("ITALIAN", "it-IT");
        m_OracleToLangTag.put("JAPANESE", "ja-JP");
        m_OracleToLangTag.put("KANNADA", "kn-IN");
        m_OracleToLangTag.put("KHMER", "km-KH");
        m_OracleToLangTag.put("KOREAN", "ko-KR");
        m_OracleToLangTag.put("LAO", "lo-LA");
        m_OracleToLangTag.put("LATIN AMERICAN SPANISH", "es-US");
        m_OracleToLangTag.put("LATIN BOSNIAN", "bs-BA");
        m_OracleToLangTag.put("LATIN SERBIAN", "sh-RS");
        m_OracleToLangTag.put("LATIN UZBEK", "uz-UZ");
        m_OracleToLangTag.put("LATVIAN", "lv-LV");
        m_OracleToLangTag.put("LITHUANIAN", "lt-LT");
        m_OracleToLangTag.put("MACEDONIAN", "mk-MK");
        m_OracleToLangTag.put("MALAY", "ms-MY");
        m_OracleToLangTag.put("MALAYALAM", "ml-IN");
        m_OracleToLangTag.put("MALTESE", "mt-MT");
        m_OracleToLangTag.put("MARATHI", "mr-IN");
        m_OracleToLangTag.put("MEXICAN SPANISH", "es-MX");
        m_OracleToLangTag.put("NEPALI", "ne-NP");
        m_OracleToLangTag.put("NORWEGIAN", "no-NO");
        m_OracleToLangTag.put("NUMERIC DATE LANGUAGE", "en-US");
        m_OracleToLangTag.put("ORIYA", "or-IN");
        m_OracleToLangTag.put("PERSIAN", "fa-IR");
        m_OracleToLangTag.put("POLISH", "pl-PL");
        m_OracleToLangTag.put("PORTUGUESE", "pt-PT");
        m_OracleToLangTag.put("PUNJABI", "pa-IN");
        m_OracleToLangTag.put("ROMANIAN", "ro-RO");
        m_OracleToLangTag.put("RUSSIAN", "ru-RU");
        m_OracleToLangTag.put("SIMPLIFIED CHINESE", "zh-CN");
        m_OracleToLangTag.put("SINHALA", "si-LK");
        m_OracleToLangTag.put("SLOVAK", "sk-SK");
        m_OracleToLangTag.put("SLOVENIAN", "sl-SI");
        m_OracleToLangTag.put("SPANISH", "es-ES");
        m_OracleToLangTag.put("SWAHILI", "sw-KE");
        m_OracleToLangTag.put("SWEDISH", "sv-SE");
        m_OracleToLangTag.put("TAMIL", "ta-IN");
        m_OracleToLangTag.put("TELUGU", "te-IN");
        m_OracleToLangTag.put("THAI", "th-TH");
        m_OracleToLangTag.put("TRADITIONAL CHINESE", "zh-TW");
        m_OracleToLangTag.put("TURKISH", "tr-TR");
        m_OracleToLangTag.put("UKRAINIAN", "uk-UA");
        m_OracleToLangTag.put("VIETNAMESE", "vi-VN");
        m_LangTagToOracle = new Hashtable();
        m_LangTagToOracle.put("am", "AMHARIC");
        m_LangTagToOracle.put("ar", "ARABIC");
        m_LangTagToOracle.put("ar-eg", "EGYPTIAN");
        m_LangTagToOracle.put("as", "ASSAMESE");
        m_LangTagToOracle.put("az", "AZERBAIJANI");
        m_LangTagToOracle.put("be", "BELARUSIAN");
        m_LangTagToOracle.put("bg", "BULGARIAN");
        m_LangTagToOracle.put("bn", "BANGLA");
        m_LangTagToOracle.put("bs", "LATIN BOSNIAN");
        m_LangTagToOracle.put("bs-latn", "LATIN BOSNIAN");
        m_LangTagToOracle.put("ca", "CATALAN");
        m_LangTagToOracle.put("cs", "CZECH");
        m_LangTagToOracle.put("da", "DANISH");
        m_LangTagToOracle.put("de", "GERMAN");
        m_LangTagToOracle.put("dv", "DIVEHI");
        m_LangTagToOracle.put("el", "GREEK");
        m_LangTagToOracle.put("en", "AMERICAN");
        m_LangTagToOracle.put("en-gb", "ENGLISH");
        m_LangTagToOracle.put("es", "SPANISH");
        m_LangTagToOracle.put("es-ar", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-bo", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-cl", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-co", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-cr", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-do", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-ec", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-gt", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-hn", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-mx", "MEXICAN SPANISH");
        m_LangTagToOracle.put("es-ni", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-pa", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-pe", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-pr", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-py", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-sv", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-us", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-uy", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("es-ve", "LATIN AMERICAN SPANISH");
        m_LangTagToOracle.put("et", "ESTONIAN");
        m_LangTagToOracle.put("fa", "PERSIAN");
        m_LangTagToOracle.put("fa-af", "DARI");
        m_LangTagToOracle.put("fi", "FINNISH");
        m_LangTagToOracle.put("fr", "FRENCH");
        m_LangTagToOracle.put("fr-ca", "CANADIAN FRENCH");
        m_LangTagToOracle.put("ga", "IRISH");
        m_LangTagToOracle.put("gu", "GUJARATI");
        m_LangTagToOracle.put("he", "HEBREW");
        m_LangTagToOracle.put("hi", "HINDI");
        m_LangTagToOracle.put("hr", "CROATIAN");
        m_LangTagToOracle.put("hu", "HUNGARIAN");
        m_LangTagToOracle.put("hy", "ARMENIAN");
        m_LangTagToOracle.put("id", "INDONESIAN");
        m_LangTagToOracle.put("in", "INDONESIAN");
        m_LangTagToOracle.put("is", "ICELANDIC");
        m_LangTagToOracle.put("it", "ITALIAN");
        m_LangTagToOracle.put("iw", "HEBREW");
        m_LangTagToOracle.put("ja", "JAPANESE");
        m_LangTagToOracle.put("kk", "CYRILLIC KAZAKH");
        m_LangTagToOracle.put("kk-cyrl", "CYRILLIC KAZAKH");
        m_LangTagToOracle.put("km", "KHMER");
        m_LangTagToOracle.put("kn", "KANNADA");
        m_LangTagToOracle.put("ko", "KOREAN");
        m_LangTagToOracle.put("lo", "LAO");
        m_LangTagToOracle.put("lt", "LITHUANIAN");
        m_LangTagToOracle.put("lv", "LATVIAN");
        m_LangTagToOracle.put("ml", "MALAYALAM");
        m_LangTagToOracle.put("mr", "MARATHI");
        m_LangTagToOracle.put("ms", "MALAY");
        m_LangTagToOracle.put("mk", "MACEDONIAN");
        m_LangTagToOracle.put("mt", "MALTESE");
        m_LangTagToOracle.put("nb", "NORWEGIAN");
        m_LangTagToOracle.put("ne", "NEPALI");
        m_LangTagToOracle.put("nl", "DUTCH");
        m_LangTagToOracle.put("no", "NORWEGIAN");
        m_LangTagToOracle.put("or", "ORIYA");
        m_LangTagToOracle.put("pa", "PUNJABI");
        m_LangTagToOracle.put("pl", "POLISH");
        m_LangTagToOracle.put("pt", "PORTUGUESE");
        m_LangTagToOracle.put("pt-br", "BRAZILIAN PORTUGUESE");
        m_LangTagToOracle.put("ro", "ROMANIAN");
        m_LangTagToOracle.put("ru", "RUSSIAN");
        m_LangTagToOracle.put("sh", "LATIN SERBIAN");
        m_LangTagToOracle.put("si", "SINHALA");
        m_LangTagToOracle.put("sk", "SLOVAK");
        m_LangTagToOracle.put("sl", "SLOVENIAN");
        m_LangTagToOracle.put("sq", "ALBANIAN");
        m_LangTagToOracle.put("sr", "CYRILLIC SERBIAN");
        m_LangTagToOracle.put("sr-cyrl", "CYRILLIC SERBIAN");
        m_LangTagToOracle.put("sr-latn", "LATIN SERBIAN");
        m_LangTagToOracle.put("sv", "SWEDISH");
        m_LangTagToOracle.put("sw", "SWAHILI");
        m_LangTagToOracle.put("ta", "TAMIL");
        m_LangTagToOracle.put("te", "TELUGU");
        m_LangTagToOracle.put("th", "THAI");
        m_LangTagToOracle.put("tr", "TURKISH");
        m_LangTagToOracle.put("uk", "UKRAINIAN");
        m_LangTagToOracle.put("uz", "LATIN UZBEK");
        m_LangTagToOracle.put("uz-cyrl", "CYRILLIC UZBEK");
        m_LangTagToOracle.put("uz-latn", "LATIN UZBEK");
        m_LangTagToOracle.put("vi", "VIETNAMESE");
        m_LangTagToOracle.put("zh", "SIMPLIFIED CHINESE");
        m_LangTagToOracle.put("zh-cn", "SIMPLIFIED CHINESE");
        m_LangTagToOracle.put("zh-hk", "TRADITIONAL CHINESE");
        m_LangTagToOracle.put("zh-mo", "TRADITIONAL CHINESE");
        m_LangTagToOracle.put("zh-tw", "TRADITIONAL CHINESE");
    }
}

