/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.common.util.resources.map;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;

public class DefaultMailCharsetMap {
    public static final String RCS_ID = "$Header: DefaultMailCharsetMap.java 120.10 2014/10/23 23:34:32 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: DefaultMailCharsetMap.java 120.10 2014/10/23 23:34:32 rsuzuki ship $", "oracle.apps.fnd.i18n.common.util.resources.map");
    private static Hashtable m_LanguageToCharset = new Hashtable();
    private static Hashtable m_LanguageToEncoding = new Hashtable();
    private static Hashtable m_LangCodeToEncodings;
    private static Hashtable m_CharsetToCharsets;

    public static String getCharset(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_LanguageToCharset.get(string.toUpperCase(Locale.US));
    }

    public static String getEncoding(String string) {
        if (string == null) {
            return null;
        }
        return (String)m_LanguageToEncoding.get(string.toUpperCase(Locale.US));
    }

    public static String[] getCharsetsFromLangCode(String string) {
        if (string == null) {
            return null;
        }
        return (String[])m_LangCodeToEncodings.get(string.toUpperCase(Locale.US));
    }

    public static String[] getCharsetsFromCharset(String string) {
        if (string == null) {
            return null;
        }
        return (String[])m_CharsetToCharsets.get(string.toUpperCase(Locale.US));
    }

    static {
        m_LanguageToCharset.put("ALBANIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("ALBANIAN", "B");
        m_LanguageToCharset.put("ARABIC", "ISO-8859-6");
        m_LanguageToEncoding.put("ARABIC", "B");
        m_LanguageToCharset.put("BULGARIAN", "ISO-8859-5");
        m_LanguageToEncoding.put("BULGARIAN", "B");
        m_LanguageToCharset.put("CATALAN", "ISO-8859-1");
        m_LanguageToEncoding.put("CATALAN", "Q");
        m_LanguageToCharset.put("CZECH", "ISO-8859-2");
        m_LanguageToEncoding.put("CZECH", "B");
        m_LanguageToCharset.put("GERMAN", "ISO-8859-1");
        m_LanguageToEncoding.put("GERMAN", "Q");
        m_LanguageToCharset.put("DANISH", "ISO-8859-1");
        m_LanguageToEncoding.put("DANISH", "Q");
        m_LanguageToCharset.put("SPANISH", "ISO-8859-1");
        m_LanguageToEncoding.put("SPANISH", "Q");
        m_LanguageToCharset.put("EGYPTIAN", "ISO-8859-6");
        m_LanguageToEncoding.put("EGYPTIAN", "B");
        m_LanguageToCharset.put("GREEK", "ISO-8859-7");
        m_LanguageToEncoding.put("GREEK", "B");
        m_LanguageToCharset.put("LATIN AMERICAN SPANISH", "ISO-8859-1");
        m_LanguageToEncoding.put("LATIN AMERICAN SPANISH", "Q");
        m_LanguageToCharset.put("FRENCH", "ISO-8859-1");
        m_LanguageToEncoding.put("FRENCH", "Q");
        m_LanguageToCharset.put("CANADIAN FRENCH", "ISO-8859-1");
        m_LanguageToEncoding.put("CANADIAN FRENCH", "Q");
        m_LanguageToCharset.put("ENGLISH", "ISO-8859-1");
        m_LanguageToEncoding.put("ENGLISH", "Q");
        m_LanguageToCharset.put("CROATIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("CROATIAN", "B");
        m_LanguageToCharset.put("HUNGARIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("HUNGARIAN", "B");
        m_LanguageToCharset.put("ITALIAN", "ISO-8859-1");
        m_LanguageToEncoding.put("ITALIAN", "Q");
        m_LanguageToCharset.put("ICELANDIC", "ISO-8859-1");
        m_LanguageToEncoding.put("ICELANDIC", "Q");
        m_LanguageToCharset.put("HEBREW", "ISO-8859-8");
        m_LanguageToEncoding.put("HEBREW", "B");
        m_LanguageToCharset.put("JAPANESE", "ISO-2022-JP");
        m_LanguageToEncoding.put("JAPANESE", "Q");
        m_LanguageToCharset.put("KOREAN", "EUC-KR");
        m_LanguageToEncoding.put("KOREAN", "B");
        m_LanguageToCharset.put("LITHUANIAN", "ISO-8859-4");
        m_LanguageToEncoding.put("LITHUANIAN", "B");
        m_LanguageToCharset.put("NORWEGIAN", "ISO-8859-1");
        m_LanguageToEncoding.put("NORWEGIAN", "Q");
        m_LanguageToCharset.put("DUTCH", "ISO-8859-1");
        m_LanguageToEncoding.put("DUTCH", "Q");
        m_LanguageToCharset.put("POLISH", "ISO-8859-2");
        m_LanguageToEncoding.put("POLISH", "B");
        m_LanguageToCharset.put("PORTUGUESE", "ISO-8859-1");
        m_LanguageToEncoding.put("PORTUGUESE", "Q");
        m_LanguageToCharset.put("BRAZILIAN PORTUGUESE", "ISO-8859-1");
        m_LanguageToEncoding.put("BRAZILIAN PORTUGUESE", "Q");
        m_LanguageToCharset.put("ROMANIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("ROMANIAN", "B");
        m_LanguageToCharset.put("RUSSIAN", "ISO-8859-5");
        m_LanguageToEncoding.put("RUSSIAN", "B");
        m_LanguageToCharset.put("SWEDISH", "ISO-8859-1");
        m_LanguageToEncoding.put("SWEDISH", "Q");
        m_LanguageToCharset.put("FINNISH", "ISO-8859-1");
        m_LanguageToEncoding.put("FINNISH", "Q");
        m_LanguageToCharset.put("SLOVAK", "ISO-8859-2");
        m_LanguageToEncoding.put("SLOVAK", "B");
        m_LanguageToCharset.put("SLOVENIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("SLOVENIAN", "B");
        m_LanguageToCharset.put("THAI", "TIS620");
        m_LanguageToEncoding.put("THAI", "B");
        m_LanguageToCharset.put("TURKISH", "ISO-8859-9");
        m_LanguageToEncoding.put("TURKISH", "B");
        m_LanguageToCharset.put("AMERICAN", "ISO-8859-1");
        m_LanguageToEncoding.put("AMERICAN", "Q");
        m_LanguageToCharset.put("SIMPLIFIED CHINESE", "GB2312");
        m_LanguageToEncoding.put("SIMPLIFIED CHINESE", "B");
        m_LanguageToCharset.put("TRADITIONAL CHINESE", "BIG5");
        m_LanguageToEncoding.put("TRADITIONAL CHINESE", "B");
        m_LanguageToCharset.put("MEXICAN SPANISH", "ISO-8859-1");
        m_LanguageToEncoding.put("MEXICAN SPANISH", "Q");
        m_LanguageToCharset.put("VIETNAMESE", "WINDOWS-1258");
        m_LanguageToEncoding.put("VIETNAMESE", "B");
        m_LanguageToCharset.put("UKRAINIAN", "WINDOWS-1251");
        m_LanguageToEncoding.put("UKRAINIAN", "B");
        m_LanguageToCharset.put("INDONESIAN", "ISO-8859-1");
        m_LanguageToEncoding.put("INDONESIAN", "Q");
        m_LanguageToCharset.put("CYRILLIC SERBIAN", "ISO-8859-5");
        m_LanguageToEncoding.put("CYRILLIC SERBIAN", "B");
        m_LanguageToCharset.put("LATIN SERBIAN", "ISO-8859-2");
        m_LanguageToEncoding.put("LATIN SERBIAN", "B");
        m_LanguageToCharset.put("CYRILLIC KAZAKH", "UTF-8");
        m_LanguageToEncoding.put("CYRILLIC KAZAKH", "B");
        m_LanguageToCharset.put("AMHARIC", "UTF-8");
        m_LanguageToEncoding.put("AMHARIC", "B");
        m_LanguageToCharset.put("ARMENIAN", "UTF-8");
        m_LanguageToEncoding.put("ARMENIAN", "B");
        m_LanguageToCharset.put("ASSAMESE", "UTF-8");
        m_LanguageToEncoding.put("ASSAMESE", "B");
        m_LanguageToCharset.put("AZERBAIJANI", "UTF-8");
        m_LanguageToEncoding.put("AZERBAIJANI", "B");
        m_LanguageToCharset.put("BANGLA", "UTF-8");
        m_LanguageToEncoding.put("BANGLA", "B");
        m_LanguageToCharset.put("BELARUSIAN", "ISO-8859-5");
        m_LanguageToEncoding.put("BELARUSIAN", "B");
        m_LanguageToCharset.put("CYRILLIC UZBEK", "UTF-8");
        m_LanguageToEncoding.put("CYRILLIC UZBEK", "B");
        m_LanguageToCharset.put("DARI", "UTF-8");
        m_LanguageToEncoding.put("DARI", "B");
        m_LanguageToCharset.put("DIVEHI", "UTF-8");
        m_LanguageToEncoding.put("DIVEHI", "B");
        m_LanguageToCharset.put("ESTONIAN", "ISO-8859-4");
        m_LanguageToEncoding.put("ESTONIAN", "B");
        m_LanguageToCharset.put("GERMAN DIN", "ISO-8859-1");
        m_LanguageToEncoding.put("GERMAN DIN", "Q");
        m_LanguageToCharset.put("GUJARATI", "UTF-8");
        m_LanguageToEncoding.put("GUJARATI", "B");
        m_LanguageToCharset.put("HINDI", "UTF-8");
        m_LanguageToEncoding.put("HINDI", "B");
        m_LanguageToCharset.put("IRISH", "ISO-8859-14");
        m_LanguageToEncoding.put("IRISH", "B");
        m_LanguageToCharset.put("KANNADA", "UTF-8");
        m_LanguageToEncoding.put("KANNADA", "B");
        m_LanguageToCharset.put("KHMER", "UTF-8");
        m_LanguageToEncoding.put("KHMER", "B");
        m_LanguageToCharset.put("LAO", "UTF-8");
        m_LanguageToEncoding.put("LAO", "B");
        m_LanguageToCharset.put("LATIN BOSNIAN", "UTF-8");
        m_LanguageToEncoding.put("LATIN BOSNIAN", "B");
        m_LanguageToCharset.put("LATIN UZBEK", "UTF-8");
        m_LanguageToEncoding.put("LATIN UZBEK", "B");
        m_LanguageToCharset.put("LATVIAN", "ISO-8859-4");
        m_LanguageToEncoding.put("LATVIAN", "B");
        m_LanguageToCharset.put("MACEDONIAN", "ISO-8859-5");
        m_LanguageToEncoding.put("MACEDONIAN", "B");
        m_LanguageToCharset.put("MALAY", "ISO-8859-1");
        m_LanguageToEncoding.put("MALAY", "Q");
        m_LanguageToCharset.put("MALAYALAM", "UTF-8");
        m_LanguageToEncoding.put("MALAYALAM", "B");
        m_LanguageToCharset.put("MALTESE", "UTF-8");
        m_LanguageToEncoding.put("MALTESE", "B");
        m_LanguageToCharset.put("MARATHI", "UTF-8");
        m_LanguageToEncoding.put("MARATHI", "B");
        m_LanguageToCharset.put("NEPALI", "UTF-8");
        m_LanguageToEncoding.put("NEPALI", "B");
        m_LanguageToCharset.put("ORIYA", "UTF-8");
        m_LanguageToEncoding.put("ORIYA", "B");
        m_LanguageToCharset.put("PERSIAN", "UTF-8");
        m_LanguageToEncoding.put("PERSIAN", "B");
        m_LanguageToCharset.put("PUNJABI", "UTF-8");
        m_LanguageToEncoding.put("PUNJABI", "B");
        m_LanguageToCharset.put("SINHALA", "UTF-8");
        m_LanguageToEncoding.put("SINHALA", "B");
        m_LanguageToCharset.put("SWAHILI", "UTF-8");
        m_LanguageToEncoding.put("SWAHILI", "B");
        m_LanguageToCharset.put("TAMIL", "UTF-8");
        m_LanguageToEncoding.put("TAMIL", "B");
        m_LanguageToCharset.put("TELUGU", "UTF-8");
        m_LanguageToEncoding.put("TELUGU", "B");
        m_LangCodeToEncodings = new Hashtable();
        m_CharsetToCharsets = new Hashtable();
        m_LangCodeToEncodings.put("AR", new String[]{"UTF-8", "Windows-1256", "ISO-8859-6"});
        m_LangCodeToEncodings.put("BG", new String[]{"UTF-8", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("CA", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("CKK", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("CS", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("CSR", new String[]{"UTF-8", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("D", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("DK", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("E", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("EL", new String[]{"UTF-8", "ISO-8859-7", "Windows-1253"});
        m_LangCodeToEncodings.put("ESA", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("F", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("FRC", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("HR", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("HU", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("I", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("IN", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("IS", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("IW", new String[]{"UTF-8", "Windows-1255", "ISO-8859-8", "ISO-8859-8-I"});
        m_LangCodeToEncodings.put("JA", new String[]{"UTF-8", "Windows-31J", "ISO-2022-JP", "Shift_JIS", "EUC-JP"});
        m_LangCodeToEncodings.put("KO", new String[]{"UTF-8", "EUC-KR", "ISO-2022-KR"});
        m_LangCodeToEncodings.put("LSR", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("LT", new String[]{"UTF-8", "Windows-1257", "ISO-8859-4", "ISO-8859-13"});
        m_LangCodeToEncodings.put("N", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("NL", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("PL", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("PT", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("PTB", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("RO", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("RU", new String[]{"UTF-8", "KOI8-R", "Windows-1251", "ISO-8859-5", "CP866"});
        m_LangCodeToEncodings.put("S", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("SF", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("SK", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("SL", new String[]{"UTF-8", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("SQ", new String[]{"UTF-8", "Windows-1250", "Windows-1252", "ISO-8859-15", "ISO-8859-2", "ISO-8859-1"});
        m_LangCodeToEncodings.put("TH", new String[]{"UTF-8", "TIS-620", "Windows-874"});
        m_LangCodeToEncodings.put("TR", new String[]{"UTF-8", "ISO-8859-9", "Windows-1254"});
        m_LangCodeToEncodings.put("UK", new String[]{"UTF-8", "KOI8-U", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("US", new String[]{"UTF-8", "US-ASCII", "Big5", "CP866", "EUC-JP", "EUC-KR", "GB2312", "GB18030", "GBK", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-8-I", "ISO-8859-9", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "KOI8-R", "KOI8-U", "Shift_JIS", "TIS-620", "Windows-31J", "Windows-874", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258"});
        m_LangCodeToEncodings.put("VN", new String[]{"UTF-8", "Windows-1258"});
        m_LangCodeToEncodings.put("ZHS", new String[]{"UTF-8", "GB18030", "GBK", "GB2312"});
        m_LangCodeToEncodings.put("ZHT", new String[]{"UTF-8", "Big5"});
        m_LangCodeToEncodings.put("AM", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("HY", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("AS", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("AZ", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("BN", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("BE", new String[]{"UTF-8", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("CUZ", new String[]{"UTF-8", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("PRS", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("DV", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("EG", new String[]{"UTF-8", "Windows-1256", "ISO-8859-6"});
        m_LangCodeToEncodings.put("GB", new String[]{"UTF-8", "US-ASCII", "Big5", "CP866", "EUC-JP", "EUC-KR", "GB2312", "GB18030", "GBK", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-8-I", "ISO-8859-9", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "KOI8-R", "KOI8-U", "Shift_JIS", "TIS-620", "Windows-31J", "Windows-874", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258"});
        m_LangCodeToEncodings.put("ET", new String[]{"UTF-8", "Windows-1257", "ISO-8859-4", "ISO-8859-13"});
        m_LangCodeToEncodings.put("DIN", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1", "Windows-1250", "ISO-8859-2"});
        m_LangCodeToEncodings.put("GU", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("HI", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("GA", new String[]{"UTF-8", "Windows-1252", "ISO-8859-14"});
        m_LangCodeToEncodings.put("KN", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("KM", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("LO", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("LBS", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("LUZ", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("LV", new String[]{"UTF-8", "Windows-1257", "ISO-8859-4", "ISO-8859-13"});
        m_LangCodeToEncodings.put("MK", new String[]{"UTF-8", "Windows-1251", "ISO-8859-5"});
        m_LangCodeToEncodings.put("MS", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("ML", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("MT", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("MR", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("ESM", new String[]{"UTF-8", "Windows-1252", "ISO-8859-15", "ISO-8859-1"});
        m_LangCodeToEncodings.put("NE", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("OR", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("FA", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("PA", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("SI", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("SW", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("TA", new String[]{"UTF-8"});
        m_LangCodeToEncodings.put("TE", new String[]{"UTF-8"});
        m_CharsetToCharsets.put("ZHT16BIG5", new String[]{"UTF-8", "Big5"});
        m_CharsetToCharsets.put("ZHT16MSWIN950", new String[]{"UTF-8", "Big5"});
        m_CharsetToCharsets.put("JA16EUC", new String[]{"UTF-8", "EUC-JP", "Windows-31J", "ISO-2022-JP", "Shift_JIS"});
        m_CharsetToCharsets.put("JA16SJIS", new String[]{"UTF-8", "Windows-31J", "Shift_JIS", "ISO-2022-JP", "EUC-JP"});
        m_CharsetToCharsets.put("KO16KSC5601", new String[]{"UTF-8", "EUC-KR", "ISO-2022-KR"});
        m_CharsetToCharsets.put("KO16MSWIN949", new String[]{"UTF-8", "EUC-KR", "ISO-2022-KR"});
        m_CharsetToCharsets.put("ZHS16CGB231280", new String[]{"UTF-8", "GB18030", "GB2312", "GBK"});
        m_CharsetToCharsets.put("ZHS16GBK", new String[]{"UTF-8", "GB18030", "GBK"});
        m_CharsetToCharsets.put("WE8ISO8859P1", new String[]{"UTF-8", "ISO-8859-1", "Windows-1252"});
        m_CharsetToCharsets.put("WE8ISO8859P15", new String[]{"UTF-8", "ISO-8859-15", "Windows-1252"});
        m_CharsetToCharsets.put("WE8MSWIN1252", new String[]{"UTF-8", "Windows-1252"});
        m_CharsetToCharsets.put("EE8ISO8859P2", new String[]{"UTF-8", "ISO-8859-2", "Windows-1250"});
        m_CharsetToCharsets.put("EE8MSWIN1250", new String[]{"UTF-8", "Windows-1250"});
        m_CharsetToCharsets.put("WE8ISO8859P9", new String[]{"UTF-8", "ISO-8859-9", "Windows-1254"});
        m_CharsetToCharsets.put("TR8MSWIN1254", new String[]{"UTF-8", "Windows-1254"});
        m_CharsetToCharsets.put("NEE8ISO8859P4", new String[]{"UTF-8", "ISO-8859-4"});
        m_CharsetToCharsets.put("BLT8MSWIN1257", new String[]{"UTF-8", "Windows-1257"});
        m_CharsetToCharsets.put("CL8ISO8859P5", new String[]{"UTF-8", "ISO-8859-5", "Windows-1251"});
        m_CharsetToCharsets.put("CL8MSWIN1251", new String[]{"UTF-8", "Windows-1251"});
        m_CharsetToCharsets.put("AR8ISO8859P6", new String[]{"UTF-8", "ISO-8859-6", "Windows-1256"});
        m_CharsetToCharsets.put("AR8MSWIN1256", new String[]{"UTF-8", "Windows-1256"});
        m_CharsetToCharsets.put("EL8ISO8859P7", new String[]{"UTF-8", "ISO-8859-7", "Windows-1253"});
        m_CharsetToCharsets.put("EL8MSWIN1253", new String[]{"UTF-8", "Windows-1253"});
        m_CharsetToCharsets.put("IW8MSWIN1255", new String[]{"UTF-8", "Windows-1255", "ISO-8859-8", "ISO-8859-8-I"});
        m_CharsetToCharsets.put("VN8MSWIN1258", new String[]{"UTF-8", "Windows-1258"});
        m_CharsetToCharsets.put("TH8TISASCII", new String[]{"UTF-8", "TIS-620", "Windows-874"});
        m_CharsetToCharsets.put("US7ASCII", new String[]{"UTF-8", "US-ASCII", "Big5", "CP866", "EUC-JP", "EUC-KR", "GB2312", "GB18030", "GBK", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-8-I", "ISO-8859-9", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "KOI8-R", "KOI8-U", "Shift_JIS", "TIS-620", "Windows-31J", "Windows-874", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258"});
        m_CharsetToCharsets.put("BLT8ISO8859P13", new String[]{"UTF-8", "ISO-8859-13", "Windows-1257"});
        m_CharsetToCharsets.put("JA16EUCTILDE", new String[]{"UTF-8", "EUC-JP", "Windows-31J", "ISO-2022-JP", "Shift_JIS"});
        m_CharsetToCharsets.put("JA16SJISTILDE", new String[]{"UTF-8", "Windows-31J", "Shift_JIS", "ISO-2022-JP", "EUC-JP"});
        m_CharsetToCharsets.put("JA16VMS", new String[]{"UTF-8", "Windows-31J", "EUC-JP", "ISO-2022-JP", "Shift_JIS"});
        m_CharsetToCharsets.put("RU8PC855", new String[]{"UTF-8", "Windows-1251"});
        m_CharsetToCharsets.put("RU8PC866", new String[]{"UTF-8", "CP866", "KOI8-R"});
        m_CharsetToCharsets.put("CL8KOI8R", new String[]{"UTF-8", "KOI8-R"});
        m_CharsetToCharsets.put("SE8ISO8859P3", new String[]{"UTF-8", "ISO-8859-3"});
        m_CharsetToCharsets.put("CEL8ISO8859P14", new String[]{"UTF-8", "ISO-8859-13"});
    }
}

