/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.dev;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CLDRReader {
    private String longDateFormat = "";
    private String mediumDateFormat = "";
    private String shortDateFormat = "";
    private String timeFormat = "";
    private String startDow = "0";
    private String[] amPmMarkers = new String[2];
    private String[] months = new String[12];
    private String[] monthAbbreviations = new String[12];
    private String[] weeks = new String[7];
    private String[] weekAbbreviations = new String[7];
    private String[] eras = new String[2];
    private static final String workDir = "oracle/apps/fnd/i18n/dev/";
    private static final String charset = "UTF-8";
    private static HashMap DOWMap = new HashMap();

    public String getLongDateFormat() {
        return this.longDateFormat;
    }

    public String getMediumDateFormat() {
        return this.mediumDateFormat;
    }

    public String getShortDateFormat() {
        return this.shortDateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getStartDow() {
        return this.startDow;
    }

    public String[] getAmPmStrings() {
        return this.amPmMarkers;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.monthAbbreviations;
    }

    public String[] getWeekdays() {
        return this.weeks;
    }

    public String[] getShortWeekdays() {
        return this.weekAbbreviations;
    }

    public String[] getEras() {
        return this.eras;
    }

    public CLDRReader(Locale locale) throws Exception {
        this.init(locale, false);
    }

    public CLDRReader(Locale locale, boolean bl) throws Exception {
        this.init(locale, bl);
    }

    private void init(Locale locale, boolean bl) throws Exception {
        String string = locale.toString() + ".xml";
        File file = new File("oracle/apps/fnd/i18n/dev//CLDR_26/common/main/" + string);
        if (!file.exists()) {
            System.out.println("No data file found for " + locale.toString() + ".");
            System.out.println();
            throw new Exception("No data file found for " + locale.toString());
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringWriter stringWriter = new StringWriter();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("<!DOCTYPE") != -1) continue;
                stringWriter.write(string2 + System.getProperty("line.separator"));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringWriter.toString().getBytes(charset));
            Document document = documentBuilder.parse(byteArrayInputStream);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("calendar");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Node node = namedNodeMap.getNamedItem("type");
                String string3 = node.getNodeValue();
                if (!string3.equals("gregorian")) continue;
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Object object;
                    String string4;
                    Node node2;
                    NamedNodeMap namedNodeMap2;
                    String string5;
                    int n;
                    Object object2;
                    Object object3;
                    String string6;
                    int n2;
                    Object object4;
                    String string7;
                    Object object5;
                    String string8;
                    int n3;
                    NodeList nodeList3;
                    String string9 = nodeList2.item(j).getNodeName();
                    if (string9.equals("dateFormats")) {
                        nodeList3 = nodeList2.item(j).getChildNodes();
                        for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                            string8 = nodeList3.item(n3).getNodeName();
                            if (!string8.equals("dateFormatLength")) continue;
                            object5 = nodeList3.item(n3).getAttributes();
                            Node node3 = object5.getNamedItem("type");
                            string7 = node3.getNodeValue();
                            object4 = nodeList3.item(n3).getChildNodes();
                            for (n2 = 0; n2 < object4.getLength(); ++n2) {
                                string6 = object4.item(n2).getNodeName();
                                if (!string6.equals("dateFormat")) continue;
                                object3 = object4.item(n2).getChildNodes();
                                for (int k = 0; k < object3.getLength(); ++k) {
                                    String string10 = object3.item(k).getNodeName();
                                    if (!string10.equals("pattern")) continue;
                                    object2 = object3.item(k).getFirstChild().getNodeValue();
                                    if (bl) {
                                        System.out.println(string7 + ":" + (String)object2);
                                    }
                                    if (string7.equals("full")) {
                                        this.longDateFormat = object2;
                                        continue;
                                    }
                                    if (string7.equals("short")) {
                                        this.shortDateFormat = object2;
                                        continue;
                                    }
                                    if (!string7.equals("medium")) continue;
                                    this.mediumDateFormat = object2;
                                }
                            }
                        }
                        continue;
                    }
                    if (string9.equals("timeFormats")) {
                        nodeList3 = nodeList2.item(j).getChildNodes();
                        for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                            string8 = nodeList3.item(n3).getNodeName();
                            if (!string8.equals("timeFormatLength")) continue;
                            object5 = nodeList3.item(n3).getAttributes();
                            Node node4 = object5.getNamedItem("type");
                            string7 = node4.getNodeValue();
                            object4 = nodeList3.item(n3).getChildNodes();
                            for (n2 = 0; n2 < object4.getLength(); ++n2) {
                                string6 = object4.item(n2).getNodeName();
                                if (!string6.equals("timeFormat")) continue;
                                object3 = object4.item(n2).getChildNodes();
                                for (int k = 0; k < object3.getLength(); ++k) {
                                    String string11 = object3.item(k).getNodeName();
                                    if (!string11.equals("pattern")) continue;
                                    object2 = object3.item(k).getFirstChild().getNodeValue();
                                    if (bl) {
                                        System.out.println(string7 + ":" + (String)object2);
                                    }
                                    if (!string7.equals("medium")) continue;
                                    this.timeFormat = object2;
                                }
                            }
                        }
                        continue;
                    }
                    if (string9.equals("months")) {
                        nodeList3 = nodeList2.item(j).getChildNodes();
                        for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                            Node node5;
                            string8 = nodeList3.item(n3).getNodeName();
                            if (!string8.equals("monthContext") || !(string7 = (node5 = (object5 = nodeList3.item(n3).getAttributes()).getNamedItem("type")).getNodeValue()).equals("format")) continue;
                            object4 = nodeList3.item(n3).getChildNodes();
                            for (n2 = 0; n2 < object4.getLength(); ++n2) {
                                Node node6;
                                String string12;
                                string6 = object4.item(n2).getNodeName();
                                if (!string6.equals("monthWidth") || !(string12 = (node6 = (object3 = object4.item(n2).getAttributes()).getNamedItem("type")).getNodeValue()).equals("abbreviated") && !string12.equals("wide")) continue;
                                object2 = object4.item(n2).getChildNodes();
                                for (n = 0; n < object2.getLength(); ++n) {
                                    string5 = object2.item(n).getNodeName();
                                    if (!string5.equals("month")) continue;
                                    namedNodeMap2 = object2.item(n).getAttributes();
                                    node2 = namedNodeMap2.getNamedItem("type");
                                    string4 = node2.getNodeValue();
                                    object = object2.item(n).getFirstChild().getNodeValue();
                                    if (bl) {
                                        System.out.println(string12 + ":" + string4 + ":" + (String)object);
                                    }
                                    int n4 = Integer.parseInt(string4);
                                    if (string12.equals("wide")) {
                                        this.months[n4 - 1] = object;
                                        continue;
                                    }
                                    this.monthAbbreviations[n4 - 1] = object;
                                }
                            }
                        }
                        continue;
                    }
                    if (string9.equals("days")) {
                        nodeList3 = nodeList2.item(j).getChildNodes();
                        for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                            Node node7;
                            string8 = nodeList3.item(n3).getNodeName();
                            if (!string8.equals("dayContext") || !(string7 = (node7 = (object5 = nodeList3.item(n3).getAttributes()).getNamedItem("type")).getNodeValue()).equals("format")) continue;
                            object4 = nodeList3.item(n3).getChildNodes();
                            for (n2 = 0; n2 < object4.getLength(); ++n2) {
                                Node node8;
                                String string13;
                                string6 = object4.item(n2).getNodeName();
                                if (!string6.equals("dayWidth") || !(string13 = (node8 = (object3 = object4.item(n2).getAttributes()).getNamedItem("type")).getNodeValue()).equals("abbreviated") && !string13.equals("wide")) continue;
                                object2 = object4.item(n2).getChildNodes();
                                for (n = 0; n < object2.getLength(); ++n) {
                                    string5 = object2.item(n).getNodeName();
                                    if (!string5.equals("day")) continue;
                                    namedNodeMap2 = object2.item(n).getAttributes();
                                    node2 = namedNodeMap2.getNamedItem("type");
                                    string4 = node2.getNodeValue();
                                    object = object2.item(n).getFirstChild().getNodeValue();
                                    if (bl) {
                                        System.out.println(string13 + ":" + string4 + ":" + (String)object);
                                    }
                                    int n5 = (Integer)DOWMap.get(string4);
                                    if (string13.equals("wide")) {
                                        this.weeks[n5] = object;
                                        continue;
                                    }
                                    this.weekAbbreviations[n5] = object;
                                }
                            }
                        }
                        continue;
                    }
                    if (string9.equals("dayPeriods")) {
                        nodeList3 = nodeList2.item(j).getChildNodes();
                        for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                            Node node9;
                            string8 = nodeList3.item(n3).getNodeName();
                            if (!string8.equals("dayPeriodContext") || !(string7 = (node9 = (object5 = nodeList3.item(n3).getAttributes()).getNamedItem("type")).getNodeValue()).equals("format")) continue;
                            object4 = nodeList3.item(n3).getChildNodes();
                            for (n2 = 0; n2 < object4.getLength(); ++n2) {
                                Node node10;
                                String string14;
                                string6 = object4.item(n2).getNodeName();
                                if (!string6.equals("dayPeriodWidth") || !(string14 = (node10 = (object3 = object4.item(n2).getAttributes()).getNamedItem("type")).getNodeValue()).equals("abbreviated") && !string14.equals("wide")) continue;
                                object2 = object4.item(n2).getChildNodes();
                                for (n = 0; n < object2.getLength(); ++n) {
                                    string5 = object2.item(n).getNodeName();
                                    if (!string5.equals("dayPeriod") || !(string4 = (node2 = (namedNodeMap2 = object2.item(n).getAttributes()).getNamedItem("type")).getNodeValue()).equals("am") && !string4.equals("pm") || (object = namedNodeMap2.getNamedItem("alt")) != null) continue;
                                    String string15 = object2.item(n).getFirstChild().getNodeValue();
                                    if (bl) {
                                        System.out.println(string14 + ":" + string4 + ":" + string15);
                                    }
                                    if (string4.equals("am")) {
                                        this.amPmMarkers[0] = string15;
                                        continue;
                                    }
                                    this.amPmMarkers[1] = string15;
                                }
                            }
                        }
                        continue;
                    }
                    if (!string9.equals("eras")) continue;
                    nodeList3 = nodeList2.item(j).getChildNodes();
                    for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                        string8 = nodeList3.item(n3).getNodeName();
                        if (!string8.equals("eraAbbr")) continue;
                        object5 = nodeList3.item(n3).getChildNodes();
                        for (int k = 0; k < object5.getLength(); ++k) {
                            string7 = object5.item(k).getNodeName();
                            if (!string7.equals("era")) continue;
                            object4 = object5.item(k).getAttributes();
                            Node node11 = object4.getNamedItem("type");
                            string6 = node11.getNodeValue();
                            object3 = object4.getNamedItem("alt");
                            if (object3 != null) continue;
                            String string16 = object5.item(k).getFirstChild().getNodeValue();
                            if (bl) {
                                System.out.println(string6 + ":" + string16);
                            }
                            int n6 = Integer.parseInt(string6);
                            this.eras[n6] = string16;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
    }

    static {
        DOWMap.put("sun", new Integer(0));
        DOWMap.put("mon", new Integer(1));
        DOWMap.put("tue", new Integer(2));
        DOWMap.put("wed", new Integer(3));
        DOWMap.put("thu", new Integer(4));
        DOWMap.put("fri", new Integer(5));
        DOWMap.put("sat", new Integer(6));
    }
}

