/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.dev;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.i18n.dev.CLDRReader;

class CapitalizeUtil {
    public static final String UPPER = "U";
    public static final String LOWER = "L";
    public static final String INITCAP = "I";
    public static final String NOCASE = "N";
    public static final String MONTH = "MonthNames";
    public static final String MON = "MonthAbbreviations";
    public static final String DAY = "DayNames";
    public static final String DY = "DayAbbreviations";
    public static final String AM = "AmPmMarkers";
    public static final String BC = "Eras";
    private static final Hashtable oraLocaleFormatMapping = new Hashtable();
    private static final Hashtable javaLocaleFormatMapping;

    CapitalizeUtil() {
    }

    public static void main(String[] stringArray) {
        Locale[] localeArray = new Locale[]{new Locale("am"), new Locale("as"), new Locale("az"), new Locale("be"), new Locale("bn"), new Locale("bs"), new Locale("en", "GB"), new Locale("es", "MX"), new Locale("et"), new Locale("fa"), new Locale("ga"), new Locale("gu"), new Locale("hi"), new Locale("hy"), new Locale("is"), new Locale("km"), new Locale("kn"), new Locale("lo"), new Locale("lv"), new Locale("mk"), new Locale("ml"), new Locale("mr"), new Locale("ms"), new Locale("mt"), new Locale("ne"), new Locale("or"), new Locale("pa"), new Locale("si"), new Locale("sw"), new Locale("ta"), new Locale("te"), new Locale("uz")};
        localeArray = new Locale[]{new Locale("ms")};
        for (int i = 0; i < localeArray.length; ++i) {
            CapitalizeUtil.print(localeArray[i]);
        }
    }

    private static void print(Locale locale) {
        System.out.println(locale.toString());
        System.out.println("MONTH: " + CapitalizeUtil.getCapInfo(MONTH, locale));
        System.out.println("MON: " + CapitalizeUtil.getCapInfo(MON, locale));
        System.out.println("DAY: " + CapitalizeUtil.getCapInfo(DAY, locale));
        System.out.println("DY: " + CapitalizeUtil.getCapInfo(DY, locale));
        System.out.println("AM: " + CapitalizeUtil.getCapInfo(AM, locale));
        System.out.println("BC: " + CapitalizeUtil.getCapInfo(BC, locale));
    }

    public static String getCapInfo(String string, Locale locale) {
        if (locale.getLanguage().equals("sr") || locale.getLanguage().equals("sh")) {
            locale = new Locale("sr");
        }
        if (locale.getLanguage().equals("en") && locale.getCountry().equals("GB")) {
            locale = new Locale("en");
        }
        String string2 = NOCASE;
        CLDRReader cLDRReader = null;
        try {
            cLDRReader = new CLDRReader(locale);
        }
        catch (Exception exception) {
            System.out.println("Try to get data from " + locale.getLanguage());
            try {
                cLDRReader = new CLDRReader(new Locale(locale.getLanguage()));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (cLDRReader != null) {
            Object object = null;
            object = string == MONTH ? cLDRReader.getMonths() : (string == MON ? cLDRReader.getShortMonths() : (string == DAY ? cLDRReader.getWeekdays() : (string == DY ? cLDRReader.getShortWeekdays() : (string == AM ? cLDRReader.getAmPmStrings() : (string == BC ? cLDRReader.getEras() : null)))));
            if (object != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    String string3 = object[i];
                    if (string3 == null) continue;
                    string2 = string3.equals(string3.toLowerCase(locale)) && string3.equals(string3.toUpperCase(locale)) ? NOCASE : (string3.equals(string3.toLowerCase(locale)) ? LOWER : (string3.equals(string3.toUpperCase(locale)) ? UPPER : INITCAP));
                }
            }
        }
        System.out.println(string + ":" + string2);
        return string2;
    }

    private static String getJavaCapInfo(String string, Locale locale) {
        String string2 = LOWER;
        String string3 = (String)javaLocaleFormatMapping.get(string);
        if (string3 == null) {
            string2 = LOWER;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, locale);
            String string4 = simpleDateFormat.format(new Date());
            if (string4.equals(string4.toUpperCase())) {
                string2 = UPPER;
                if (string4.equals(string4.toLowerCase()) && !string.equals(AM)) {
                    string2 = INITCAP;
                }
            } else {
                string2 = string4.equals(string4.toLowerCase()) ? LOWER : INITCAP;
            }
        }
        return string2;
    }

    public static String[] capitalize(String[] stringArray, String string, Locale locale) {
        if (stringArray == null) {
            return stringArray;
        }
        String[] stringArray2 = stringArray;
        String[] stringArray3 = new String[stringArray2.length];
        String string2 = CapitalizeUtil.getCapInfo(string, locale);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray3[i] = string2.equals(LOWER) ? stringArray2[i].toLowerCase() : (string2.equals(UPPER) ? stringArray2[i].toUpperCase() : stringArray2[i]);
        }
        return stringArray3;
    }

    static {
        oraLocaleFormatMapping.put(MONTH, "Month");
        oraLocaleFormatMapping.put(MON, "Mon");
        oraLocaleFormatMapping.put(DAY, "fmDay");
        oraLocaleFormatMapping.put(DY, "fmDay");
        oraLocaleFormatMapping.put(AM, "Am");
        oraLocaleFormatMapping.put(BC, "Bc");
        javaLocaleFormatMapping = new Hashtable();
        javaLocaleFormatMapping.put(MONTH, "MMMMM");
        javaLocaleFormatMapping.put(MON, "MMM");
        javaLocaleFormatMapping.put(DAY, "EEEEE");
        javaLocaleFormatMapping.put(DY, "EEE");
        javaLocaleFormatMapping.put(AM, "aaa");
        javaLocaleFormatMapping.put(BC, "G");
    }
}

