/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Locale;
import oracle.apps.fnd.i18n.dev.CLDRReader;

class makeLocaleInfoFromCLDR {
    static int AM_PM_AFTER = 0;
    static int AM_PM_BEFORE = 1;
    static int AM_PM_YES = 0;
    static int AM_PM_NO = 1;
    static int TIME_0_11 = 0;
    static int TIME_1_12 = 1;
    static int TIME_0_23 = 0;
    static int TIME_1_24 = 1;
    static int TIME_TWO_DIGIT = 0;
    static int TIME_ONE_DIGIT = 1;
    private static final String workDir = "oracle/apps/fnd/i18n/dev/";
    private static final String charset = "UTF-8";
    private static HashMap DOWMap = new HashMap();

    makeLocaleInfoFromCLDR() {
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("line.separator");
        Locale[] localeArray = new Locale[]{new Locale("am"), new Locale("ar"), new Locale("ar", "EG"), new Locale("as"), new Locale("az"), new Locale("be"), new Locale("bn"), new Locale("bs"), new Locale("en"), new Locale("en", "GB"), new Locale("es"), new Locale("es", "MX"), new Locale("et"), new Locale("fa"), new Locale("ga"), new Locale("gu"), new Locale("hi"), new Locale("hy"), new Locale("is"), new Locale("km"), new Locale("kn"), new Locale("lo"), new Locale("lv"), new Locale("mk"), new Locale("ml"), new Locale("mr"), new Locale("ms"), new Locale("mt"), new Locale("ne"), new Locale("or"), new Locale("pa"), new Locale("si"), new Locale("sw"), new Locale("ta"), new Locale("te"), new Locale("uz")};
        try {
            File file = new File("oracle/apps/fnd/i18n/dev//LocaleInfo.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + string);
            outputStreamWriter.write("<Locales>" + string);
            for (int i = 0; i < localeArray.length; ++i) {
                String string2 = localeArray[i].getLanguage();
                String string3 = localeArray[i].getCountry();
                CLDRReader cLDRReader = new CLDRReader(localeArray[i]);
                String string4 = cLDRReader.getLongDateFormat();
                String string5 = cLDRReader.getMediumDateFormat();
                String string6 = cLDRReader.getShortDateFormat();
                String string7 = cLDRReader.getTimeFormat();
                String string8 = cLDRReader.getStartDow();
                String[] stringArray2 = cLDRReader.getAmPmStrings();
                outputStreamWriter.write("<Locale Language=\"" + string2 + "\" Territory=\"" + string3 + "\">" + string);
                outputStreamWriter.write("<Language ID=\"" + string2 + "\" Local_Name=\"" + localeArray[i].getDisplayName() + "\"/>" + string);
                outputStreamWriter.write("<Territory ID=\"" + string3 + "\" Local_Name=\"" + localeArray[i].getDisplayCountry() + "\"/>" + string);
                outputStreamWriter.write("<Date Long_Format_Mask=\"" + string4 + "\" Medium_Format_Mask=\"" + string5 + "\" Short_Format_Mask=\"" + string6 + "\" Dow_Month_Day_Format_Mask=\"" + string4 + "\" Month_Year_Format_Mask=\"" + string4 + "\"/>" + string);
                outputStreamWriter.write("<Calendar Start_Dow=\"" + string8 + "\"/>" + string);
                String string9 = makeLocaleInfoFromCLDR.getAmPmPosition(string7);
                String string10 = makeLocaleInfoFromCLDR.getAmPmDefault(string7);
                String string11 = makeLocaleInfoFromCLDR.getAmPmSeparator(string7);
                String string12 = makeLocaleInfoFromCLDR.getTimeDigit(string7);
                String string13 = makeLocaleInfoFromCLDR.getTime1_12(string7);
                String string14 = makeLocaleInfoFromCLDR.getTime1_24(string7);
                outputStreamWriter.write("<Time AM_PM=\"" + string10 + "\" AM_PM_Position=\"" + string9 + "\" AM_Symbol=\"" + stringArray2[0] + "\" PM_Symbol=\"" + stringArray2[1] + "\" Separator=\"" + string11 + "\" Digit=\"" + string12 + "\"/>" + string);
                outputStreamWriter.write("</Locale>" + string);
                outputStreamWriter.flush();
            }
            outputStreamWriter.write("</Locales>" + string);
            outputStreamWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String getAmPmDefault(String string) {
        int n = AM_PM_NO;
        if ((string = string.toUpperCase()).indexOf("A") != -1 || string.indexOf("X") != -1) {
            n = AM_PM_YES;
        }
        return Integer.toString(n);
    }

    static String getAmPmSeparator(String string) {
        String string2 = ":";
        if ((string = string.toUpperCase()).indexOf("H.M") != -1) {
            string2 = ".";
        }
        return string2;
    }

    static String getTime1_12(String string) {
        int n = TIME_1_12;
        if (string.indexOf("K") != -1) {
            n = TIME_0_11;
        }
        return Integer.toString(n);
    }

    static String getTime1_24(String string) {
        int n = TIME_0_23;
        if (string.indexOf("k") != -1) {
            n = TIME_1_24;
        }
        return Integer.toString(n);
    }

    static String getTimeDigit(String string) {
        int n = TIME_ONE_DIGIT;
        if ((string = string.toUpperCase()).indexOf("HH") != -1) {
            n = TIME_TWO_DIGIT;
        }
        return Integer.toString(n);
    }

    static String getAmPmPosition(String string) {
        int n = AM_PM_AFTER;
        if (Integer.parseInt(makeLocaleInfoFromCLDR.getAmPmDefault(string = string.toUpperCase())) == AM_PM_YES) {
            n = string.startsWith("H") ? AM_PM_AFTER : AM_PM_BEFORE;
        }
        return Integer.toString(n);
    }

    static {
        DOWMap.put("sun", new Integer(0));
        DOWMap.put("mon", new Integer(1));
        DOWMap.put("tue", new Integer(2));
        DOWMap.put("wed", new Integer(3));
        DOWMap.put("thu", new Integer(4));
        DOWMap.put("fri", new Integer(5));
        DOWMap.put("sat", new Integer(6));
    }
}

