/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class makeLocaleInfoFromJava {
    static int AM_PM_AFTER = 0;
    static int AM_PM_BEFORE = 1;
    static int AM_PM_YES = 0;
    static int AM_PM_NO = 1;
    static int TIME_0_11 = 0;
    static int TIME_1_12 = 1;
    static int TIME_0_23 = 0;
    static int TIME_1_24 = 1;
    static int TIME_TWO_DIGIT = 0;
    static int TIME_ONE_DIGIT = 1;

    makeLocaleInfoFromJava() {
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("line.separator");
        try {
            File file = new File("oracle/apps/fnd/i18n/dev/LocaleInfo.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + string);
            outputStreamWriter.write("<Locales>" + string);
            Locale[] localeArray = DateFormat.getAvailableLocales();
            for (int i = 0; i < localeArray.length; ++i) {
                String string2 = localeArray[i].getLanguage();
                String string3 = localeArray[i].getCountry();
                boolean bl = false;
                if (string3.length() > 0) {
                    bl = true;
                }
                if (!bl) continue;
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(0, localeArray[i]);
                SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateInstance(3, localeArray[i]);
                String string4 = localeArray[i].getDisplayLanguage();
                String string5 = localeArray[i].getDisplayCountry();
                String string6 = simpleDateFormat.toPattern();
                String string7 = simpleDateFormat2.toPattern();
                DateFormatSymbols dateFormatSymbols = simpleDateFormat.getDateFormatSymbols();
                String[] stringArray2 = dateFormatSymbols.getAmPmStrings();
                String[] stringArray3 = dateFormatSymbols.getMonths();
                String[] stringArray4 = dateFormatSymbols.getShortMonths();
                String[] stringArray5 = dateFormatSymbols.getWeekdays();
                String[] stringArray6 = dateFormatSymbols.getShortWeekdays();
                Calendar calendar = simpleDateFormat.getCalendar();
                String string8 = Integer.toString(calendar.getFirstDayOfWeek());
                outputStreamWriter.write("<Locale Language=\"" + string2 + "\" Territory=\"" + string3 + "\">" + string);
                outputStreamWriter.write("<Language ID=\"" + string2 + "\" Local_Name=\"" + string4 + "\"/>" + string);
                outputStreamWriter.write("<Territory ID=\"" + string3 + "\" Local_Name=\"" + string5 + "\"/>" + string);
                outputStreamWriter.write("<Date Long_Format_Mask=\"" + string6 + "\" Short_Format_Mask=\"" + string7 + "\" Dow_Month_Day_Format_Mask=\"" + string6 + "\" Month_Year_Format_Mask=\"" + string6 + "\"/>" + string);
                outputStreamWriter.write("<Calendar Start_Dow=\"" + string8 + "\"/>" + string);
                simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3, localeArray[i]);
                String string9 = makeLocaleInfoFromJava.getAmPmPosition(simpleDateFormat.toPattern());
                String string10 = makeLocaleInfoFromJava.getAmPmDefault(simpleDateFormat.toPattern());
                String string11 = makeLocaleInfoFromJava.getAmPmSeparator(simpleDateFormat.toPattern());
                String string12 = makeLocaleInfoFromJava.getTimeDigit(simpleDateFormat.toPattern());
                String string13 = makeLocaleInfoFromJava.getTime1_12(simpleDateFormat.toPattern());
                String string14 = makeLocaleInfoFromJava.getTime1_24(simpleDateFormat.toPattern());
                outputStreamWriter.write("<Time AM_PM=\"" + string10 + "\" AM_PM_Position=\"" + string9 + "\" AM_Symbol=\"" + stringArray2[0] + "\" PM_Symbol=\"" + stringArray2[1] + "\" Separator=\"" + string11 + "\" Digit=\"" + string12 + "\"/>" + string);
                outputStreamWriter.write("</Locale>" + string);
                outputStreamWriter.flush();
            }
            outputStreamWriter.write("</Locales>" + string);
            outputStreamWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    static String getAmPmDefault(String string) {
        int n = AM_PM_NO;
        if ((string = string.toUpperCase()).indexOf("A") != -1 || string.indexOf("X") != -1) {
            n = AM_PM_YES;
        }
        return Integer.toString(n);
    }

    static String getAmPmSeparator(String string) {
        String string2 = ":";
        if ((string = string.toUpperCase()).indexOf("H.M") != -1) {
            string2 = ".";
        }
        return string2;
    }

    static String getTime1_12(String string) {
        int n = TIME_1_12;
        if (string.indexOf("K") != -1) {
            n = TIME_0_11;
        }
        return Integer.toString(n);
    }

    static String getTime1_24(String string) {
        int n = TIME_0_23;
        if (string.indexOf("k") != -1) {
            n = TIME_1_24;
        }
        return Integer.toString(n);
    }

    static String getTimeDigit(String string) {
        int n = TIME_ONE_DIGIT;
        if ((string = string.toUpperCase()).indexOf("HH") != -1) {
            n = TIME_TWO_DIGIT;
        }
        return Integer.toString(n);
    }

    static String getAmPmPosition(String string) {
        int n = AM_PM_AFTER;
        if (Integer.parseInt(makeLocaleInfoFromJava.getAmPmDefault(string = string.toUpperCase())) == AM_PM_YES) {
            n = string.startsWith("H") ? AM_PM_AFTER : AM_PM_BEFORE;
        }
        return Integer.toString(n);
    }
}

