/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.CalendarFormatter;
import oracle.apps.fnd.i18n.util.SessionInfo;

public class AppsCalendarFormatter {
    public static final String RCS_ID = "$Header: AppsCalendarFormatter.java 120.1 2005/06/03 01:25:24 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsCalendarFormatter.java 120.1 2005/06/03 01:25:24 rsuzuki ship $", "oracle.apps.fnd.i18n.text");
    public static final int SHORT = 10;
    public static final int MEDIUM = 11;
    public static final int LONG = 12;
    public static final int MONTH_YEAR = 13;
    public static final int DOW_MONTH_DAY = 14;
    public static final int TIME_12 = 15;
    public static final int TIME_24 = 16;
    public static final int TIME_DEFAULT = 17;
    private static final int CACHE_SIZE = 100;
    private static Hashtable m_CachedCalendarFormatter = new Hashtable(100);
    private CalendarFormatter m_CalendarFormatter;

    public AppsCalendarFormatter(AppsContext appsContext) {
        this.m_CalendarFormatter = CalendarFormatter.getInstance(SessionInfo.getUserLocale(appsContext));
    }

    public String format(Date date, int n) {
        return this.m_CalendarFormatter.format(date, n);
    }

    public String format(Timestamp timestamp, int n) {
        return this.m_CalendarFormatter.format(timestamp, n);
    }

    public static String format(AppsContext appsContext, Date date, int n) {
        return AppsCalendarFormatter.format(appsContext, new Timestamp(date.getTime()), n);
    }

    public static String format(AppsContext appsContext, Timestamp timestamp, int n) {
        CalendarFormatter calendarFormatter = AppsCalendarFormatter.getCalendarFormatter(SessionInfo.getUserLocale(appsContext));
        return calendarFormatter.format(timestamp, n);
    }

    private static CalendarFormatter getCalendarFormatter(Locale locale) {
        TimeZone timeZone = TimeZone.getDefault();
        CalendarFormatter calendarFormatter = (CalendarFormatter)m_CachedCalendarFormatter.get(locale.toString() + timeZone.getID());
        if (calendarFormatter == null) {
            calendarFormatter = CalendarFormatter.getInstance(timeZone, locale);
            m_CachedCalendarFormatter.put(locale.toString() + timeZone.getID(), calendarFormatter);
        }
        return calendarFormatter;
    }
}

