/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.NumberFormatter;
import oracle.apps.fnd.i18n.util.SessionInfo;

public class AppsCurrencyFormatter {
    public static final String RCS_ID = "$Header: AppsCurrencyFormatter.java 120.2 2008/01/23 22:56:29 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsCurrencyFormatter.java 120.2 2008/01/23 22:56:29 rsuzuki ship $", "oracle.apps.fnd.i18n.text");
    private static Hashtable m_CachedCurrencyInfo = new Hashtable();
    private static final int CACHE_SIZE = 100;
    private static Hashtable m_CachedNumberFormatter = new Hashtable(100);

    public static String format(AppsContext appsContext, double d, String string) {
        return AppsCurrencyFormatter.format(appsContext, new Double(d), 0, string);
    }

    public static String format(AppsContext appsContext, double d, int n, String string) {
        return AppsCurrencyFormatter.format(appsContext, new Double(d), n, string);
    }

    public static String format(AppsContext appsContext, BigDecimal bigDecimal, String string) {
        return AppsCurrencyFormatter.format(appsContext, bigDecimal, 0, string);
    }

    public static String format(AppsContext appsContext, BigDecimal bigDecimal, int n, String string) {
        return AppsCurrencyFormatter.format(appsContext, bigDecimal, n, string);
    }

    public static String format(AppsContext appsContext, Number number, String string) {
        return AppsCurrencyFormatter.format(appsContext, number, 0, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(AppsContext appsContext, Number number, int n, String string) {
        Hashtable hashtable = AppsCurrencyFormatter.getCurrencyInfo(appsContext, string);
        String string2 = (String)hashtable.get("formatMask");
        String string3 = SessionInfo.getNumericCharacters(appsContext);
        char[] cArray = new char[]{string3.charAt(0), string3.charAt(1)};
        NumberFormatter numberFormatter = AppsCurrencyFormatter.getNumberFormatter(SessionInfo.getUserLocale(appsContext));
        if (n != 0) {
            NumberFormatter numberFormatter2 = numberFormatter;
            synchronized (numberFormatter2) {
                numberFormatter.setScale(n);
                return numberFormatter.format(number, 10, string2, cArray);
            }
        }
        return numberFormatter.format(number, 10, string2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getCurrencyInfo(AppsContext appsContext, String string) {
        Hashtable<String, String> hashtable = (Hashtable<String, String>)m_CachedCurrencyInfo.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            Connection connection = appsContext.getJDBCConnection();
            if (connection == null) {
                return hashtable;
            }
            CallableStatement callableStatement = null;
            try {
                callableStatement = connection.prepareCall(" begin  :1 := FND_CURRENCY.GET_FORMAT_MASK(:2, 64);  FND_CURRENCY.GET_INFO(:3, :4, :5, :6);  end; ");
                callableStatement.registerOutParameter(1, 12);
                callableStatement.setString(2, string);
                callableStatement.setString(3, string);
                callableStatement.registerOutParameter(4, 2);
                callableStatement.registerOutParameter(5, 2);
                callableStatement.registerOutParameter(6, 2);
                callableStatement.execute();
                hashtable.put("formatMask", callableStatement.getString(1));
                hashtable.put("precision", Integer.toString(callableStatement.getInt(4)));
                hashtable.put("exPrecision", Integer.toString(callableStatement.getInt(5)));
                hashtable.put("minorUnit", Double.toString(callableStatement.getDouble(6)));
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    callableStatement.close();
                    appsContext.releaseJDBCConnection();
                }
                catch (Exception exception) {}
            }
            m_CachedCurrencyInfo.put(string, hashtable);
        }
        return hashtable;
    }

    private static NumberFormatter getNumberFormatter(Locale locale) {
        NumberFormatter numberFormatter = (NumberFormatter)m_CachedNumberFormatter.get(locale);
        if (numberFormatter == null) {
            numberFormatter = NumberFormatter.getInstance(locale);
            m_CachedNumberFormatter.put(locale, numberFormatter);
        }
        return numberFormatter;
    }
}

