/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DateFormatSymbols;
import oracle.apps.fnd.i18n.common.text.DateFormatter;
import oracle.apps.fnd.i18n.common.text.SimpleDateFormat;
import oracle.apps.fnd.i18n.common.util.Calendar;
import oracle.apps.fnd.i18n.common.util.GregorianCalendar;
import oracle.apps.fnd.i18n.util.NLSMapper;
import oracle.apps.fnd.i18n.util.SessionInfo;

public class AppsDateFormatter {
    public static final String RCS_ID = "$Header: AppsDateFormatter.java 120.6 2012/09/10 23:16:15 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsDateFormatter.java 120.6 2012/09/10 23:16:15 rsuzuki ship $", "oracle.apps.fnd.i18n.text");
    public static final int FORMAT_ORACLE = 10;
    public static final int FORMAT_JAVA = 11;
    private static final int FORMAT_DEFAULT = 11;
    public static final int RESOURCE_JAVA = 7;
    public static final int RESOURCE_ORACLE = 9;
    public static final int RESOURCE_ORACLE_V8 = 8;
    public static final int RESOURCE_ORACLE_V9 = 9;
    private static final int RESOURCE_DEFAULT = 9;
    public static final int CALENDAR_GREGORIAN = 0;
    public static final int CALENDAR_JAPANESE_IMPERIAL = 1;
    public static final int CALENDAR_THAI_BUDDHA = 2;
    public static final int CALENDAR_ENGLISH_HIJRAH = 3;
    public static final int CALENDAR_ARABIC_HIJRAH = 4;
    public static final int CALENDAR_ROC_OFFICIAL = 5;
    private static final Locale LOCALE_CANONICAL = Locale.US;
    private static final Locale LOCALE_NUMERIC = new Locale("en", "NUMERIC");
    private static final String JAVA_DATE_FORMAT_CANONICAL = "yyyy/MM/dd HH:mm:ss";
    private static final String ISO8601_DATETIME_FORMAT_MASK_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String ISO8601_DATETIME_FORMAT_MASK_LOCALTIME = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final int ELEM_YEAR = 0;
    private static final int ELEM_MONTH = 1;
    private static final int ELEM_DAY = 2;
    private static final int ELEM_HOUR = 3;
    private static final int ELEM_MIN = 4;
    private static final int ELEM_SEC = 5;
    private static final int ELEM_MILLISEC = 6;
    private static final int ELEM_OFFSET_HOUR = 7;
    private static final int ELEM_OFFSET_MIN = 8;
    private static final int ELEM_OFFSET = 9;
    private static final int OFFSET_NOT_SET = 0;
    private static final int OFFSET_POSITIVE = 1;
    private static final int OFFSET_NEGATIVE = -1;
    private static final int PART_DATE = 0;
    private static final int PART_TIME = 1;
    private static final int PART_OFFSET = 2;
    private SimpleDateFormat m_DateFormatter;
    private int m_FormatMaskType;
    private String m_FormatMask;
    private Locale m_Locale;
    private static final int CACHE_SIZE = 100;
    private static Hashtable m_CachedDateFormatter = new Hashtable();
    private static Date twoDigitYearStart;

    public AppsDateFormatter(AppsContext appsContext) {
        this.initialize(10, SessionInfo.getDateFormatMask(appsContext), 9, SessionInfo.getDateLocale(appsContext));
    }

    public AppsDateFormatter(int n, String string, int n2, Locale locale) {
        this.initialize(n, string, n2, locale);
    }

    public AppsDateFormatter(int n, String string, int n2, String string2, String string3) {
        this.initialize(n, string, n2, AppsDateFormatter.convertToLocale(string2, string3));
    }

    public String format(Date date) {
        return this.m_DateFormatter.format(date);
    }

    public String format(Timestamp timestamp) {
        return this.m_DateFormatter.format(timestamp);
    }

    public static String format(AppsContext appsContext, Date date) {
        return AppsDateFormatter.format(date, 10, SessionInfo.getDateFormatMask(appsContext), 9, SessionInfo.getDateLocale(appsContext));
    }

    public static String format(AppsContext appsContext, Timestamp timestamp) {
        return AppsDateFormatter.format(timestamp, 10, SessionInfo.getDateFormatMask(appsContext), 9, SessionInfo.getDateLocale(appsContext));
    }

    public static String format(Date date, String string, String string2, String string3) {
        return AppsDateFormatter.format(date, 11, string, 9, AppsDateFormatter.convertToLocale(string2, string3));
    }

    public static String format(Timestamp timestamp, String string, String string2, String string3) {
        return AppsDateFormatter.format(timestamp, 11, string, 9, AppsDateFormatter.convertToLocale(string2, string3));
    }

    public static String format(Date date, String string, Locale locale) {
        return AppsDateFormatter.format(date, 11, string, 9, locale);
    }

    public static String format(Timestamp timestamp, String string, Locale locale) {
        return AppsDateFormatter.format(timestamp, 11, string, 9, locale);
    }

    public static String format(Date date, int n, String string, int n2, String string2, String string3) {
        return AppsDateFormatter.format(date, n, string, n2, AppsDateFormatter.convertToLocale(string2, string3));
    }

    public static String format(Timestamp timestamp, int n, String string, int n2, String string2, String string3) {
        return AppsDateFormatter.format(timestamp, n, string, n2, AppsDateFormatter.convertToLocale(string2, string3));
    }

    public static String format(Date date, int n, String string, int n2, Locale locale) {
        DateFormatter dateFormatter = AppsDateFormatter.getDateFormatter(locale);
        return dateFormatter.format(date, n, string, n2);
    }

    public static String format(Timestamp timestamp, int n, String string, int n2, Locale locale) {
        DateFormatter dateFormatter = AppsDateFormatter.getDateFormatter(locale);
        return dateFormatter.format(timestamp, n, string, n2);
    }

    public static String formatCanonical(Date date) {
        return AppsDateFormatter.formatCanonical(new Timestamp(date.getTime()));
    }

    public static String formatCanonical(Timestamp timestamp) {
        return AppsDateFormatter.format(timestamp, 11, JAVA_DATE_FORMAT_CANONICAL, 9, LOCALE_CANONICAL);
    }

    public static String formatISO8601(Date date) {
        return AppsDateFormatter.formatISO8601(new Timestamp(date.getTime()));
    }

    public static String formatISO8601(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(11, ISO8601_DATETIME_FORMAT_MASK_UTC, Locale.US);
        simpleDateFormat.setTimeZone(UTC_TIMEZONE);
        return simpleDateFormat.format(timestamp);
    }

    public static String formatISO8601LocalTime(Date date) {
        return AppsDateFormatter.formatISO8601LocalTime(new Timestamp(date.getTime()));
    }

    public static String formatISO8601LocalTime(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(11, ISO8601_DATETIME_FORMAT_MASK_LOCALTIME, Locale.US);
        return simpleDateFormat.format(timestamp);
    }

    public static String getDateFormatMaskExample(AppsContext appsContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 11, 31);
        Date date = gregorianCalendar.getTime();
        Locale locale = SessionInfo.getDateLocale(appsContext);
        return AppsDateFormatter.format(date, 10, SessionInfo.getDateFormatMask(appsContext), 9, locale);
    }

    public Date parse(String string) {
        Date date;
        block2: {
            date = null;
            try {
                date = this.m_DateFormatter.parse(string);
            }
            catch (ParseException parseException) {
                if (this.m_DateFormatter.getCalendar().getType() != 0 || (date = AppsDateFormatter.parse(string, this.m_FormatMaskType, this.m_FormatMask, 9, this.m_Locale)) != null || (date = AppsDateFormatter.parse(string, this.m_FormatMaskType, this.m_FormatMask, 8, this.m_Locale)) != null || (date = AppsDateFormatter.parse(string, this.m_FormatMaskType, this.m_FormatMask, 7, this.m_Locale)) != null) break block2;
                date = AppsDateFormatter.parse(string, this.m_FormatMaskType, this.m_FormatMask, 9, LOCALE_NUMERIC);
            }
        }
        return date;
    }

    public static Date parseCanonical(String string) {
        Date date = AppsDateFormatter.parse(string, 11, JAVA_DATE_FORMAT_CANONICAL, 9, LOCALE_CANONICAL);
        if (date == null) {
            date = AppsDateFormatter.parse(string + " 00:00:00", 11, JAVA_DATE_FORMAT_CANONICAL, 9, LOCALE_CANONICAL);
        }
        return date;
    }

    public static Date parseISO8601(String string) throws ParseException {
        int[] nArray = new int[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0};
        int n = 0;
        int n2 = 0;
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1) + "-00:00";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
            }
            if (n2 == 0) {
                if (c == '-' || c == '+' || c == 'T' || Character.isDigit(c) && i == cArray.length - 1) {
                    nArray[n] = Integer.parseInt(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    if (n == 2 && i != cArray.length - 1 && (c == '-' || c == '+')) {
                        n2 = 2;
                        n = 7;
                        if (c == '-') {
                            nArray[9] = -1;
                            continue;
                        }
                        nArray[9] = 1;
                        continue;
                    }
                    if (c == 'T') {
                        n2 = 1;
                    }
                    ++n;
                    continue;
                }
                if (Character.isDigit(c)) continue;
                throw new ParseException("Unexpected character '" + c + "' found at " + i, i);
            }
            if (n2 == 1) {
                if (c == ':' || c == '.' || c == '-' || c == '+' || Character.isDigit(c) && i == cArray.length - 1) {
                    nArray[n] = Integer.parseInt(stringBuffer.toString());
                    if (c == '-' || c == '+') {
                        stringBuffer = new StringBuffer();
                        n2 = 2;
                        n = 7;
                        if (c == '-') {
                            nArray[9] = -1;
                            continue;
                        }
                        nArray[9] = 1;
                        continue;
                    }
                    stringBuffer = new StringBuffer();
                    ++n;
                    continue;
                }
                if (Character.isDigit(c)) continue;
                throw new ParseException("Unexpected character '" + c + "' found at " + i, i);
            }
            if (n2 != 2) continue;
            if (c == ':' || Character.isDigit(c) && i == cArray.length - 1) {
                nArray[n] = Integer.parseInt(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                ++n;
                continue;
            }
            if (Character.isDigit(c)) continue;
            throw new ParseException("Unexpected character '" + c + "' found at " + i, i);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
        gregorianCalendar.set(14, nArray[6]);
        if (nArray[9] != 0) {
            gregorianCalendar.setTimeZone(UTC_TIMEZONE);
            gregorianCalendar.add(10, nArray[9] == 1 ? 0 - nArray[7] : nArray[7]);
            gregorianCalendar.add(12, nArray[9] == 1 ? 0 - nArray[8] : nArray[8]);
        }
        return gregorianCalendar.getTime();
    }

    public static Date parse(String string, String string2, String string3, String string4) {
        return AppsDateFormatter.parse(string, string2, AppsDateFormatter.convertToLocale(string3, string4));
    }

    public static Date parse(String string, String string2, Locale locale) {
        Date date = AppsDateFormatter.parse(string, 11, string2, 9, locale);
        if (date == null && (date = AppsDateFormatter.parse(string, 11, string2, 9, locale)) == null && (date = AppsDateFormatter.parse(string, 11, string2, 8, locale)) == null && (date = AppsDateFormatter.parse(string, 11, string2, 7, locale)) == null) {
            date = AppsDateFormatter.parse(string, 11, string2, 9, LOCALE_NUMERIC);
        }
        return date;
    }

    public static Date parse(String string, int n, String string2, int n2, String string3, String string4) {
        return AppsDateFormatter.parse(string, n, string2, n2, AppsDateFormatter.convertToLocale(string3, string4));
    }

    public static Date parse(String string, int n, String string2, int n2, Locale locale) {
        DateFormatter dateFormatter = AppsDateFormatter.getDateFormatter(locale);
        try {
            return dateFormatter.parse(string, n, string2, n2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date parse(AppsContext appsContext, String string) {
        Locale locale = SessionInfo.getDateLocale(appsContext);
        Date date = AppsDateFormatter.parse(string, 10, SessionInfo.getDateFormatMask(appsContext), 9, locale);
        if (date == null && (date = AppsDateFormatter.parse(string, 10, SessionInfo.getDateFormatMask(appsContext), 9, locale)) == null && (date = AppsDateFormatter.parse(string, 10, SessionInfo.getDateFormatMask(appsContext), 8, locale)) == null && (date = AppsDateFormatter.parse(string, 10, SessionInfo.getDateFormatMask(appsContext), 7, locale)) == null) {
            date = AppsDateFormatter.parse(string, 10, SessionInfo.getDateFormatMask(appsContext), 9, LOCALE_NUMERIC);
        }
        return date;
    }

    public void setLenient(boolean bl) {
        this.m_DateFormatter.setLenient(bl);
    }

    public boolean isLenient() {
        return this.m_DateFormatter.isLenient();
    }

    public void setCalendar(int n) {
        boolean bl = this.isLenient();
        this.m_DateFormatter.setCalendar(Calendar.getInstance(n));
        this.m_DateFormatter.setLenient(bl);
    }

    public void setCalendar(String string) {
        int n = 0;
        if ("Gregorian".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("Arabic Hijrah".equalsIgnoreCase(string)) {
            n = 4;
        } else if ("English Hijrah".equalsIgnoreCase(string)) {
            n = 3;
        } else if ("Thai Buddha".equalsIgnoreCase(string)) {
            n = 2;
        } else if ("Japanese Imperial".equalsIgnoreCase(string)) {
            n = 1;
        } else if ("ROC Official".equalsIgnoreCase(string)) {
            n = 5;
        } else if ("Persian".equalsIgnoreCase(string)) {
            n = 0;
        }
        this.setCalendar(n);
    }

    private void initialize(int n, String string, int n2, Locale locale) {
        this.m_Locale = locale;
        this.m_FormatMaskType = n;
        this.m_FormatMask = string;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale, n2);
        this.m_DateFormatter = new SimpleDateFormat(n, string, dateFormatSymbols);
        this.m_DateFormatter.setLenient(false);
        this.m_DateFormatter.set2DigitYearStart(twoDigitYearStart);
    }

    private static String convertDateToMask(String string, String string2) {
        int n = 47;
        int n2 = 47;
        boolean bl = true;
        if (AppsDateFormatter.countOccurence(string2, '/') == 2) {
            n = 47;
        } else if (AppsDateFormatter.countOccurence(string2, '-') == 2) {
            n = 45;
        } else if (AppsDateFormatter.countOccurence(string2, ' ') == 2) {
            n = 32;
        } else if (AppsDateFormatter.countOccurence(string2, '.') == 2) {
            n = 46;
        } else {
            bl = false;
        }
        if (bl) {
            n2 = n;
            if (AppsDateFormatter.countOccurence(string, '/') == 2) {
                n2 = 47;
            } else if (AppsDateFormatter.countOccurence(string, '-') == 2) {
                n2 = 45;
            } else if (AppsDateFormatter.countOccurence(string, ' ') == 2) {
                n2 = 32;
            } else if (AppsDateFormatter.countOccurence(string, '.') == 2) {
                n2 = 46;
            }
            if (n2 != n) {
                return string.replace((char)n2, (char)n);
            }
            return string;
        }
        return string;
    }

    private static int countOccurence(String string, char c) {
        int n = 0;
        if (string != null && !"".equals(string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != c) continue;
                ++n;
            }
        }
        return n;
    }

    private static String replace(String string, String string2, String string3) {
        if (string2 == null || "".equals(string2) || string == null || "".equals(string)) {
            return string;
        }
        int n = string2.length();
        int n2 = string.length();
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = string.indexOf(string2);
        int n4 = 0;
        while (n3 != -1) {
            stringBuffer.append(string.substring(n4, n3));
            stringBuffer.append(string3);
            n4 = n3 + n;
            n3 = string.indexOf(string2, n4);
        }
        stringBuffer.append(string.substring(n4, n2));
        return stringBuffer.toString();
    }

    private static DateFormatter getDateFormatter(Locale locale) {
        TimeZone timeZone = TimeZone.getDefault();
        DateFormatter dateFormatter = (DateFormatter)m_CachedDateFormatter.get(locale.toString() + timeZone.getID());
        if (dateFormatter == null) {
            dateFormatter = DateFormatter.getInstance(timeZone, locale);
            dateFormatter.setLenient(false);
            m_CachedDateFormatter.put(locale.toString() + timeZone.getID(), dateFormatter);
        }
        return dateFormatter;
    }

    private static Locale convertToLocale(String string, String string2) {
        Locale locale = null;
        try {
            if (string == null) {
                string = "AMERICAN";
            }
            if (string2 == null) {
                string2 = "AMERICA";
            }
            if ((locale = NLSMapper.getLocale(string.trim(), string2.trim())) == null) {
                locale = new Locale("en", "US");
            }
        }
        catch (Exception exception) {
            locale = new Locale("en", "US");
        }
        return locale;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1950, 0, 0);
        twoDigitYearStart = gregorianCalendar.getTime();
    }
}

