/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.text.AppsDateFormatter;
import oracle.apps.fnd.i18n.util.SessionInfo;

public class AppsDateTimeFormatter {
    public static final String RCS_ID = "$Header: AppsDateTimeFormatter.java 120.3 2010/02/25 03:52:10 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsDateTimeFormatter.java 120.3 2010/02/25 03:52:10 rsuzuki ship $", "oracle.apps.fnd.i18n.text");
    private static final int RESOURCE_DEFAULT = 9;
    private static final String ORACLE_TIME_FORMAT_DEFAULT = " HH24:MI:SS";
    private AppsDateFormatter m_DateFormatter;

    public AppsDateTimeFormatter(AppsContext appsContext) {
        Locale locale = SessionInfo.getDateLocale(appsContext);
        String string = SessionInfo.getDateFormatMask(appsContext) + ORACLE_TIME_FORMAT_DEFAULT;
        this.m_DateFormatter = new AppsDateFormatter(10, string, 9, locale);
    }

    public String format(Date date) {
        return this.m_DateFormatter.format(date);
    }

    public String format(Timestamp timestamp) {
        return this.m_DateFormatter.format(timestamp);
    }

    public static String format(AppsContext appsContext, Date date) {
        return AppsDateTimeFormatter.format(appsContext, new Timestamp(date.getTime()));
    }

    public static String format(AppsContext appsContext, Timestamp timestamp) {
        Locale locale = SessionInfo.getDateLocale(appsContext);
        String string = SessionInfo.getDateFormatMask(appsContext) + ORACLE_TIME_FORMAT_DEFAULT;
        return AppsDateFormatter.format(timestamp, 10, string, 9, locale);
    }

    public static String getDateTimeFormatMaskExample(AppsContext appsContext) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 11, 31, 20, 45, 0);
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTime().getTime());
        Locale locale = SessionInfo.getDateLocale(appsContext);
        String string = SessionInfo.getDateFormatMask(appsContext) + ORACLE_TIME_FORMAT_DEFAULT;
        return AppsDateFormatter.format(timestamp, 10, string, 9, locale);
    }

    public Timestamp parse(String string) {
        Date date = this.m_DateFormatter.parse(string);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp parse(AppsContext appsContext, String string) {
        Locale locale = SessionInfo.getDateLocale(appsContext);
        String string2 = SessionInfo.getDateFormatMask(appsContext) + ORACLE_TIME_FORMAT_DEFAULT;
        Date date = AppsDateFormatter.parse(string, 10, string2, 9, locale);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public void setCalendar(int n) {
        this.m_DateFormatter.setCalendar(n);
    }

    public void setCalendar(String string) {
        this.m_DateFormatter.setCalendar(string);
    }

    public void setLenient(boolean bl) {
        this.m_DateFormatter.setLenient(bl);
    }

    public boolean isLenient() {
        return this.m_DateFormatter.isLenient();
    }
}

