/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.text.DecimalFormat;
import oracle.apps.fnd.i18n.common.text.DecimalFormatSymbols;
import oracle.apps.fnd.i18n.common.text.NumberFormatter;
import oracle.apps.fnd.i18n.text.AppsNumberFormatterContext;

public class AppsNumberFormatter {
    public static final String RCS_ID = "$Header: AppsNumberFormatter.java 120.0 2005/05/07 08:21:44 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsNumberFormatter.java 120.0 2005/05/07 08:21:44 appldev ship $", "oracle.apps.fnd.i18n.text");
    private static final int CACHE_SIZE = 100;
    private static Hashtable m_CachedNumberFormatter = new Hashtable(100);
    private DecimalFormat m_DecimalFormatter;
    private DecimalFormat m_DecimalParser;

    public AppsNumberFormatter(AppsContext appsContext) {
        this(new AppsNumberFormatterContext(appsContext));
    }

    public AppsNumberFormatter(AppsNumberFormatterContext appsNumberFormatterContext) {
        Locale locale = appsNumberFormatterContext.getLocale();
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        int n2 = appsNumberFormatterContext.getParseMaskType();
        String string2 = appsNumberFormatterContext.getParseMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        decimalFormatSymbols.setGroupingSeparator(cArray[1]);
        decimalFormatSymbols.setDecimalSeparator(cArray[0]);
        this.m_DecimalFormatter = new DecimalFormat(n, string, locale);
        this.m_DecimalFormatter.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_DecimalFormatter.setRoundingMode(4);
        this.m_DecimalParser = new DecimalFormat(n2, string2, locale);
        this.m_DecimalParser.setDecimalFormatSymbols(decimalFormatSymbols);
        this.m_DecimalParser.setRoundingMode(4);
    }

    public String format(double d) {
        return this.m_DecimalFormatter.format(d).replace('\u00a0', ' ');
    }

    public String format(long l) {
        return this.m_DecimalFormatter.format(l).replace('\u00a0', ' ');
    }

    public String format(BigDecimal bigDecimal) {
        return this.m_DecimalFormatter.format(bigDecimal).replace('\u00a0', ' ');
    }

    public String format(BigInteger bigInteger) {
        return this.m_DecimalFormatter.format(bigInteger).replace('\u00a0', ' ');
    }

    public String format(Number number) {
        return this.m_DecimalFormatter.format(number).replace('\u00a0', ' ');
    }

    public static String format(AppsContext appsContext, double d) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.format(appsNumberFormatterContext, d);
    }

    public static String format(AppsContext appsContext, long l) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.format(appsNumberFormatterContext, l);
    }

    public static String format(AppsContext appsContext, BigInteger bigInteger) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.format(appsNumberFormatterContext, bigInteger);
    }

    public static String format(AppsContext appsContext, BigDecimal bigDecimal) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.format(appsNumberFormatterContext, bigDecimal);
    }

    public static String format(AppsContext appsContext, Number number) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.format(appsNumberFormatterContext, number);
    }

    public static String format(AppsNumberFormatterContext appsNumberFormatterContext, double d) {
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        Locale locale = appsNumberFormatterContext.getLocale();
        NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
        return numberFormatter.format(d, n, string, cArray).replace('\u00a0', ' ');
    }

    public static String format(AppsNumberFormatterContext appsNumberFormatterContext, long l) {
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        Locale locale = appsNumberFormatterContext.getLocale();
        NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
        return numberFormatter.format(l, n, string, cArray).replace('\u00a0', ' ');
    }

    public static String format(AppsNumberFormatterContext appsNumberFormatterContext, BigInteger bigInteger) {
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        Locale locale = appsNumberFormatterContext.getLocale();
        NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
        return numberFormatter.format(bigInteger, n, string, cArray).replace('\u00a0', ' ');
    }

    public static String format(AppsNumberFormatterContext appsNumberFormatterContext, BigDecimal bigDecimal) {
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        Locale locale = appsNumberFormatterContext.getLocale();
        NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
        return numberFormatter.format(bigDecimal, n, string, cArray).replace('\u00a0', ' ');
    }

    public static String format(AppsNumberFormatterContext appsNumberFormatterContext, Number number) {
        int n = appsNumberFormatterContext.getFormatMaskType();
        String string = appsNumberFormatterContext.getFormatMask();
        char[] cArray = appsNumberFormatterContext.getNumericChars();
        Locale locale = appsNumberFormatterContext.getLocale();
        NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
        return numberFormatter.format(number, n, string, cArray).replace('\u00a0', ' ');
    }

    public static String formatCanonical(Number number) {
        try {
            return number.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Number parse(String string) {
        try {
            return this.m_DecimalParser.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Number parse(AppsContext appsContext, String string) {
        AppsNumberFormatterContext appsNumberFormatterContext = new AppsNumberFormatterContext(appsContext);
        return AppsNumberFormatter.parse(appsNumberFormatterContext, string);
    }

    public static Number parse(AppsNumberFormatterContext appsNumberFormatterContext, String string) {
        try {
            char[] cArray = appsNumberFormatterContext.getNumericChars();
            AppsNumberFormatter.preValidate(string, cArray);
            int n = appsNumberFormatterContext.getParseMaskType();
            String string2 = appsNumberFormatterContext.getParseMask();
            Locale locale = appsNumberFormatterContext.getLocale();
            NumberFormatter numberFormatter = AppsNumberFormatter.getNumberFormatter(locale);
            return numberFormatter.parse(string, n, string2, cArray);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Number parseCanonical(String string) {
        try {
            return new BigDecimal(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void preValidate(String string, char[] cArray) throws ParseException {
        String string2 = string.trim();
        int n = 0;
        char c = cArray[0];
        char c2 = cArray[1];
        for (int i = 0; i < string2.length(); ++i) {
            char c3 = string2.charAt(i);
            if (i == 0 && (c3 == '+' || c3 == '-' || c3 == '<' || c3 == '(' || c3 == '$') || i == string2.length() - 1 && (c3 == '+' || c3 == '-' || c3 == '>' || c3 == ')' || c3 == '$')) continue;
            if (c3 == c) {
                ++n;
                continue;
            }
            if (n > 1) {
                throw new ParseException("", 0);
            }
            if (Character.isDigit(c3) || c3 == c2) continue;
            throw new ParseException("", 0);
        }
    }

    private static NumberFormatter getNumberFormatter(Locale locale) {
        NumberFormatter numberFormatter = (NumberFormatter)m_CachedNumberFormatter.get(locale);
        if (numberFormatter == null) {
            numberFormatter = NumberFormatter.getInstance(locale);
            numberFormatter.setRoundingMode(4);
            m_CachedNumberFormatter.put(locale, numberFormatter);
        }
        return numberFormatter;
    }
}

