/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.text;

import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.util.NLSMapper;
import oracle.apps.fnd.i18n.util.SessionInfo;

public class AppsNumberFormatterContext {
    public static final String RCS_ID = "$Header: AppsNumberFormatterContext.java 120.0 2005/05/07 08:21:46 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsNumberFormatterContext.java 120.0 2005/05/07 08:21:46 appldev ship $", "oracle.apps.fnd.i18n.text");
    public static final int FORMAT_ORACLE = 10;
    public static final int FORMAT_JAVA = 11;
    private static final String NUMBER_PARSE_MASK_DEFAULT = "###,###,##0.##################;-###,###,##0.##################";
    private static final String NUMBER_FORMAT_MASK_DEFAULT = "########0.##################;-########0.##################";
    private Locale m_Locale = Locale.US;
    private char[] m_NumericChars = new char[]{'.', ','};
    private int m_FormatMaskType = 11;
    private int m_ParseMaskType = 11;
    private String m_FormatMask = "########0.##################;-########0.##################";
    private String m_ParseMask = "###,###,##0.##################;-###,###,##0.##################";
    private static Hashtable m_CachedDecimalFormatSymbols = new Hashtable();

    public AppsNumberFormatterContext(String string, String string2) {
        this(NLSMapper.getLocale(string, string2));
    }

    public AppsNumberFormatterContext(AppsContext appsContext) {
        this.m_Locale = SessionInfo.getUserLocale(appsContext);
        String string = SessionInfo.getNumericCharacters(appsContext);
        char[] cArray = new char[]{string.charAt(0), string.charAt(1)};
        this.m_NumericChars = cArray;
    }

    public AppsNumberFormatterContext(Locale locale) {
        this.m_Locale = locale;
        DecimalFormatSymbols decimalFormatSymbols = AppsNumberFormatterContext.getDecimalFormatSymbols(locale);
        char[] cArray = new char[]{decimalFormatSymbols.getDecimalSeparator(), decimalFormatSymbols.getGroupingSeparator()};
        this.m_NumericChars = cArray;
    }

    private static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)m_CachedDecimalFormatSymbols.get(locale);
        if (decimalFormatSymbols == null) {
            decimalFormatSymbols = new DecimalFormatSymbols(locale);
            m_CachedDecimalFormatSymbols.put(locale, decimalFormatSymbols);
        }
        return decimalFormatSymbols;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public char[] getNumericChars() {
        return this.m_NumericChars;
    }

    public int getFormatMaskType() {
        return this.m_FormatMaskType;
    }

    public int getParseMaskType() {
        return this.m_ParseMaskType;
    }

    public String getFormatMask() {
        return this.m_FormatMask;
    }

    public String getParseMask() {
        return this.m_ParseMask;
    }

    public void setNumericChars(char[] cArray) {
        this.m_NumericChars = cArray;
    }

    public void setFormatMask(String string, int n) {
        this.m_FormatMask = string;
        this.m_FormatMaskType = n;
    }

    public void setParseMask(String string, int n) {
        this.m_ParseMask = string;
        this.m_ParseMaskType = n;
    }
}

