/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.util;

import java.io.UnsupportedEncodingException;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.MimeUtil;
import oracle.apps.fnd.i18n.util.NLSInfo;
import oracle.apps.fnd.i18n.util.NLSMapper;

public class AppsMimeUtil {
    public static final String RCS_ID = "$Header: AppsMimeUtil.java 120.0 2005/05/07 08:21:59 appldev ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: AppsMimeUtil.java 120.0 2005/05/07 08:21:59 appldev ship $", "oracle.apps.fnd.i18n.util");
    public static final int HEADER = 1;
    public static final int PARAMETER = 2;
    private static final int UNKNOWN = 3;

    public static String encodeAttachmentFileName(String string, String string2, String string3) throws UnsupportedEncodingException {
        return AppsMimeUtil.encodeAttachmentFileName(string, string2, string3, 2);
    }

    public static String encodeAttachmentFileName(String string, String string2, String string3, int n) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        if (string2 != null) {
            string2 = AppsMimeUtil.getIANACharsetFromOracle(string2);
        }
        string3 = AppsMimeUtil.getLanguageTagFromOracle(string3);
        switch (n) {
            case 1: {
                string = MimeUtil.encodeHeader(string, string2, "B");
                break;
            }
            case 2: {
                string = MimeUtil.encodeParameter(string, string2, string3);
                break;
            }
        }
        return string;
    }

    public static String decodeAttachmentFileName(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return AppsMimeUtil.decodeAttachmentFileName(string, 3);
    }

    public static String decodeAttachmentFileName(String string, int n) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        switch (n) {
            case 1: {
                string = MimeUtil.decodeHeader(string);
                break;
            }
            case 2: {
                string = MimeUtil.decodeParameter(string);
                break;
            }
            case 3: {
                String string2 = MimeUtil.decodeParameter(string);
                if (string.equals(string2)) {
                    string = MimeUtil.decodeHeader(string);
                    break;
                }
                string = string2;
                break;
            }
        }
        return string;
    }

    private static String getLanguageTagFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return NLSInfo.getLanguageTag(string);
    }

    private static String getIANACharsetFromOracle(String string) {
        if (string == null) {
            return null;
        }
        return NLSMapper.getCharset(10, 12, string);
    }
}

