/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.util;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.MailCharsetMapper;
import oracle.apps.fnd.i18n.common.util.TerritoryMapper;
import oracle.apps.fnd.i18n.util.NLSMapper;

public class NLSInfo {
    public static final String RCS_ID = "$Header: NLSInfo.java 120.11 2012/09/10 19:53:19 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NLSInfo.java 120.11 2012/09/10 19:53:19 rsuzuki ship $", "oracle.apps.fnd.i18n.util");
    private static MailCharsetMapper m_MailCharsetMapper = MailCharsetMapper.getInstance();
    private static TerritoryMapper m_TerritoryMapper = TerritoryMapper.getInstance();
    private static Hashtable m_AppsSupportedLang = new Hashtable();
    private static Hashtable m_LanguageTranslations;

    public static String getMailCharset(String string) {
        return m_MailCharsetMapper.getCharset(string);
    }

    public static String getMailEncoding(String string) {
        return m_MailCharsetMapper.getEncoding(string);
    }

    public static String getDefaultTerritory(String string) {
        return m_TerritoryMapper.getDefaultTerritory(string);
    }

    public static String getLanguageTag(String string) {
        return NLSMapper.getLanguage(10, 14, string.toUpperCase(Locale.US));
    }

    public static boolean isAppsSupportedLanguage(String string) {
        if (string == null) {
            return false;
        }
        String string2 = (String)m_AppsSupportedLang.get(string.toUpperCase(Locale.US));
        if (string2 == null) {
            return false;
        }
        return "Y".equals(string2);
    }

    public static Hashtable getLanguageTranslations() {
        return m_LanguageTranslations;
    }

    public static String getLanguageTranslation(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)m_LanguageTranslations.get(string.toUpperCase(Locale.US));
        return string2;
    }

    static {
        m_AppsSupportedLang.put("US", "Y");
        m_AppsSupportedLang.put("AR", "Y");
        m_AppsSupportedLang.put("PTB", "Y");
        m_AppsSupportedLang.put("FRC", "Y");
        m_AppsSupportedLang.put("HR", "Y");
        m_AppsSupportedLang.put("CS", "Y");
        m_AppsSupportedLang.put("DK", "Y");
        m_AppsSupportedLang.put("NL", "Y");
        m_AppsSupportedLang.put("F", "Y");
        m_AppsSupportedLang.put("SF", "Y");
        m_AppsSupportedLang.put("D", "Y");
        m_AppsSupportedLang.put("EL", "Y");
        m_AppsSupportedLang.put("IW", "Y");
        m_AppsSupportedLang.put("HU", "Y");
        m_AppsSupportedLang.put("I", "Y");
        m_AppsSupportedLang.put("IS", "Y");
        m_AppsSupportedLang.put("JA", "Y");
        m_AppsSupportedLang.put("KO", "Y");
        m_AppsSupportedLang.put("ESA", "Y");
        m_AppsSupportedLang.put("LT", "Y");
        m_AppsSupportedLang.put("N", "Y");
        m_AppsSupportedLang.put("PL", "Y");
        m_AppsSupportedLang.put("PT", "Y");
        m_AppsSupportedLang.put("RO", "Y");
        m_AppsSupportedLang.put("RU", "Y");
        m_AppsSupportedLang.put("ZHS", "Y");
        m_AppsSupportedLang.put("SK", "Y");
        m_AppsSupportedLang.put("SL", "Y");
        m_AppsSupportedLang.put("SQ", "Y");
        m_AppsSupportedLang.put("E", "Y");
        m_AppsSupportedLang.put("S", "Y");
        m_AppsSupportedLang.put("ZHT", "Y");
        m_AppsSupportedLang.put("TH", "Y");
        m_AppsSupportedLang.put("TR", "Y");
        m_AppsSupportedLang.put("VN", "Y");
        m_AppsSupportedLang.put("UK", "Y");
        m_AppsSupportedLang.put("IN", "Y");
        m_AppsSupportedLang.put("CSR", "Y");
        m_AppsSupportedLang.put("LSR", "Y");
        m_AppsSupportedLang.put("CKK", "Y");
        m_AppsSupportedLang.put("CA", "Y");
        m_AppsSupportedLang.put("BG", "Y");
        m_AppsSupportedLang.put("AM", "Y");
        m_AppsSupportedLang.put("HY", "Y");
        m_AppsSupportedLang.put("AZ", "Y");
        m_AppsSupportedLang.put("GB", "Y");
        m_AppsSupportedLang.put("ET", "Y");
        m_AppsSupportedLang.put("LBS", "Y");
        m_AppsSupportedLang.put("LUZ", "Y");
        m_AppsSupportedLang.put("LV", "Y");
        m_AppsSupportedLang.put("MK", "Y");
        m_AppsSupportedLang.put("MS", "Y");
        m_AppsSupportedLang.put("MT", "Y");
        m_AppsSupportedLang.put("ESM", "Y");
        m_AppsSupportedLang.put("SW", "Y");
        m_LanguageTranslations = new Hashtable();
        m_LanguageTranslations.put("SQ", "Shqip");
        m_LanguageTranslations.put("US", "English");
        m_LanguageTranslations.put("AM", "\u12a0\u121b\u122d\u129b");
        m_LanguageTranslations.put("AR", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629");
        m_LanguageTranslations.put("HY", "\u0540\u0561\u0575\u0565\u0580\u0565\u0576");
        m_LanguageTranslations.put("AS", "\u0985\u09b8\u09ae\u09c0\u09df\u09be");
        m_LanguageTranslations.put("AZ", "Az\u0259rbaycan");
        m_LanguageTranslations.put("BN", "\u09ac\u09be\u0982\u09b2\u09be");
        m_LanguageTranslations.put("BE", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f");
        m_LanguageTranslations.put("PTB", "Portugu\u00eas (Brasil)");
        m_LanguageTranslations.put("BG", "\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438");
        m_LanguageTranslations.put("FRC", "Fran\u00e7ais du Canada");
        m_LanguageTranslations.put("CA", "Catal\u00e0");
        m_LanguageTranslations.put("HR", "Hrvatski");
        m_LanguageTranslations.put("CKK", "\u049a\u0430\u0437\u0430\u049b\u0448\u0430 (\u041a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430)");
        m_LanguageTranslations.put("CSR", "\u0421\u0440\u043f\u0441\u043a\u0438 (\u040b\u0438\u0440\u0438\u043b\u0438\u0446\u0430)");
        m_LanguageTranslations.put("CUZ", "\u040e\u0437\u0431\u0435\u043a");
        m_LanguageTranslations.put("CS", "\u010ce\u0161tina");
        m_LanguageTranslations.put("DK", "Dansk");
        m_LanguageTranslations.put("PRS", "\u062f\u0631\u06cc");
        m_LanguageTranslations.put("DV", "\u078b\u07a8\u0788\u07ac\u0780\u07a8");
        m_LanguageTranslations.put("NL", "Nederlands");
        m_LanguageTranslations.put("EG", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629");
        m_LanguageTranslations.put("GB", "British English");
        m_LanguageTranslations.put("ET", "Eesti Keel");
        m_LanguageTranslations.put("SF", "Suomi");
        m_LanguageTranslations.put("F", "Fran\u00e7ais");
        m_LanguageTranslations.put("D", "Deutsch");
        m_LanguageTranslations.put("EL", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03b1");
        m_LanguageTranslations.put("GU", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0 ");
        m_LanguageTranslations.put("IW", "\u05e2\u05d1\u05e8\u05d9\u05ea");
        m_LanguageTranslations.put("HI", "\u0939\u093f\u0928\u094d\u0926\u0940/\u0939\u093f\u0902\u0926\u0940");
        m_LanguageTranslations.put("HU", "Magyar");
        m_LanguageTranslations.put("IS", "\u00cdslenska");
        m_LanguageTranslations.put("IN", "Bahasa Indonesia");
        m_LanguageTranslations.put("GA", "Gaeilge");
        m_LanguageTranslations.put("I", "Italiano");
        m_LanguageTranslations.put("JA", "\u65e5\u672c\u8a9e");
        m_LanguageTranslations.put("KN", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1");
        m_LanguageTranslations.put("KM", "\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a");
        m_LanguageTranslations.put("KO", "\ud55c\uad6d\uc5b4");
        m_LanguageTranslations.put("LO", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ea5\u0eb2\u0ea7");
        m_LanguageTranslations.put("ESA", "Espa\u00f1ol Latinoamericano");
        m_LanguageTranslations.put("LBS", "Bosanski (Latinica)");
        m_LanguageTranslations.put("LSR", "Srpski (Latinica)");
        m_LanguageTranslations.put("LUZ", "O'Zbek");
        m_LanguageTranslations.put("LV", "Latvie\u0161u");
        m_LanguageTranslations.put("LT", "Lietuvi\u0173");
        m_LanguageTranslations.put("MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438");
        m_LanguageTranslations.put("MS", "Melayu");
        m_LanguageTranslations.put("ML", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02");
        m_LanguageTranslations.put("MT", "Malti");
        m_LanguageTranslations.put("MR", "\u092e\u0930\u093e\u0920\u0940");
        m_LanguageTranslations.put("ESM", "Espa\u00f1ol Mexicano");
        m_LanguageTranslations.put("NE", "\u0928\u0947\u092a\u093e\u0932\u0940");
        m_LanguageTranslations.put("N", "Norsk");
        m_LanguageTranslations.put("OR", "\u0b13\u0b21\u0b3c\u0b3f\u0b06");
        m_LanguageTranslations.put("FA", "\u0641\u0627\u0631\u0633\u06cc");
        m_LanguageTranslations.put("PL", "Polski");
        m_LanguageTranslations.put("PT", "Portugu\u00eas");
        m_LanguageTranslations.put("PA", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40");
        m_LanguageTranslations.put("RO", "Rom\u00e2n\u0103");
        m_LanguageTranslations.put("RU", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        m_LanguageTranslations.put("ZHS", "\u7b80\u4f53\u4e2d\u6587");
        m_LanguageTranslations.put("SI", "\u0dc3\u0dd2\u0d82\u0dc4\u0dbd");
        m_LanguageTranslations.put("SK", "Sloven\u010dina");
        m_LanguageTranslations.put("SL", "Sloven\u0161\u010dina");
        m_LanguageTranslations.put("E", "Espa\u00f1ol");
        m_LanguageTranslations.put("SW", "Kiswahili");
        m_LanguageTranslations.put("S", "Svenska");
        m_LanguageTranslations.put("TA", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd");
        m_LanguageTranslations.put("TE", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41");
        m_LanguageTranslations.put("TH", "\u0e44\u0e17\u0e22");
        m_LanguageTranslations.put("ZHT", "\u7e41\u9ad4\u4e2d\u6587");
        m_LanguageTranslations.put("TR", "T\u00fcrk\u00e7e");
        m_LanguageTranslations.put("UK", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430");
        m_LanguageTranslations.put("VN", "Ti\u1ebfng Vi\u1ec7t");
    }
}

