/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.util;

import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.common.util.CharsetMapper;
import oracle.apps.fnd.i18n.common.util.LanguageMapper;
import oracle.apps.fnd.i18n.common.util.LocaleMapper;
import oracle.apps.fnd.i18n.common.util.MailCharsetMapper;
import oracle.apps.fnd.i18n.common.util.TerritoryMapper;
import oracle.apps.fnd.i18n.util.NLSInfo;

public class NLSMapper {
    public static final String RCS_ID = "$Header: NLSMapper.java 120.5 2014/10/23 21:17:07 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: NLSMapper.java 120.5 2014/10/23 21:17:07 rsuzuki ship $", "oracle.apps.fnd.i18n.util");
    public static final int ORACLE = 10;
    public static final int ORACLE_CODE = 13;
    public static final int JAVA = 11;
    public static final int IANA = 12;
    public static final int LANGUAGE_TAG = 14;
    private static CharsetMapper m_CharsetMapper = CharsetMapper.getInstance();
    private static LanguageMapper m_LanguageMapper = LanguageMapper.getInstance();
    private static LocaleMapper m_LocaleMapper = LocaleMapper.getInstance();
    private static TerritoryMapper m_TerritoryMapper = TerritoryMapper.getInstance();
    private static MailCharsetMapper m_MailCharsetMapper = MailCharsetMapper.getInstance();

    public static String getCharset(int n, int n2, String string) {
        String string2 = null;
        block0 : switch (n) {
            case 10: {
                switch (n2) {
                    case 10: {
                        string2 = m_CharsetMapper.getCharset(10, 10, string);
                        break;
                    }
                    case 11: {
                        string2 = m_CharsetMapper.getCharset(10, 11, string);
                        break;
                    }
                    case 12: {
                        string2 = m_CharsetMapper.getCharset(10, 12, string);
                    }
                }
                break;
            }
            case 11: {
                switch (n2) {
                    case 10: {
                        string2 = m_CharsetMapper.getCharset(11, 10, string);
                        break;
                    }
                    case 11: {
                        string2 = m_CharsetMapper.getCharset(11, 11, string);
                        break;
                    }
                    case 12: {
                        string2 = m_CharsetMapper.getCharset(11, 12, string);
                    }
                }
                break;
            }
            case 12: {
                switch (n2) {
                    case 10: {
                        string2 = m_CharsetMapper.getCharset(12, 10, string);
                        break block0;
                    }
                    case 11: {
                        string2 = m_CharsetMapper.getCharset(12, 11, string);
                        break block0;
                    }
                    case 12: {
                        string2 = m_CharsetMapper.getCharset(12, 12, string);
                    }
                }
            }
        }
        return string2;
    }

    public static String getTerritory(int n, int n2, String string) {
        String string2 = null;
        block0 : switch (n) {
            case 11: {
                switch (n2) {
                    case 11: {
                        string2 = string;
                        break;
                    }
                    case 10: {
                        string2 = m_TerritoryMapper.getOracleTerritory(string);
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 11: {
                        string2 = m_TerritoryMapper.getJavaTerritory(string);
                        break block0;
                    }
                    case 10: {
                        string2 = string;
                    }
                }
            }
        }
        return string2;
    }

    public static String getLanguage(int n, int n2, String string) {
        String string2 = null;
        block0 : switch (n) {
            case 11: {
                switch (n2) {
                    case 11: {
                        string2 = m_LanguageMapper.getLanguage(11, 11, string);
                        break;
                    }
                    case 10: {
                        string2 = m_LanguageMapper.getLanguage(11, 10, string);
                        break;
                    }
                    case 13: {
                        string2 = m_LanguageMapper.getLanguage(11, 12, string);
                        break;
                    }
                    case 14: {
                        string2 = m_LanguageMapper.getLanguage(11, 13, string);
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 11: {
                        string2 = m_LanguageMapper.getLanguage(10, 11, string);
                        break;
                    }
                    case 10: {
                        string2 = m_LanguageMapper.getLanguage(10, 10, string);
                        break;
                    }
                    case 13: {
                        string2 = m_LanguageMapper.getLanguage(10, 12, string);
                        break;
                    }
                    case 14: {
                        string2 = m_LanguageMapper.getLanguage(10, 13, string);
                    }
                }
                break;
            }
            case 13: {
                switch (n2) {
                    case 11: {
                        string2 = m_LanguageMapper.getLanguage(12, 11, string);
                        break;
                    }
                    case 10: {
                        string2 = m_LanguageMapper.getLanguage(12, 10, string);
                        break;
                    }
                    case 13: {
                        string2 = m_LanguageMapper.getLanguage(12, 12, string);
                        break;
                    }
                    case 14: {
                        string2 = m_LanguageMapper.getLanguage(12, 13, string);
                    }
                }
                break;
            }
            case 14: {
                if (string != null) {
                    if ("ar-eg".equals(string.toLowerCase(Locale.US))) {
                        string = "ar";
                    } else if ("en-gb".equals(string.toLowerCase(Locale.US))) {
                        string = "en";
                    } else if ("es-mx".equals(string.toLowerCase(Locale.US))) {
                        string = "es-us";
                    }
                }
                switch (n2) {
                    case 11: {
                        string2 = m_LanguageMapper.getLanguage(13, 11, string);
                        break block0;
                    }
                    case 10: {
                        string2 = m_LanguageMapper.getLanguage(13, 10, string);
                        break block0;
                    }
                    case 13: {
                        string2 = m_LanguageMapper.getLanguage(13, 12, string);
                        break block0;
                    }
                    case 14: {
                        string2 = m_LanguageMapper.getLanguage(13, 13, string);
                    }
                }
            }
        }
        return string2;
    }

    public static Locale getLocale(String string, String string2) {
        if (string == null) {
            string = "AMERICAN";
        }
        if (string2 == null) {
            string2 = "AMERICA";
        }
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        if ("EGYPTIAN".equals(string3)) {
            return new Locale("ar", "EG");
        }
        if ("GERMAN DIN".equals(string3)) {
            return new Locale("de", "DE");
        }
        if ("ENGLISH".equals(string3)) {
            return new Locale("en", "GB");
        }
        if ("MEXICAN SPANISH".equals(string3)) {
            return new Locale("es", "MX");
        }
        if ("LATIN AMERICAN SPANISH".equals(string3)) {
            return new Locale("es", "US");
        }
        if ("CANADIAN FRENCH".equals(string3)) {
            return new Locale("fr", "CA");
        }
        if ("BRAZILIAN PORTUGUESE".equals(string3)) {
            return new Locale("pt", "BR");
        }
        if ("SIMPLIFIED CHINESE".equals(string3)) {
            return new Locale("zh", "CN");
        }
        if ("TRADITIONAL CHINESE".equals(string3)) {
            return new Locale("zh", "TW");
        }
        if ("DARI".equals(string3)) {
            return new Locale("fa", "AF");
        }
        if ("NUMERIC DATE LANGUAGE".equals(string3)) {
            return new Locale("en", "NUMERIC");
        }
        return m_LocaleMapper.getLocale(string3, string4);
    }

    public static String getMailCharset(String string) {
        return NLSInfo.getMailCharset(string);
    }

    public static String getMailEncoding(String string) {
        return NLSInfo.getMailEncoding(string);
    }
}

