/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.util;

import java.util.Hashtable;
import java.util.Locale;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.util.RestrictedAccessException;

public class SSOMapper {
    public static final String RCS_ID = "$Header: SSOMapper.java 120.9 2014/10/23 21:24:11 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: SSOMapper.java 120.9 2014/10/23 21:24:11 rsuzuki ship $", "oracle.apps.fnd.i18n.util");
    private static String m_BaseOracleLanguage = "us";
    private static Hashtable m_OracleToHttp = new Hashtable();
    private static Hashtable m_HttpToOracle = new Hashtable();
    private static Hashtable m_LanguageToTerritory = new Hashtable();

    public SSOMapper(String string) {
        if (!string.equals(m_BaseOracleLanguage)) {
            SSOMapper.rebuildHttpToOracleLangMap();
            m_BaseOracleLanguage = string;
        }
    }

    public SSOMapper(Object object, String string) {
        this.validate(object);
        if (!string.equals(m_BaseOracleLanguage)) {
            SSOMapper.rebuildHttpToOracleLangMap();
            m_BaseOracleLanguage = string;
        }
    }

    public String getOracleLangFromHttp(String string) {
        String string2 = m_BaseOracleLanguage;
        if (string != null && (string2 = (String)m_HttpToOracle.get(string.toLowerCase(Locale.US))) == null) {
            int n = string.indexOf("-");
            if (n != -1) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1, string.length());
                if ((n = string4.indexOf("-")) != -1) {
                    String string5 = string4.substring(0, n);
                    if (string5.length() == 4) {
                        string2 = (String)m_HttpToOracle.get(string3.toLowerCase(Locale.US) + "-" + string5.toLowerCase(Locale.US));
                        if (string2 == null) {
                            string2 = (String)m_HttpToOracle.get(string3.toLowerCase(Locale.US));
                        }
                    } else {
                        string2 = (String)m_HttpToOracle.get(string3.toLowerCase(Locale.US));
                    }
                } else {
                    string2 = (String)m_HttpToOracle.get(string3.toLowerCase(Locale.US));
                }
                if (string2 == null) {
                    string2 = m_BaseOracleLanguage;
                }
            } else {
                string2 = m_BaseOracleLanguage;
            }
            m_HttpToOracle.put(string.toLowerCase(Locale.US), string2);
        }
        return string2;
    }

    public String getHttpLangFromOracle(String string) {
        if (string != null) {
            return (String)m_OracleToHttp.get(string.toLowerCase(Locale.US));
        }
        return null;
    }

    public String getTerritoryCode(String string) {
        if (string != null) {
            return (String)m_LanguageToTerritory.get(string.toLowerCase(Locale.US));
        }
        return null;
    }

    private void validate(Object object) {
        if (object.getClass().getName().indexOf("oracle.apps.fnd.sso.Authenticator") == -1) {
            throw new RestrictedAccessException();
        }
    }

    private static synchronized void rebuildHttpToOracleLangMap() {
        m_HttpToOracle.clear();
        m_HttpToOracle.put("am", "am");
        m_HttpToOracle.put("ar", "ar");
        m_HttpToOracle.put("ar-eg", "eg");
        m_HttpToOracle.put("as", "as");
        m_HttpToOracle.put("az", "az");
        m_HttpToOracle.put("be", "be");
        m_HttpToOracle.put("bg", "bg");
        m_HttpToOracle.put("bn", "bn");
        m_HttpToOracle.put("bs", "lbs");
        m_HttpToOracle.put("bs-latn", "lbs");
        m_HttpToOracle.put("ca", "ca");
        m_HttpToOracle.put("cs", "cs");
        m_HttpToOracle.put("da", "dk");
        m_HttpToOracle.put("de", "d");
        m_HttpToOracle.put("dv", "dv");
        m_HttpToOracle.put("el", "el");
        m_HttpToOracle.put("en", "us");
        m_HttpToOracle.put("en-gb", "gb");
        m_HttpToOracle.put("es", "e");
        m_HttpToOracle.put("es-ar", "esa");
        m_HttpToOracle.put("es-bo", "esa");
        m_HttpToOracle.put("es-cl", "esa");
        m_HttpToOracle.put("es-co", "esa");
        m_HttpToOracle.put("es-cr", "esa");
        m_HttpToOracle.put("es-do", "esa");
        m_HttpToOracle.put("es-ec", "esa");
        m_HttpToOracle.put("es-gt", "esa");
        m_HttpToOracle.put("es-hn", "esa");
        m_HttpToOracle.put("es-mx", "esm");
        m_HttpToOracle.put("es-ni", "esa");
        m_HttpToOracle.put("es-pa", "esa");
        m_HttpToOracle.put("es-pe", "esa");
        m_HttpToOracle.put("es-pr", "esa");
        m_HttpToOracle.put("es-py", "esa");
        m_HttpToOracle.put("es-sv", "esa");
        m_HttpToOracle.put("es-us", "esa");
        m_HttpToOracle.put("es-uy", "esa");
        m_HttpToOracle.put("es-ve", "esa");
        m_HttpToOracle.put("et", "et");
        m_HttpToOracle.put("fa", "fa");
        m_HttpToOracle.put("fa-af", "prs");
        m_HttpToOracle.put("fi", "sf");
        m_HttpToOracle.put("fr", "f");
        m_HttpToOracle.put("fr-ca", "frc");
        m_HttpToOracle.put("ga", "ga");
        m_HttpToOracle.put("gu", "gu");
        m_HttpToOracle.put("he", "iw");
        m_HttpToOracle.put("hi", "hi");
        m_HttpToOracle.put("hr", "hr");
        m_HttpToOracle.put("hu", "hu");
        m_HttpToOracle.put("hy", "hy");
        m_HttpToOracle.put("id", "in");
        m_HttpToOracle.put("in", "in");
        m_HttpToOracle.put("is", "is");
        m_HttpToOracle.put("it", "i");
        m_HttpToOracle.put("iw", "iw");
        m_HttpToOracle.put("ja", "ja");
        m_HttpToOracle.put("kk", "ckk");
        m_HttpToOracle.put("kk-cyrl", "ckk");
        m_HttpToOracle.put("km", "km");
        m_HttpToOracle.put("kn", "kn");
        m_HttpToOracle.put("ko", "ko");
        m_HttpToOracle.put("lo", "lo");
        m_HttpToOracle.put("lt", "lt");
        m_HttpToOracle.put("lv", "lv");
        m_HttpToOracle.put("ml", "ml");
        m_HttpToOracle.put("mr", "mr");
        m_HttpToOracle.put("ms", "ms");
        m_HttpToOracle.put("mk", "mk");
        m_HttpToOracle.put("mt", "mt");
        m_HttpToOracle.put("nb", "n");
        m_HttpToOracle.put("ne", "ne");
        m_HttpToOracle.put("nl", "nl");
        m_HttpToOracle.put("no", "n");
        m_HttpToOracle.put("or", "or");
        m_HttpToOracle.put("pa", "pa");
        m_HttpToOracle.put("pl", "pl");
        m_HttpToOracle.put("pt", "pt");
        m_HttpToOracle.put("pt-br", "ptb");
        m_HttpToOracle.put("ro", "ro");
        m_HttpToOracle.put("ru", "ru");
        m_HttpToOracle.put("sh", "lsr");
        m_HttpToOracle.put("si", "si");
        m_HttpToOracle.put("sk", "sk");
        m_HttpToOracle.put("sl", "sl");
        m_HttpToOracle.put("sq", "sq");
        m_HttpToOracle.put("sr", "csr");
        m_HttpToOracle.put("sr-cyrl", "csr");
        m_HttpToOracle.put("sr-latn", "lsr");
        m_HttpToOracle.put("sv", "s");
        m_HttpToOracle.put("sw", "sw");
        m_HttpToOracle.put("ta", "ta");
        m_HttpToOracle.put("te", "te");
        m_HttpToOracle.put("th", "th");
        m_HttpToOracle.put("tr", "tr");
        m_HttpToOracle.put("uk", "uk");
        m_HttpToOracle.put("uz", "luz");
        m_HttpToOracle.put("uz-cyrl", "cuz");
        m_HttpToOracle.put("uz-latn", "luz");
        m_HttpToOracle.put("vi", "vn");
        m_HttpToOracle.put("zh", "zhs");
        m_HttpToOracle.put("zh-cn", "zhs");
        m_HttpToOracle.put("zh-hk", "zht");
        m_HttpToOracle.put("zh-mo", "zht");
        m_HttpToOracle.put("zh-tw", "zht");
    }

    static {
        m_OracleToHttp.put("am", "am");
        m_OracleToHttp.put("ar", "ar");
        m_OracleToHttp.put("as", "as");
        m_OracleToHttp.put("az", "az");
        m_OracleToHttp.put("be", "be");
        m_OracleToHttp.put("bg", "bg");
        m_OracleToHttp.put("bn", "bn");
        m_OracleToHttp.put("ca", "ca");
        m_OracleToHttp.put("ckk", "kk");
        m_OracleToHttp.put("cs", "cs");
        m_OracleToHttp.put("csr", "sr");
        m_OracleToHttp.put("cuz", "uz");
        m_OracleToHttp.put("d", "de");
        m_OracleToHttp.put("din", "de");
        m_OracleToHttp.put("dk", "da");
        m_OracleToHttp.put("dv", "dv");
        m_OracleToHttp.put("e", "es");
        m_OracleToHttp.put("eg", "ar");
        m_OracleToHttp.put("el", "el");
        m_OracleToHttp.put("esa", "es-us");
        m_OracleToHttp.put("esm", "es-mx");
        m_OracleToHttp.put("et", "et");
        m_OracleToHttp.put("f", "fr");
        m_OracleToHttp.put("fa", "fa");
        m_OracleToHttp.put("frc", "fr-ca");
        m_OracleToHttp.put("ga", "ga");
        m_OracleToHttp.put("gb", "en-gb");
        m_OracleToHttp.put("gu", "gu");
        m_OracleToHttp.put("hi", "hi");
        m_OracleToHttp.put("hr", "hr");
        m_OracleToHttp.put("hu", "hu");
        m_OracleToHttp.put("hy", "hy");
        m_OracleToHttp.put("i", "it");
        m_OracleToHttp.put("in", "id");
        m_OracleToHttp.put("is", "is");
        m_OracleToHttp.put("iw", "he");
        m_OracleToHttp.put("ja", "ja");
        m_OracleToHttp.put("km", "km");
        m_OracleToHttp.put("kn", "kn");
        m_OracleToHttp.put("ko", "ko");
        m_OracleToHttp.put("lbs", "bs");
        m_OracleToHttp.put("lo", "lo");
        m_OracleToHttp.put("lsr", "sh");
        m_OracleToHttp.put("lt", "lt");
        m_OracleToHttp.put("luz", "uz");
        m_OracleToHttp.put("lv", "lv");
        m_OracleToHttp.put("mk", "mk");
        m_OracleToHttp.put("ml", "ml");
        m_OracleToHttp.put("mr", "mr");
        m_OracleToHttp.put("ms", "ms");
        m_OracleToHttp.put("mt", "mt");
        m_OracleToHttp.put("n", "no");
        m_OracleToHttp.put("ne", "ne");
        m_OracleToHttp.put("nl", "nl");
        m_OracleToHttp.put("or", "or");
        m_OracleToHttp.put("pa", "pa");
        m_OracleToHttp.put("pl", "pl");
        m_OracleToHttp.put("prs", "fa-af");
        m_OracleToHttp.put("pt", "pt");
        m_OracleToHttp.put("ptb", "pt-br");
        m_OracleToHttp.put("ro", "ro");
        m_OracleToHttp.put("ru", "ru");
        m_OracleToHttp.put("s", "sv");
        m_OracleToHttp.put("sf", "fi");
        m_OracleToHttp.put("si", "si");
        m_OracleToHttp.put("sk", "sk");
        m_OracleToHttp.put("sl", "sl");
        m_OracleToHttp.put("sq", "sq");
        m_OracleToHttp.put("sw", "sw");
        m_OracleToHttp.put("ta", "ta");
        m_OracleToHttp.put("te", "te");
        m_OracleToHttp.put("th", "th");
        m_OracleToHttp.put("tr", "tr");
        m_OracleToHttp.put("uk", "uk");
        m_OracleToHttp.put("us", "en");
        m_OracleToHttp.put("vn", "vi");
        m_OracleToHttp.put("zhs", "zh-cn");
        m_OracleToHttp.put("zht", "zh-tw");
        SSOMapper.rebuildHttpToOracleLangMap();
        m_LanguageToTerritory.put("sq", "al");
        m_LanguageToTerritory.put("us", "us");
        m_LanguageToTerritory.put("am", "et");
        m_LanguageToTerritory.put("ar", "ae");
        m_LanguageToTerritory.put("hy", "am");
        m_LanguageToTerritory.put("as", "in");
        m_LanguageToTerritory.put("az", "az");
        m_LanguageToTerritory.put("bn", "in");
        m_LanguageToTerritory.put("be", "by");
        m_LanguageToTerritory.put("ptb", "br");
        m_LanguageToTerritory.put("bg", "bg");
        m_LanguageToTerritory.put("frc", "ca");
        m_LanguageToTerritory.put("ca", "es");
        m_LanguageToTerritory.put("hr", "hr");
        m_LanguageToTerritory.put("ckk", "kz");
        m_LanguageToTerritory.put("csr", "rs");
        m_LanguageToTerritory.put("cuz", "uz");
        m_LanguageToTerritory.put("cs", "cz");
        m_LanguageToTerritory.put("dk", "dk");
        m_LanguageToTerritory.put("prs", "af");
        m_LanguageToTerritory.put("dv", "md");
        m_LanguageToTerritory.put("nl", "nl");
        m_LanguageToTerritory.put("eg", "eg");
        m_LanguageToTerritory.put("gb", "gb");
        m_LanguageToTerritory.put("et", "ee");
        m_LanguageToTerritory.put("sf", "fi");
        m_LanguageToTerritory.put("f", "fr");
        m_LanguageToTerritory.put("d", "de");
        m_LanguageToTerritory.put("din", "de");
        m_LanguageToTerritory.put("el", "gr");
        m_LanguageToTerritory.put("gu", "in");
        m_LanguageToTerritory.put("iw", "il");
        m_LanguageToTerritory.put("hi", "in");
        m_LanguageToTerritory.put("hu", "hu");
        m_LanguageToTerritory.put("is", "is");
        m_LanguageToTerritory.put("in", "id");
        m_LanguageToTerritory.put("ga", "ie");
        m_LanguageToTerritory.put("i", "it");
        m_LanguageToTerritory.put("ja", "jp");
        m_LanguageToTerritory.put("kn", "in");
        m_LanguageToTerritory.put("km", "kh");
        m_LanguageToTerritory.put("ko", "kr");
        m_LanguageToTerritory.put("lo", "la");
        m_LanguageToTerritory.put("esa", "us");
        m_LanguageToTerritory.put("lbs", "ba");
        m_LanguageToTerritory.put("lsr", "rs");
        m_LanguageToTerritory.put("luz", "uz");
        m_LanguageToTerritory.put("lv", "lv");
        m_LanguageToTerritory.put("lt", "lt");
        m_LanguageToTerritory.put("mk", "mk");
        m_LanguageToTerritory.put("ms", "my");
        m_LanguageToTerritory.put("ml", "in");
        m_LanguageToTerritory.put("mt", "mt");
        m_LanguageToTerritory.put("mr", "in");
        m_LanguageToTerritory.put("esm", "mx");
        m_LanguageToTerritory.put("ne", "np");
        m_LanguageToTerritory.put("n", "no");
        m_LanguageToTerritory.put("or", "in");
        m_LanguageToTerritory.put("fa", "ir");
        m_LanguageToTerritory.put("pl", "pl");
        m_LanguageToTerritory.put("pt", "pt");
        m_LanguageToTerritory.put("pa", "in");
        m_LanguageToTerritory.put("ro", "ro");
        m_LanguageToTerritory.put("ru", "ru");
        m_LanguageToTerritory.put("zhs", "cn");
        m_LanguageToTerritory.put("si", "lk");
        m_LanguageToTerritory.put("sk", "sk");
        m_LanguageToTerritory.put("sl", "si");
        m_LanguageToTerritory.put("e", "es");
        m_LanguageToTerritory.put("sw", "ke");
        m_LanguageToTerritory.put("s", "se");
        m_LanguageToTerritory.put("ta", "in");
        m_LanguageToTerritory.put("te", "in");
        m_LanguageToTerritory.put("th", "th");
        m_LanguageToTerritory.put("zht", "tw");
        m_LanguageToTerritory.put("tr", "tr");
        m_LanguageToTerritory.put("uk", "ua");
        m_LanguageToTerritory.put("vn", "vn");
    }
}

