/*
 * Decompiled with CFR 0.152.
 */
package oracle.apps.fnd.i18n.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import oracle.apps.fnd.common.AppsContext;
import oracle.apps.fnd.common.EnvironmentStore;
import oracle.apps.fnd.common.VersionInfo;
import oracle.apps.fnd.i18n.util.NLSMapper;

public class SessionInfo {
    public static final String RCS_ID = "$Header: SessionInfo.java 120.4 2011/06/25 02:15:38 rsuzuki ship $";
    public static final boolean RCS_ID_RECORDED = VersionInfo.recordClassVersion("$Header: SessionInfo.java 120.4 2011/06/25 02:15:38 rsuzuki ship $", "oracle.apps.fnd.i18n.util");
    public static final int ORACLE = 10;
    public static final int JAVA = 11;
    private static String m_DatabaseVersion = null;

    public static String getLanguage(AppsContext appsContext) {
        String string;
        String string2 = null;
        string2 = appsContext.getEnvStore().getEnv("NLS_LANGUAGE");
        if (string2 == null && (string = appsContext.getEnvStore().getEnv("NLS_LANG")) != null) {
            int n = string.indexOf(95);
            string2 = string.substring(0, n);
        }
        string2 = string2 == null ? "AMERICAN" : string2.trim().toUpperCase(Locale.US);
        return string2;
    }

    public static String getTerritory(AppsContext appsContext) {
        String string;
        String string2 = null;
        string2 = appsContext.getEnvStore().getEnv("NLS_TERRITORY");
        if (string2 == null && (string = appsContext.getEnvStore().getEnv("NLS_LANG")) != null) {
            int n = string.indexOf(95);
            int n2 = string.indexOf(46);
            string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
        }
        string2 = string2 == null ? "AMERICA" : string2.trim().toUpperCase(Locale.US);
        return string2;
    }

    public static String getDateFormatMask(AppsContext appsContext) {
        String string = SessionInfo.getNLSData(appsContext, "NLS_DATE_FORMAT", "ICX_DATE_FORMAT_MASK", "DD-MON-RRRR");
        if (string.indexOf("YYYY") != -1) {
            string = SessionInfo.replace(string, "YYYY", "RRRR");
        } else if (string.indexOf("YY") != -1) {
            string = SessionInfo.replace(string, "YY", "RRRR");
        } else if (string.indexOf("RRRR") == -1 && string.indexOf("RR") != -1) {
            string = SessionInfo.replace(string, "RR", "RRRR");
        }
        return string;
    }

    public static String getDateLanguage(AppsContext appsContext) {
        return SessionInfo.getNLSData(appsContext, "NLS_DATE_LANGUAGE", "ICX_DATE_LANGUAGE", "AMERICAN");
    }

    public static boolean isNumericLanguage(AppsContext appsContext) {
        String string = SessionInfo.getLanguage(appsContext);
        String string2 = SessionInfo.getDateLanguage(appsContext);
        return "ARABIC".equals(string) || "NUMERIC DATE LANGUAGE".equals(string) || "NUMERIC DATE LANGUAGE".equals(string2);
    }

    public static String getNumericCharacters(AppsContext appsContext) {
        return SessionInfo.getNLSData(appsContext, "NLS_NUMERIC_CHARACTERS", "ICX_NUMERIC_CHARACTERS", ".,");
    }

    public static char getGroupingSeparator(AppsContext appsContext) {
        String string = SessionInfo.getNumericCharacters(appsContext);
        if (string != null && string.length() > 1) {
            return string.charAt(1);
        }
        return ',';
    }

    public static char getDecimalSeparator(AppsContext appsContext) {
        String string = SessionInfo.getNumericCharacters(appsContext);
        if (string != null && string.length() > 0) {
            return string.charAt(0);
        }
        return '.';
    }

    public static String getSortLanguage(AppsContext appsContext) {
        return SessionInfo.getNLSData(appsContext, "NLS_SORT", "ICX_NLS_SORT", "BINARY");
    }

    public static String getCurrencySymbol(AppsContext appsContext) {
        String string = appsContext.getEnvStore().getEnv("NLS_CURRENCY");
        if (string == null && (string = SessionInfo.getNLSDataFromDB(appsContext, "NLS_CURRENCY")) == null) {
            string = "$";
        }
        return string;
    }

    public static String getClientIANAEncoding(AppsContext appsContext) {
        return appsContext.getProfileStore().getProfile("ICX_CLIENT_IANA_ENCODING");
    }

    public static String getDatabaseVersion(AppsContext appsContext) {
        if (m_DatabaseVersion == null) {
            m_DatabaseVersion = SessionInfo.getDBVersionFromDB(appsContext);
        }
        return m_DatabaseVersion;
    }

    public static String getNativeClientEncoding(AppsContext appsContext, int n) {
        String string = appsContext.getProfileStore().getProfile("FND_NATIVE_CLIENT_ENCODING");
        if (string == null || "".equals(string)) {
            string = SessionInfo.getClientIANAEncoding(appsContext);
            string = NLSMapper.getCharset(11, 10, string);
        }
        switch (n) {
            case 10: {
                break;
            }
            case 11: {
                string = NLSMapper.getCharset(10, 11, string);
                break;
            }
        }
        return string;
    }

    public static Locale getUserLocale(AppsContext appsContext) {
        Locale locale = null;
        try {
            if (appsContext == null) {
                return new Locale("en", "US");
            }
            String string = SessionInfo.getLanguage(appsContext);
            String string2 = SessionInfo.getTerritory(appsContext);
            locale = NLSMapper.getLocale(string.trim(), string2.trim());
            if (locale == null) {
                locale = new Locale("en", "US");
            }
        }
        catch (Exception exception) {
            locale = new Locale("en", "US");
        }
        return locale;
    }

    public static Locale getDateLocale(AppsContext appsContext) {
        Locale locale = null;
        try {
            if (appsContext == null) {
                return new Locale("en", "US");
            }
            String string = SessionInfo.getDateLanguage(appsContext);
            String string2 = SessionInfo.getTerritory(appsContext);
            locale = NLSMapper.getLocale(string.trim(), string2.trim());
            if (locale == null) {
                locale = new Locale("en", "US");
            }
        }
        catch (Exception exception) {
            locale = new Locale("en", "US");
        }
        return locale;
    }

    private static String getNLSData(AppsContext appsContext, String string, String string2, String string3) {
        EnvironmentStore environmentStore = appsContext.getEnvStore();
        String string4 = environmentStore.getEnv(string);
        if (string4 == null) {
            string4 = appsContext.getProfileStore().getProfile(string2);
        }
        if (string4 == null) {
            string4 = SessionInfo.getNLSDataFromDB(appsContext, string);
        } else {
            environmentStore.setEnv(string, string4);
        }
        if (string4 == null) {
            string4 = string3;
        }
        return string4.toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNLSDataFromDB(AppsContext appsContext, String string) {
        Connection connection = appsContext.getJDBCConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        String string3 = "select value from v$nls_parameters where parameter = '" + string + "'";
        try {
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                appsContext.releaseJDBCConnection();
            }
            catch (Exception exception) {}
        }
        return string2.toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDBVersionFromDB(AppsContext appsContext) {
        String string;
        int n;
        Connection connection = appsContext.getJDBCConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        String string3 = null;
        String string4 = "select banner from v$version where rownum = 1";
        try {
            preparedStatement = connection.prepareStatement(string4);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string3 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                appsContext.releaseJDBCConnection();
            }
            catch (Exception exception) {}
        }
        if (string3 != null && (n = string3.indexOf(string = "Release ")) != -1) {
            string2 = string3.substring(n += string.length(), string3.indexOf(" ", n));
        }
        return string2;
    }

    private static String replace(String string, String string2, String string3) {
        if (string2 == null || "".equals(string2) || string == null || "".equals(string)) {
            return string;
        }
        int n = string2.length();
        int n2 = string.length();
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = string.indexOf(string2);
        int n4 = 0;
        while (n3 != -1) {
            stringBuffer.append(string.substring(n4, n3));
            stringBuffer.append(string3);
            n4 = n3 + n;
            n3 = string.indexOf(string2, n4);
        }
        stringBuffer.append(string.substring(n4, n2));
        return stringBuffer.toString();
    }
}

